/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.DSLNode;
import com.oracle.truffle.api.dsl.internal.DSLShare;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.core.ArrayGetTailNode;
import org.jruby.truffle.nodes.core.ArrayGuards;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyArray;

@GeneratedBy(value=ArrayGetTailNode.class)
public final class ArrayGetTailNodeFactory
extends NodeFactoryBase<ArrayGetTailNode> {
    private static ArrayGetTailNodeFactory instance;

    private ArrayGetTailNodeFactory() {
        super(ArrayGetTailNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, Integer.TYPE, RubyNode.class}});
    }

    @Override
    public ArrayGetTailNode createNode(Object ... arguments) {
        if (arguments.length == 4 && (arguments[0] == null || arguments[0] instanceof RubyContext) && (arguments[1] == null || arguments[1] instanceof SourceSection) && arguments[2] instanceof Integer && (arguments[3] == null || arguments[3] instanceof RubyNode)) {
            return ArrayGetTailNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (Integer)arguments[2], (RubyNode)arguments[3]);
        }
        throw new IllegalArgumentException("Invalid create signature.");
    }

    public static ArrayGetTailNode create(RubyContext context, SourceSection sourceSection, int index2, RubyNode array) {
        return ArrayGetTailUninitializedNode.create0(context, sourceSection, index2, array);
    }

    public static NodeFactory<ArrayGetTailNode> getInstance() {
        if (instance == null) {
            instance = new ArrayGetTailNodeFactory();
        }
        return instance;
    }

    @GeneratedBy(value=ArrayGetTailNode.class)
    @NodeInfo(cost=NodeCost.POLYMORPHIC)
    private static final class ArrayGetTailPolymorphicNode
    extends ArrayGetTailBaseNode {
        @CompilerDirectives.CompilationFinal
        private Class<?> arrayPolymorphicType;

        ArrayGetTailPolymorphicNode(ArrayGetTailBaseNode copy) {
            super(copy);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyArray value2;
            try {
                value2 = this.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value2;
        }

        @Override
        public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
            Object arrayValue = this.array.execute(frameValue);
            return this.next0.executeChained0(frameValue, arrayValue);
        }

        @Override
        public void updateTypes0(Class<?>[] types) {
            this.arrayPolymorphicType = types[0];
        }

        @Override
        protected RubyArray executeChained0(VirtualFrame frameValue, Object arrayValue) {
            return this.next0.executeChained0(frameValue, arrayValue);
        }
    }

    @GeneratedBy(value=ArrayGetTailNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ArrayGetTailRubyArray4Node
    extends ArrayGetTailBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArrayGetTailRubyArray4Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class}, 0, 0);

        ArrayGetTailRubyArray4Node(ArrayGetTailBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyArray value2;
            try {
                value2 = this.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value2;
        }

        @Override
        public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
            RubyArray arrayValue;
            try {
                arrayValue = this.array.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected arrayValue instanceof RubyArray");
            }
            if (ArrayGuards.isObject(arrayValue)) {
                return super.getTailObject(arrayValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, "One of guards [isObject] failed");
        }

        @Override
        protected RubyArray executeChained0(VirtualFrame frameValue, Object arrayValue) {
            RubyArray arrayValueCast;
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && ArrayGuards.isObject(arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue))) {
                return super.getTailObject(arrayValueCast);
            }
            return this.next0.executeChained0(frameValue, arrayValue);
        }

        static ArrayGetTailNode create0(ArrayGetTailNode current2) {
            return new ArrayGetTailRubyArray4Node((ArrayGetTailBaseNode)current2);
        }
    }

    @GeneratedBy(value=ArrayGetTailNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ArrayGetTailRubyArray3Node
    extends ArrayGetTailBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArrayGetTailRubyArray3Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class}, 0, 0);

        ArrayGetTailRubyArray3Node(ArrayGetTailBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyArray value2;
            try {
                value2 = this.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value2;
        }

        @Override
        public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
            RubyArray arrayValue;
            try {
                arrayValue = this.array.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected arrayValue instanceof RubyArray");
            }
            if (ArrayGuards.isFloat(arrayValue)) {
                return super.getTailFloat(arrayValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, "One of guards [isFloat] failed");
        }

        @Override
        protected RubyArray executeChained0(VirtualFrame frameValue, Object arrayValue) {
            RubyArray arrayValueCast;
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && ArrayGuards.isFloat(arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue))) {
                return super.getTailFloat(arrayValueCast);
            }
            return this.next0.executeChained0(frameValue, arrayValue);
        }

        static ArrayGetTailNode create0(ArrayGetTailNode current2) {
            return new ArrayGetTailRubyArray3Node((ArrayGetTailBaseNode)current2);
        }
    }

    @GeneratedBy(value=ArrayGetTailNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ArrayGetTailRubyArray2Node
    extends ArrayGetTailBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArrayGetTailRubyArray2Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class}, 0, 0);

        ArrayGetTailRubyArray2Node(ArrayGetTailBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyArray value2;
            try {
                value2 = this.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value2;
        }

        @Override
        public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
            RubyArray arrayValue;
            try {
                arrayValue = this.array.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected arrayValue instanceof RubyArray");
            }
            if (ArrayGuards.isLongFixnum(arrayValue)) {
                return super.getTailLongFixnum(arrayValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, "One of guards [isLongFixnum] failed");
        }

        @Override
        protected RubyArray executeChained0(VirtualFrame frameValue, Object arrayValue) {
            RubyArray arrayValueCast;
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && ArrayGuards.isLongFixnum(arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue))) {
                return super.getTailLongFixnum(arrayValueCast);
            }
            return this.next0.executeChained0(frameValue, arrayValue);
        }

        static ArrayGetTailNode create0(ArrayGetTailNode current2) {
            return new ArrayGetTailRubyArray2Node((ArrayGetTailBaseNode)current2);
        }
    }

    @GeneratedBy(value=ArrayGetTailNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ArrayGetTailRubyArray1Node
    extends ArrayGetTailBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArrayGetTailRubyArray1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class}, 0, 0);

        ArrayGetTailRubyArray1Node(ArrayGetTailBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyArray value2;
            try {
                value2 = this.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value2;
        }

        @Override
        public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
            RubyArray arrayValue;
            try {
                arrayValue = this.array.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected arrayValue instanceof RubyArray");
            }
            if (ArrayGuards.isIntegerFixnum(arrayValue)) {
                return super.getTailIntegerFixnum(arrayValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, "One of guards [isIntegerFixnum] failed");
        }

        @Override
        protected RubyArray executeChained0(VirtualFrame frameValue, Object arrayValue) {
            RubyArray arrayValueCast;
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && ArrayGuards.isIntegerFixnum(arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue))) {
                return super.getTailIntegerFixnum(arrayValueCast);
            }
            return this.next0.executeChained0(frameValue, arrayValue);
        }

        static ArrayGetTailNode create0(ArrayGetTailNode current2) {
            return new ArrayGetTailRubyArray1Node((ArrayGetTailBaseNode)current2);
        }
    }

    @GeneratedBy(value=ArrayGetTailNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ArrayGetTailRubyArray0Node
    extends ArrayGetTailBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArrayGetTailRubyArray0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class}, 0, 0);

        ArrayGetTailRubyArray0Node(ArrayGetTailBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyArray value2;
            try {
                value2 = this.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value2;
        }

        @Override
        public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
            RubyArray arrayValue;
            try {
                arrayValue = this.array.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected arrayValue instanceof RubyArray");
            }
            if (ArrayGuards.isNull(arrayValue)) {
                return super.getTailNull(arrayValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, "One of guards [isNull] failed");
        }

        @Override
        protected RubyArray executeChained0(VirtualFrame frameValue, Object arrayValue) {
            RubyArray arrayValueCast;
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && ArrayGuards.isNull(arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue))) {
                return super.getTailNull(arrayValueCast);
            }
            return this.next0.executeChained0(frameValue, arrayValue);
        }

        static ArrayGetTailNode create0(ArrayGetTailNode current2) {
            return new ArrayGetTailRubyArray0Node((ArrayGetTailBaseNode)current2);
        }
    }

    @GeneratedBy(value=ArrayGetTailNode.class)
    @NodeInfo(cost=NodeCost.UNINITIALIZED)
    private static final class ArrayGetTailUninitializedNode
    extends ArrayGetTailBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArrayGetTailUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
        @CompilerDirectives.CompilationFinal
        private boolean containsFallback;

        ArrayGetTailUninitializedNode(RubyContext context, SourceSection sourceSection, int index2, RubyNode array) {
            super(context, sourceSection, index2, array);
        }

        ArrayGetTailUninitializedNode(ArrayGetTailBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public NodeCost getCost() {
            if (this.containsFallback) {
                return NodeCost.MONOMORPHIC;
            }
            return super.getCost();
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyArray value2;
            try {
                value2 = this.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value2;
        }

        @Override
        public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            Object arrayValue = this.array.execute(frameValue);
            return this.executeUninitialized0(frameValue, arrayValue);
        }

        @Override
        protected RubyArray executeChained0(VirtualFrame frameValue, Object arrayValue) {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            return this.executeUninitialized0(frameValue, arrayValue);
        }

        protected RubyArray executeUninitialized0(VirtualFrame frameValue, Object arrayValue) {
            ArrayGetTailBaseNode newNode = this.specialize0(arrayValue);
            if (newNode == null) {
                if (CompilerDirectives.inInterpreter()) {
                    this.containsFallback = true;
                }
                CompilerDirectives.transferToInterpreter();
                ArrayGetTailBaseNode rootNode = DSLShare.findRoot(this);
                throw new UnsupportedSpecializationException(rootNode, new Node[]{rootNode.array}, arrayValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arrayValue);
        }

        static ArrayGetTailNode create0(RubyContext context, SourceSection sourceSection, int index2, RubyNode array) {
            return new ArrayGetTailUninitializedNode(context, sourceSection, index2, array);
        }
    }

    @GeneratedBy(value=ArrayGetTailNode.class)
    private static abstract class ArrayGetTailBaseNode
    extends ArrayGetTailNode
    implements DSLNode {
        @Node.Child
        protected RubyNode array;
        @Node.Child
        protected ArrayGetTailBaseNode next0;

        ArrayGetTailBaseNode(RubyContext context, SourceSection sourceSection, int index2, RubyNode array) {
            super(context, sourceSection, index2);
            this.array = array;
        }

        ArrayGetTailBaseNode(ArrayGetTailBaseNode copy) {
            super(copy);
        }

        protected abstract RubyArray executeChained0(VirtualFrame var1, Object var2);

        protected final RubyArray rewrite0(VirtualFrame frameValue, Object arrayValue, String reason2) {
            String message2;
            ArrayGetTailBaseNode returnNode;
            CompilerAsserts.neverPartOfCompilation();
            ArrayGetTailBaseNode newNode = this.specialize0(arrayValue);
            if (newNode == null) {
                newNode = new ArrayGetTailUninitializedNode(this);
                ((ArrayGetTailUninitializedNode)newNode).containsFallback = true;
            }
            if ((returnNode = DSLShare.rewrite(this, newNode, message2 = ArrayGetTailBaseNode.createInfo0(reason2, arrayValue))) == null) {
                returnNode = DSLShare.rewriteToPolymorphic(this, new ArrayGetTailUninitializedNode(this), new ArrayGetTailPolymorphicNode(this), (ArrayGetTailBaseNode)this.copy(), newNode, message2);
            }
            return returnNode.executeChained0(frameValue, arrayValue);
        }

        @CompilerDirectives.TruffleBoundary
        protected final ArrayGetTailBaseNode specialize0(Object arrayValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue)) {
                RubyArray arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue);
                if (ArrayGuards.isNull(arrayValueCast)) {
                    return (ArrayGetTailBaseNode)ArrayGetTailRubyArray0Node.create0(this);
                }
                if (ArrayGuards.isIntegerFixnum(arrayValueCast)) {
                    return (ArrayGetTailBaseNode)ArrayGetTailRubyArray1Node.create0(this);
                }
                if (ArrayGuards.isLongFixnum(arrayValueCast)) {
                    return (ArrayGetTailBaseNode)ArrayGetTailRubyArray2Node.create0(this);
                }
                if (ArrayGuards.isFloat(arrayValueCast)) {
                    return (ArrayGetTailBaseNode)ArrayGetTailRubyArray3Node.create0(this);
                }
                if (ArrayGuards.isObject(arrayValueCast)) {
                    return (ArrayGetTailBaseNode)ArrayGetTailRubyArray4Node.create0(this);
                }
            }
            return null;
        }

        @Override
        public final void adoptChildren0(Node other, Node newNext) {
            this.array = other == null ? null : ((ArrayGetTailBaseNode)other).array;
            this.next0 = newNext == null ? null : (ArrayGetTailBaseNode)newNext;
        }

        @Override
        public DSLMetadata getMetadata0() {
            return DSLMetadata.NONE;
        }

        @Override
        public void updateTypes0(Class<?>[] types) {
        }

        @Override
        public final Node getNext0() {
            return this.next0;
        }

        protected static String createInfo0(String message2, Object arrayValue) {
            if (TruffleOptions.DetailedRewriteReasons) {
                StringBuilder builder = new StringBuilder(message2);
                builder.append(" (");
                builder.append("arrayValue").append(" = ").append(arrayValue);
                if (arrayValue != null) {
                    builder.append(" (").append(arrayValue.getClass().getSimpleName()).append(")");
                }
                builder.append(")");
                return builder.toString();
            }
            return message2;
        }
    }
}

