/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import java.util.Arrays;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.util.ArrayUtils;
import org.jruby.util.cli.Options;

public abstract class ArrayBuilderNode
extends Node {
    public static final int ARRAYS_UNINITIALIZED_SIZE = Options.TRUFFLE_ARRAYS_UNINITIALIZED_SIZE.load();
    private final RubyContext context;

    public ArrayBuilderNode(RubyContext context) {
        this.context = context;
    }

    public abstract Object start();

    public abstract Object start(int var1);

    public abstract Object ensure(Object var1, int var2);

    public abstract Object append(Object var1, int var2, RubyArray var3);

    public abstract Object append(Object var1, int var2, Object var3);

    public abstract Object finish(Object var1, int var2);

    protected RubyContext getContext() {
        return this.context;
    }

    public static class ObjectArrayBuilderNode
    extends ArrayBuilderNode {
        private final int expectedLength;
        @CompilerDirectives.CompilationFinal
        private boolean hasAppendedObjectArray = false;

        public ObjectArrayBuilderNode(RubyContext context, int expectedLength) {
            super(context);
            this.expectedLength = expectedLength;
        }

        @Override
        public Object start() {
            return new Object[this.expectedLength];
        }

        @Override
        public Object start(int length2) {
            if (length2 > this.expectedLength) {
                CompilerDirectives.transferToInterpreter();
                UninitializedArrayBuilderNode newNode = new UninitializedArrayBuilderNode(this.getContext());
                this.replace(newNode);
                return newNode.start(length2);
            }
            return new Object[this.expectedLength];
        }

        @Override
        public Object ensure(Object store, int length2) {
            if (length2 > ((Object[])store).length) {
                CompilerDirectives.transferToInterpreter();
                UninitializedArrayBuilderNode newNode = new UninitializedArrayBuilderNode(this.getContext());
                this.replace(newNode);
                newNode.resume((Object[])store);
                return newNode.ensure(store, length2);
            }
            return store;
        }

        @Override
        public Object append(Object store, int index2, RubyArray array) {
            Object otherStore = array.getStore();
            if (otherStore == null) {
                return store;
            }
            if (this.hasAppendedObjectArray && otherStore instanceof Object[]) {
                System.arraycopy(otherStore, 0, store, index2, array.getSize());
                return store;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            if (otherStore instanceof Object[]) {
                this.hasAppendedObjectArray = true;
                System.arraycopy(otherStore, 0, store, index2, array.getSize());
                return store;
            }
            throw new UnsupportedOperationException(array.getStore().getClass().getName());
        }

        @Override
        public Object append(Object store, int index2, Object value2) {
            ((Object[])store)[index2] = value2;
            return store;
        }

        @Override
        public Object finish(Object store, int length2) {
            return store;
        }
    }

    public static class DoubleArrayBuilderNode
    extends ArrayBuilderNode {
        private final int expectedLength;

        public DoubleArrayBuilderNode(RubyContext context, int expectedLength) {
            super(context);
            this.expectedLength = expectedLength;
        }

        @Override
        public Object start() {
            return new double[this.expectedLength];
        }

        @Override
        public Object start(int length2) {
            if (length2 > this.expectedLength) {
                CompilerDirectives.transferToInterpreter();
                UninitializedArrayBuilderNode newNode = new UninitializedArrayBuilderNode(this.getContext());
                this.replace(newNode);
                return newNode.start(length2);
            }
            return new double[this.expectedLength];
        }

        @Override
        public Object ensure(Object store, int length2) {
            CompilerDirectives.transferToInterpreter();
            throw new UnsupportedOperationException();
        }

        @Override
        public Object append(Object store, int index2, RubyArray array) {
            CompilerDirectives.transferToInterpreter();
            throw new UnsupportedOperationException();
        }

        @Override
        public Object append(Object store, int index2, Object value2) {
            if (value2 instanceof Double) {
                ((double[])store)[index2] = (Double)value2;
                return store;
            }
            CompilerDirectives.transferToInterpreter();
            this.replace(new ObjectArrayBuilderNode(this.getContext(), this.expectedLength));
            Object[] newStore = ArrayUtils.box((double[])store);
            newStore[index2] = value2;
            return newStore;
        }

        @Override
        public Object finish(Object store, int length2) {
            return store;
        }
    }

    public static class LongArrayBuilderNode
    extends ArrayBuilderNode {
        private final int expectedLength;

        public LongArrayBuilderNode(RubyContext context, int expectedLength) {
            super(context);
            this.expectedLength = expectedLength;
        }

        @Override
        public Object start() {
            return new long[this.expectedLength];
        }

        @Override
        public Object start(int length2) {
            if (length2 > this.expectedLength) {
                CompilerDirectives.transferToInterpreter();
                UninitializedArrayBuilderNode newNode = new UninitializedArrayBuilderNode(this.getContext());
                this.replace(newNode);
                return newNode.start(length2);
            }
            return new long[this.expectedLength];
        }

        @Override
        public Object ensure(Object store, int length2) {
            CompilerDirectives.transferToInterpreter();
            throw new UnsupportedOperationException();
        }

        @Override
        public Object append(Object store, int index2, RubyArray array) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object append(Object store, int index2, Object value2) {
            if (value2 instanceof Long) {
                ((long[])store)[index2] = (Long)value2;
                return store;
            }
            if (value2 instanceof Integer) {
                ((long[])store)[index2] = ((Integer)value2).intValue();
                return store;
            }
            CompilerDirectives.transferToInterpreter();
            this.replace(new ObjectArrayBuilderNode(this.getContext(), this.expectedLength));
            Object[] newStore = ArrayUtils.box((long[])store);
            newStore[index2] = value2;
            return newStore;
        }

        @Override
        public Object finish(Object store, int length2) {
            return store;
        }
    }

    public static class IntegerArrayBuilderNode
    extends ArrayBuilderNode {
        private final int expectedLength;
        @CompilerDirectives.CompilationFinal
        private boolean hasAppendedIntegerArray = false;
        @CompilerDirectives.CompilationFinal
        private boolean hasAppendedObjectArray = false;

        public IntegerArrayBuilderNode(RubyContext context, int expectedLength) {
            super(context);
            this.expectedLength = expectedLength;
        }

        @Override
        public Object start() {
            return new int[this.expectedLength];
        }

        @Override
        public Object start(int length2) {
            if (length2 > this.expectedLength) {
                CompilerDirectives.transferToInterpreter();
                UninitializedArrayBuilderNode newNode = new UninitializedArrayBuilderNode(this.getContext());
                this.replace(newNode);
                return newNode.start(length2);
            }
            return new int[this.expectedLength];
        }

        @Override
        public Object ensure(Object store, int length2) {
            if (length2 > ((int[])store).length) {
                CompilerDirectives.transferToInterpreter();
                Object[] newStore = ArrayUtils.box((int[])store);
                UninitializedArrayBuilderNode newNode = new UninitializedArrayBuilderNode(this.getContext());
                this.replace(newNode);
                newNode.resume(newStore);
                return newNode.ensure(newStore, length2);
            }
            return store;
        }

        @Override
        public Object append(Object store, int index2, RubyArray array) {
            Object otherStore = array.getStore();
            if (otherStore == null) {
                return store;
            }
            if (this.hasAppendedIntegerArray && otherStore instanceof int[]) {
                System.arraycopy(otherStore, 0, store, index2, array.getSize());
                return store;
            }
            if (this.hasAppendedObjectArray && otherStore instanceof Object[]) {
                System.arraycopy(otherStore, 0, store, index2, array.getSize());
                return store;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            if (otherStore instanceof int[]) {
                this.hasAppendedIntegerArray = true;
                System.arraycopy(otherStore, 0, store, index2, array.getSize());
                return store;
            }
            if (otherStore instanceof Object[]) {
                this.hasAppendedObjectArray = true;
                System.arraycopy(otherStore, 0, store, index2, array.getSize());
                return store;
            }
            throw new UnsupportedOperationException(array.getStore().getClass().getName());
        }

        @Override
        public Object append(Object store, int index2, Object value2) {
            Object[] newStore;
            if (value2 instanceof Integer) {
                ((int[])store)[index2] = (Integer)value2;
                return store;
            }
            CompilerDirectives.transferToInterpreter();
            this.replace(new ObjectArrayBuilderNode(this.getContext(), this.expectedLength));
            if (store instanceof int[]) {
                newStore = ArrayUtils.box((int[])store);
            } else if (store instanceof Object[]) {
                newStore = (Object[])store;
            } else {
                throw new UnsupportedOperationException();
            }
            newStore[index2] = value2;
            return newStore;
        }

        @Override
        public Object finish(Object store, int length2) {
            return store;
        }
    }

    public static class UninitializedArrayBuilderNode
    extends ArrayBuilderNode {
        private boolean couldUseInteger = true;
        private boolean couldUseLong = true;
        private boolean couldUseDouble = true;

        public UninitializedArrayBuilderNode(RubyContext context) {
            super(context);
        }

        public void resume(Object[] store) {
            for (Object value2 : store) {
                this.screen(value2);
            }
        }

        @Override
        public Object start() {
            CompilerDirectives.transferToInterpreter();
            return new Object[ARRAYS_UNINITIALIZED_SIZE];
        }

        @Override
        public Object start(int length2) {
            CompilerDirectives.transferToInterpreter();
            return new Object[length2];
        }

        @Override
        public Object ensure(Object store, int length2) {
            return store;
        }

        @Override
        public Object append(Object store, int index2, RubyArray array) {
            CompilerDirectives.transferToInterpreter();
            for (Object value2 : array.slowToArray()) {
                store = this.append(store, index2, value2);
                ++index2;
            }
            return store;
        }

        @Override
        public Object append(Object store, int index2, Object value2) {
            CompilerDirectives.transferToInterpreter();
            this.screen(value2);
            Object[] storeArray = (Object[])store;
            if (index2 >= storeArray.length) {
                storeArray = Arrays.copyOf(storeArray, ArrayUtils.capacity(storeArray.length, index2 + 1));
            }
            storeArray[index2] = value2;
            return storeArray;
        }

        @Override
        public Object finish(Object store, int length2) {
            if (this.couldUseInteger) {
                this.replace(new IntegerArrayBuilderNode(this.getContext(), length2));
                return ArrayUtils.unboxInteger((Object[])store, length2);
            }
            if (this.couldUseLong) {
                this.replace(new LongArrayBuilderNode(this.getContext(), length2));
                return ArrayUtils.unboxLong((Object[])store, length2);
            }
            if (this.couldUseDouble) {
                this.replace(new DoubleArrayBuilderNode(this.getContext(), length2));
                return ArrayUtils.unboxDouble((Object[])store, length2);
            }
            this.replace(new ObjectArrayBuilderNode(this.getContext(), length2));
            return store;
        }

        private void screen(Object value2) {
            if (value2 instanceof Integer) {
                this.couldUseDouble = false;
            } else if (value2 instanceof Long) {
                this.couldUseInteger = false;
                this.couldUseDouble = false;
            } else if (value2 instanceof Double) {
                this.couldUseInteger = false;
                this.couldUseLong = false;
            } else {
                this.couldUseInteger = false;
                this.couldUseLong = false;
                this.couldUseDouble = false;
            }
        }
    }
}

