/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.java.proxies;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyModule;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.JavaMethod;
import org.jruby.internal.runtime.methods.UndefinedMethod;
import org.jruby.java.proxies.JavaProxy;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaClass;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaUtilities;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class JavaInterfaceTemplate {
    public static RubyModule createJavaInterfaceTemplateModule(ThreadContext context) {
        Ruby runtime = context.runtime;
        RubyModule javaInterfaceTemplate = runtime.defineModule("JavaInterfaceTemplate");
        RubyClass singleton = javaInterfaceTemplate.getSingletonClass();
        singleton.addReadAttribute(context, "java_class");
        singleton.defineAnnotatedMethods(JavaInterfaceTemplate.class);
        return javaInterfaceTemplate;
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public static IRubyObject implement(ThreadContext context, IRubyObject self2, IRubyObject clazz) {
        Ruby runtime = context.runtime;
        if (!(clazz instanceof RubyModule)) {
            throw runtime.newTypeError(clazz, runtime.getModule());
        }
        RubyModule targetModule = (RubyModule)clazz;
        JavaClass javaClass = (JavaClass)self2.getInstanceVariables().getInstanceVariable("@java_class");
        Method[] javaInstanceMethods = javaClass.javaClass().getMethods();
        JavaMethod dummyMethod = new JavaMethod(targetModule, Visibility.PUBLIC){

            @Override
            public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
                return context.runtime.getNil();
            }
        };
        for (int i2 = 0; i2 < javaInstanceMethods.length; ++i2) {
            Method method = javaInstanceMethods[i2];
            String name2 = method.getName();
            if (targetModule.searchMethod(name2) != UndefinedMethod.INSTANCE) continue;
            targetModule.addMethod(name2, dummyMethod);
        }
        return runtime.getNil();
    }

    @JRubyMethod(frame=true)
    public static IRubyObject append_features(ThreadContext context, IRubyObject self2, IRubyObject clazz, Block block) {
        if (clazz instanceof RubyClass) {
            JavaInterfaceTemplate.appendFeaturesToClass(context, self2, (RubyClass)clazz);
        } else if (clazz instanceof RubyModule) {
            JavaInterfaceTemplate.appendFeaturesToModule(context, self2, (RubyModule)clazz);
        } else {
            throw context.runtime.newTypeError("received " + clazz + ", expected Class/Module");
        }
        return Helpers.invokeSuper(context, self2, clazz, block);
    }

    private static void appendFeaturesToClass(ThreadContext context, IRubyObject self2, RubyClass clazz) {
        Ruby runtime = context.runtime;
        JavaInterfaceTemplate.checkAlreadyReified(clazz, runtime);
        IRubyObject javaClassObj = Helpers.getInstanceVariable(self2, runtime, "@java_class");
        if (!clazz.hasInstanceVariable("@java_interfaces")) {
            RubyArray javaInterfaces = RubyArray.newArray(runtime, javaClassObj);
            Helpers.setInstanceVariable(javaInterfaces, clazz, "@java_interfaces");
            JavaInterfaceTemplate.initInterfaceImplMethods(context, clazz);
        } else {
            IRubyObject javaInterfaces = Helpers.getInstanceVariable(clazz, runtime, "@java_interfaces");
            if (!javaInterfaces.isFrozen() && !((RubyArray)javaInterfaces).includes(context, javaClassObj)) {
                ((RubyArray)javaInterfaces).append(javaClassObj);
            }
        }
    }

    private static void checkAlreadyReified(RubyClass clazz, Ruby runtime) throws RaiseException {
        if (Java.NEW_STYLE_EXTENSION && clazz.getReifiedClass() != null || clazz.hasInstanceVariable("@java_class") && clazz.getInstanceVariable("@java_class").isTrue() && !clazz.getSingletonClass().isMethodBound("java_proxy_class", false) || clazz.hasInstanceVariable("@java_proxy_class") && clazz.getInstanceVariable("@java_proxy_class").isTrue()) {
            throw runtime.newArgumentError("can not add Java interface to existing Java class");
        }
    }

    private static void initInterfaceImplMethods(ThreadContext context, RubyClass clazz) {
        RubyClass singleton;
        if (!clazz.isMethodBound("__jcreate!", false) && !clazz.isMethodBound("__jcreate_meta!", false)) {
            singleton = clazz.getSingletonClass();
            singleton.addReadAttribute(context, "java_interfaces");
            if (!Java.NEW_STYLE_EXTENSION && clazz.getSuperClass().getRealClass().hasInstanceVariable("@java_class") || RubyInstanceConfig.INTERFACES_USE_PROXY) {
                final ObjectAllocator proxyAllocator = clazz.getAllocator();
                clazz.setAllocator(new ObjectAllocator(){

                    @Override
                    public IRubyObject allocate(Ruby runtime, RubyClass klazz) {
                        IRubyObject newObj = proxyAllocator.allocate(runtime, klazz);
                        Helpers.invoke(runtime.getCurrentContext(), newObj, "__jcreate!");
                        return newObj;
                    }
                });
                clazz.addMethod("__jcreate!", new JavaMethod.JavaMethodN(clazz, Visibility.PRIVATE){

                    @Override
                    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2) {
                        return JavaInterfaceTemplate.jcreateProxy(self2);
                    }
                });
            } else {
                JavaInterfaceTemplate.addRealImplClassNew(clazz);
            }
            clazz.addMethod("__jcreate_meta!", new JavaMethod.JavaMethodN(clazz, Visibility.PRIVATE){

                @Override
                public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2) {
                    IRubyObject result2 = JavaInterfaceTemplate.jcreateProxy(self2);
                    return result2;
                }
            });
            clazz.addMethod("java_class", new JavaMethod.JavaMethodZero(clazz, Visibility.PUBLIC){

                @Override
                public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2) {
                    Object dgs = self2.dataGetStruct();
                    if (dgs != null) {
                        return ((JavaObject)dgs).java_class();
                    }
                    return JavaClass.get(context.runtime, self2.getClass());
                }
            });
            if (!clazz.searchMethod("===").isUndefined()) {
                clazz.defineAlias("old_eqq", "===");
                clazz.addMethod("===", new JavaMethod.JavaMethodOne(clazz, Visibility.PUBLIC){

                    @Override
                    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg2) {
                        if (arg2.respondsTo("java_object")) {
                            IRubyObject interfaces2 = self2.getMetaClass().getInstanceVariables().getInstanceVariable("@java_interfaces");
                            assert (interfaces2 instanceof RubyArray) : "interface list was not an array";
                            return context.runtime.newBoolean(((RubyArray)interfaces2).op_diff(((JavaClass)((JavaObject)arg2.dataGetStruct()).java_class()).interfaces()).equals(RubyArray.newArray(context.runtime)));
                        }
                        return Helpers.invoke(context, self2, "old_eqq", arg2);
                    }
                });
            }
        }
        if (!clazz.isMethodBound("implement", false)) {
            singleton = clazz.getSingletonClass();
            singleton.addMethod("implement", new JavaMethod.JavaMethodOne(clazz, Visibility.PRIVATE){

                @Override
                public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg2) {
                    IRubyObject javaInterfaces = self2.getInstanceVariables().getInstanceVariable("@java_interfaces");
                    if (javaInterfaces != null && ((RubyArray)javaInterfaces).includes(context, arg2)) {
                        return Helpers.invoke(context, arg2, "implement", self2);
                    }
                    return context.runtime.getNil();
                }
            });
            singleton.addMethod("implement_all", new JavaMethod.JavaMethodOne(clazz, Visibility.PRIVATE){

                @Override
                public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg2) {
                    RubyArray javaInterfaces = (RubyArray)self2.getInstanceVariables().getInstanceVariable("@java_interfaces");
                    for (int i2 = 0; i2 < javaInterfaces.size(); ++i2) {
                        Helpers.invoke(context, JavaUtilities.get_interface_module(self2, javaInterfaces.eltInternal(i2)), "implement", self2);
                    }
                    return javaInterfaces;
                }
            });
        }
    }

    public static void addRealImplClassNew(RubyClass clazz) {
        clazz.setAllocator(new ObjectAllocator(){
            private Constructor proxyConstructor;

            @Override
            public IRubyObject allocate(Ruby runtime, RubyClass klazz) {
                Class reifiedClass = klazz.getReifiedClass();
                if (this.proxyConstructor == null || this.proxyConstructor.getDeclaringClass() != reifiedClass) {
                    if (reifiedClass == null) {
                        reifiedClass = Java.generateRealClass(klazz);
                    }
                    this.proxyConstructor = Java.getRealClassConstructor(runtime, reifiedClass);
                }
                IRubyObject newObj = Java.constructProxy(runtime, this.proxyConstructor, klazz);
                return newObj;
            }
        });
    }

    private static IRubyObject jcreateProxy(IRubyObject self2) {
        RubyClass current2 = self2.getMetaClass();
        IRubyObject newObject2 = Java.newInterfaceImpl(self2, Java.getInterfacesFromRubyClass(current2));
        return JavaUtilities.set_java_object(self2, self2, newObject2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void appendFeaturesToModule(ThreadContext context, IRubyObject self2, RubyModule module) {
        Ruby runtime = context.runtime;
        if (module.getInstanceVariables().hasInstanceVariable("@java_class") && module.getInstanceVariables().getInstanceVariable("@java_class").isTrue()) {
            throw runtime.newTypeError("can not add Java interface to existing Java interface");
        }
        RubyModule rubyModule = module;
        synchronized (rubyModule) {
            if (!module.getInstanceVariables().hasInstanceVariable("@java_interface_mods")) {
                RubyArray javaInterfaceMods = RubyArray.newArray(runtime, self2);
                module.getInstanceVariables().setInstanceVariable("@java_interface_mods", javaInterfaceMods);
                RubyClass singleton = module.getSingletonClass();
                singleton.addMethod("append_features", new JavaMethod.JavaMethodOneBlock(singleton, Visibility.PUBLIC){

                    @Override
                    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg2, Block block) {
                        if (!(arg2 instanceof RubyModule)) {
                            throw context.runtime.newTypeError("append_features called with non-module");
                        }
                        RubyModule target = (RubyModule)arg2;
                        RubyArray javaInterfaceMods = (RubyArray)self2.getInstanceVariables().getInstanceVariable("@java_interface_mods");
                        target.include(javaInterfaceMods.toJavaArray());
                        return Helpers.invokeAs(context, clazz.getSuperClass(), self2, name2, arg2, block);
                    }
                });
            } else {
                RubyArray javaInterfaceMods = (RubyArray)module.getInstanceVariables().getInstanceVariable("@java_interface_mods");
                if (!javaInterfaceMods.includes(context, self2)) {
                    javaInterfaceMods.append(self2);
                }
            }
        }
    }

    @JRubyMethod
    public static IRubyObject extended(ThreadContext context, IRubyObject self2, IRubyObject object) {
        if (!(self2 instanceof RubyModule)) {
            throw context.runtime.newTypeError(self2, context.runtime.getModule());
        }
        RubyClass singleton = object.getSingletonClass();
        singleton.include(new IRubyObject[]{self2});
        return singleton;
    }

    @JRubyMethod(name={"[]"}, rest=true)
    public static IRubyObject op_aref(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
        return JavaProxy.op_aref(context, self2, args2);
    }

    @JRubyMethod(rest=true)
    public static IRubyObject impl(ThreadContext context, IRubyObject self2, IRubyObject[] args2, final Block implBlock) {
        Ruby runtime = context.runtime;
        if (!implBlock.isGiven()) {
            throw runtime.newArgumentError("block required to call #impl on a Java interface");
        }
        final RubyArray methodNames = args2.length > 0 ? runtime.newArray(args2) : null;
        RubyClass implClass = RubyClass.newClass(runtime, runtime.getObject());
        implClass.include(new IRubyObject[]{self2});
        IRubyObject implObject = implClass.callMethod(context, "new");
        implClass.addMethod("method_missing", new JavaMethod((RubyModule)implClass, Visibility.PUBLIC){

            @Override
            public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
                Arity.checkArgumentCount(context.runtime, name2, args2.length, 1, -1);
                if (methodNames == null || methodNames.include_p(context, args2[0]).isTrue()) {
                    return implBlock.call(context, args2);
                }
                return clazz.getSuperClass().callMethod(context, "method_missing", args2, block);
            }
        });
        return implObject;
    }

    @JRubyMethod(name={"new"}, rest=true)
    public static IRubyObject rbNew(ThreadContext context, IRubyObject self2, IRubyObject[] args2, Block block) {
        Ruby runtime = context.runtime;
        RubyClass implClass = (RubyClass)self2.getInstanceVariables().getInstanceVariable("@__implementation");
        if (implClass == null) {
            implClass = RubyClass.newClass(runtime, runtime.getClass("InterfaceJavaProxy"));
            implClass.include(new IRubyObject[]{self2});
            Helpers.setInstanceVariable(implClass, self2, "@__implementation");
        }
        return Helpers.invoke(context, (IRubyObject)implClass, "new", args2, block);
    }
}

