/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.java.proxies;

import java.lang.reflect.Array;
import java.util.Arrays;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyRange;
import org.jruby.anno.JRubyMethod;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.JavaMethod;
import org.jruby.java.proxies.JavaProxy;
import org.jruby.java.util.ArrayUtils;
import org.jruby.javasupport.JavaArray;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class ArrayJavaProxy
extends JavaProxy {
    private final JavaUtil.JavaConverter converter;

    public ArrayJavaProxy(Ruby runtime, RubyClass klazz, Object ary) {
        this(runtime, klazz, ary, JavaUtil.getJavaConverter(ary.getClass().getComponentType()));
    }

    public ArrayJavaProxy(Ruby runtime, RubyClass klazz, Object ary, JavaUtil.JavaConverter converter) {
        super(runtime, klazz, ary);
        this.converter = converter;
    }

    public static RubyClass createArrayJavaProxy(ThreadContext context) {
        Ruby runtime = context.runtime;
        RubyClass arrayJavaProxy = runtime.defineClass("ArrayJavaProxy", runtime.getJavaSupport().getJavaProxyClass(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        RubyClass singleton = arrayJavaProxy.getSingletonClass();
        DynamicMethod oldNew = singleton.searchMethod("new");
        singleton.addMethod("new", new ArrayNewMethod((RubyModule)singleton, Visibility.PUBLIC, oldNew));
        arrayJavaProxy.defineAnnotatedMethods(ArrayJavaProxy.class);
        arrayJavaProxy.includeModule(runtime.getEnumerable());
        return arrayJavaProxy;
    }

    public JavaArray getJavaArray() {
        JavaArray javaArray = (JavaArray)this.dataGetStruct();
        if (javaArray == null) {
            javaArray = new JavaArray(this.getRuntime(), this.getObject());
            this.dataWrapStruct(javaArray);
        }
        return javaArray;
    }

    @JRubyMethod(name={"length", "size"})
    public IRubyObject length(ThreadContext context) {
        return context.runtime.newFixnum(Array.getLength(this.getObject()));
    }

    @JRubyMethod(name={"empty?"})
    public IRubyObject empty(ThreadContext context) {
        return context.runtime.newBoolean(Array.getLength(this.getObject()) == 0);
    }

    @JRubyMethod(name={"[]"})
    public IRubyObject op_aref(ThreadContext context, IRubyObject arg2) {
        if (arg2 instanceof RubyInteger) {
            int index2 = (int)((RubyInteger)arg2).getLongValue();
            return ArrayUtils.arefDirect(context.runtime, this.getObject(), this.converter, index2);
        }
        return this.getRange(context, arg2);
    }

    @JRubyMethod(name={"[]"}, required=1, rest=true)
    public IRubyObject op_aref(ThreadContext context, IRubyObject[] args2) {
        if (args2.length == 1 && args2[0] instanceof RubyInteger) {
            int index2 = (int)((RubyInteger)args2[0]).getLongValue();
            return ArrayUtils.arefDirect(context.runtime, this.getObject(), this.converter, index2);
        }
        return this.getRange(context, args2);
    }

    @JRubyMethod(name={"[]="})
    public IRubyObject op_aset(ThreadContext context, IRubyObject index2, IRubyObject value2) {
        ArrayUtils.asetDirect(context.runtime, this.getObject(), this.converter, (int)((RubyInteger)index2).getLongValue(), value2);
        return value2;
    }

    @JRubyMethod
    public IRubyObject at(ThreadContext context, IRubyObject indexObj) {
        Ruby runtime = context.runtime;
        Object array = this.getObject();
        int length2 = Array.getLength(array);
        long index2 = indexObj.convertToInteger().getLongValue();
        if (index2 < 0L) {
            index2 += (long)length2;
        }
        if (index2 >= 0L && index2 < (long)length2) {
            return ArrayUtils.arefDirect(runtime, array, this.converter, (int)index2);
        }
        return context.nil;
    }

    @JRubyMethod(name={"+"})
    public IRubyObject op_plus(ThreadContext context, IRubyObject other) {
        if (other instanceof ArrayJavaProxy) {
            Object otherArray = ((ArrayJavaProxy)other).getObject();
            if (this.getObject().getClass().getComponentType().isAssignableFrom(otherArray.getClass().getComponentType())) {
                return ArrayUtils.concatArraysDirect(context, this.getObject(), otherArray);
            }
        }
        return ArrayUtils.concatArraysDirect(context, this.getObject(), other);
    }

    @JRubyMethod
    public IRubyObject each(ThreadContext context, Block block) {
        Ruby runtime = context.runtime;
        int length2 = Array.getLength(this.getObject());
        for (int i2 = 0; i2 < length2; ++i2) {
            IRubyObject rubyObj = ArrayUtils.arefDirect(runtime, this.getObject(), this.converter, i2);
            block.yield(context, rubyObj);
        }
        return this;
    }

    @JRubyMethod(name={"to_a", "to_ary"})
    public IRubyObject to_a(ThreadContext context) {
        return JavaUtil.convertJavaArrayToRubyWithNesting(context, this.getObject());
    }

    @JRubyMethod
    public IRubyObject inspect(ThreadContext context) {
        StringBuilder buffer = new StringBuilder();
        Class<?> componentClass = this.getObject().getClass().getComponentType();
        buffer.append(componentClass.getName());
        if (componentClass.isPrimitive()) {
            switch (componentClass.getName().charAt(0)) {
                case 'b': {
                    if (componentClass == Byte.TYPE) {
                        buffer.append(Arrays.toString((byte[])this.getObject()));
                    }
                    if (componentClass != Boolean.TYPE) break;
                    buffer.append(Arrays.toString((boolean[])this.getObject()));
                    break;
                }
                case 's': {
                    if (componentClass != Short.TYPE) break;
                    buffer.append(Arrays.toString((short[])this.getObject()));
                    break;
                }
                case 'c': {
                    if (componentClass != Character.TYPE) break;
                    buffer.append(Arrays.toString((char[])this.getObject()));
                    break;
                }
                case 'i': {
                    if (componentClass != Integer.TYPE) break;
                    buffer.append(Arrays.toString((int[])this.getObject()));
                    break;
                }
                case 'l': {
                    if (componentClass != Long.TYPE) break;
                    buffer.append(Arrays.toString((long[])this.getObject()));
                    break;
                }
                case 'f': {
                    if (componentClass != Float.TYPE) break;
                    buffer.append(Arrays.toString((float[])this.getObject()));
                    break;
                }
                case 'd': {
                    if (componentClass != Double.TYPE) break;
                    buffer.append(Arrays.toString((double[])this.getObject()));
                }
            }
        } else {
            buffer.append(Arrays.toString((Object[])this.getObject()));
        }
        buffer.append('@').append(Integer.toHexString(this.inspectHashCode()));
        return context.runtime.newString(buffer.toString());
    }

    public IRubyObject getRange(ThreadContext context, IRubyObject[] args2) {
        if (args2.length == 1) {
            return this.getRange(context, args2[0]);
        }
        if (args2.length == 2) {
            return this.getRange(context, args2[0], args2[1]);
        }
        throw context.runtime.newArgumentError(args2.length, 1);
    }

    public IRubyObject getRange(ThreadContext context, IRubyObject arg0) {
        int length2 = Array.getLength(this.getObject());
        if (arg0 instanceof RubyRange) {
            RubyRange range = (RubyRange)arg0;
            if (range.first(context) instanceof RubyFixnum && range.last(context) instanceof RubyFixnum) {
                int first2 = (int)((RubyFixnum)range.first(context)).getLongValue();
                int last2 = (int)((RubyFixnum)range.last(context)).getLongValue();
                first2 = first2 >= 0 ? first2 : length2 + first2;
                last2 = last2 >= 0 ? last2 : length2 + last2;
                int newLength = last2 - first2;
                if (range.exclude_end_p().isFalse()) {
                    ++newLength;
                }
                if (newLength <= 0) {
                    return ArrayUtils.emptyJavaArrayDirect(context, this.getObject().getClass().getComponentType());
                }
                return ArrayUtils.javaArraySubarrayDirect(context, this.getObject(), first2, newLength);
            }
            throw context.runtime.newTypeError("only Fixnum ranges supported");
        }
        throw context.runtime.newTypeError(arg0, context.runtime.getRange());
    }

    public IRubyObject getRange(ThreadContext context, IRubyObject firstObj, IRubyObject lengthObj) {
        if (firstObj instanceof RubyFixnum && lengthObj instanceof RubyFixnum) {
            int first2 = (int)((RubyFixnum)firstObj).getLongValue();
            int length2 = (int)((RubyFixnum)lengthObj).getLongValue();
            if (length2 > Array.getLength(this.getObject())) {
                throw context.runtime.newIndexError("length specifed is longer than array");
            }
            int n = first2 = first2 >= 0 ? first2 : Array.getLength(this.getObject()) + first2;
            if (length2 <= 0) {
                return ArrayUtils.emptyJavaArrayDirect(context, this.getObject().getClass().getComponentType());
            }
            return ArrayUtils.javaArraySubarrayDirect(context, this.getObject(), first2, length2);
        }
        throw context.runtime.newTypeError("only Fixnum ranges supported");
    }

    public static class ArrayNewMethod
    extends JavaMethod.JavaMethodOne {
        private DynamicMethod oldNew;

        public ArrayNewMethod(RubyModule implClass, Visibility visibility, DynamicMethod oldNew) {
            super(implClass, visibility);
            this.oldNew = oldNew;
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0) {
            Ruby runtime = context.runtime;
            IRubyObject proxy2 = this.oldNew.call(context, self2, clazz, "new_proxy");
            if (arg0 instanceof JavaArray) {
                proxy2.dataWrapStruct(arg0);
                return proxy2;
            }
            throw runtime.newTypeError(arg0, runtime.getJavaSupport().getJavaArrayClass());
        }
    }
}

