/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.passes;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.jruby.ir.IRFlags;
import org.jruby.ir.IRScope;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.LoadLocalVarInstr;
import org.jruby.ir.instructions.ResultInstr;
import org.jruby.ir.instructions.StoreLocalVarInstr;
import org.jruby.ir.operands.LocalVariable;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.passes.CFGBuilder;
import org.jruby.ir.passes.CompilerPass;
import org.jruby.ir.passes.LiveVariableAnalysis;
import org.jruby.ir.representations.BasicBlock;

public class OptimizeDynScopesPass
extends CompilerPass {
    public static List<Class<? extends CompilerPass>> DEPENDENCIES = Arrays.asList(CFGBuilder.class);

    @Override
    public String getLabel() {
        return "Optimize Dynamic Scopes";
    }

    private void setupLocalVarReplacement(LocalVariable v, IRScope s2, Map<Operand, Operand> varRenameMap) {
        if (varRenameMap.get(v) == null) {
            varRenameMap.put(v, s2.getNewTemporaryVariableFor(v));
        }
    }

    private void decrementScopeDepth(LocalVariable v, IRScope s2, Map<Operand, Operand> varRenameMap) {
        if (varRenameMap.get(v) == null) {
            varRenameMap.put(v, v.cloneForDepth(v.getScopeDepth() - 1));
        }
    }

    public void eliminateLocalVars(IRScope s2) {
        HashMap<Operand, Operand> varRenameMap = new HashMap<Operand, Operand>();
        s2.getFlags().add(IRFlags.DYNSCOPE_ELIMINATED);
        boolean parentScopeNeeded = false;
        for (BasicBlock b2 : s2.getCFG().getBasicBlocks()) {
            ListIterator<Instr> instrs = b2.getInstrs().listIterator();
            while (instrs.hasNext()) {
                Variable v;
                Instr i2 = instrs.next();
                if (i2 instanceof ResultInstr && (v = ((ResultInstr)((Object)i2)).getResult()) instanceof LocalVariable && !v.isSelf()) {
                    LocalVariable lv = (LocalVariable)v;
                    if (lv.getScopeDepth() == 0) {
                        this.setupLocalVarReplacement(lv, s2, varRenameMap);
                    } else {
                        parentScopeNeeded = true;
                        this.decrementScopeDepth(lv, s2, varRenameMap);
                    }
                }
                for (Variable v2 : i2.getUsedVariables()) {
                    StoreLocalVarInstr slvi;
                    LoadLocalVarInstr llvi;
                    if (!(v2 instanceof LocalVariable) || v2.isSelf()) continue;
                    LocalVariable lv = (LocalVariable)v2;
                    if (lv.getScopeDepth() == 0) {
                        if (i2 instanceof LoadLocalVarInstr) {
                            llvi = (LoadLocalVarInstr)i2;
                            if (llvi.getLocalVar() == lv) {
                                instrs.remove();
                            }
                        } else if (i2 instanceof StoreLocalVarInstr && (slvi = (StoreLocalVarInstr)i2).getLocalVar() == lv) {
                            instrs.remove();
                        }
                        this.setupLocalVarReplacement(lv, s2, varRenameMap);
                        continue;
                    }
                    if (i2 instanceof LoadLocalVarInstr) {
                        llvi = (LoadLocalVarInstr)i2;
                        if (llvi.getLocalVar() == lv) {
                            llvi.decrementLVarScopeDepth();
                        }
                    } else if (i2 instanceof StoreLocalVarInstr && (slvi = (StoreLocalVarInstr)i2).getLocalVar() == lv) {
                        slvi.decrementLVarScopeDepth();
                    }
                    parentScopeNeeded = true;
                    this.decrementScopeDepth(lv, s2, varRenameMap);
                }
            }
        }
        if (parentScopeNeeded) {
            s2.getFlags().add(IRFlags.REUSE_PARENT_DYNSCOPE);
        }
        for (BasicBlock b2 : s2.getCFG().getBasicBlocks()) {
            for (Instr i2 : b2.getInstrs()) {
                i2.renameVars(varRenameMap);
            }
        }
        new LiveVariableAnalysis().invalidate(s2);
    }

    @Override
    public Object execute(IRScope scope, Object ... data2) {
        scope.computeScopeFlags();
        if (scope.getFlags().contains((Object)IRFlags.REQUIRES_DYNSCOPE)) {
            return null;
        }
        this.eliminateLocalVars(scope);
        return null;
    }

    @Override
    public boolean invalidate(IRScope scope) {
        return false;
    }
}

