/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.passes;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.jruby.ir.IRClosure;
import org.jruby.ir.IRFlags;
import org.jruby.ir.IRScope;
import org.jruby.ir.dataflow.analyses.LoadLocalVarPlacementProblem;
import org.jruby.ir.dataflow.analyses.StoreLocalVarPlacementProblem;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.passes.CompilerPass;
import org.jruby.ir.passes.LiveVariableAnalysis;
import org.jruby.ir.representations.BasicBlock;

public class AddLocalVarLoadStoreInstructions
extends CompilerPass {
    public static List<Class<? extends CompilerPass>> DEPENDENCIES = Arrays.asList(LiveVariableAnalysis.class);

    @Override
    public String getLabel() {
        return "Add Local Variable Load/Store Instructions";
    }

    @Override
    public List<Class<? extends CompilerPass>> getDependencies() {
        return DEPENDENCIES;
    }

    @Override
    public Object execute(IRScope s2, Object ... data2) {
        StoreLocalVarPlacementProblem slvp = new StoreLocalVarPlacementProblem();
        if (!s2.getFlags().contains((Object)IRFlags.DYNSCOPE_ELIMINATED) || s2.getFlags().contains((Object)IRFlags.REUSE_PARENT_DYNSCOPE)) {
            s2.computeScopeFlags();
            HashMap<Operand, Operand> varRenameMap = new HashMap<Operand, Operand>();
            slvp.setup(s2);
            slvp.compute_MOP_Solution();
            slvp.addStores(varRenameMap);
            LoadLocalVarPlacementProblem llvp = new LoadLocalVarPlacementProblem();
            llvp.setup(s2);
            llvp.compute_MOP_Solution();
            llvp.addLoads(varRenameMap);
            for (BasicBlock b2 : s2.getCFG().getBasicBlocks()) {
                for (Instr i2 : b2.getInstrs()) {
                    i2.renameVars(varRenameMap);
                }
            }
            for (IRClosure c : s2.getClosures()) {
                this.run(c, false, true);
            }
            new LiveVariableAnalysis().invalidate(s2);
        }
        s2.setDataFlowSolution("Placement of local-var stores", slvp);
        return slvp;
    }

    @Override
    public Object previouslyRun(IRScope scope) {
        return scope.getDataFlowSolution("Placement of local-var stores");
    }

    @Override
    public boolean invalidate(IRScope scope) {
        super.invalidate(scope);
        scope.setDataFlowSolution("Placement of local-var stores", null);
        return true;
    }
}

