/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.operands;

import org.jruby.RubyComplex;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.operands.ImmutableLiteral;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.OperandType;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class Complex
extends ImmutableLiteral {
    private final ImmutableLiteral number;

    public Complex(ImmutableLiteral number) {
        super(OperandType.COMPLEX);
        this.number = number;
    }

    @Override
    public Object createCacheObject(ThreadContext context) {
        return RubyComplex.newComplexRaw(context.runtime, context.runtime.newFixnum(0), (IRubyObject)this.number.cachedObject(context));
    }

    public String toString() {
        return this.number + "i";
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.Complex(this);
    }

    public Operand getNumber() {
        return this.number;
    }
}

