/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.ir.IRClassBody;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.FixedArityInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.ResultBaseInstr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.UndefinedValue;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class DefineClassInstr
extends ResultBaseInstr
implements FixedArityInstr {
    private final IRClassBody newIRClassBody;

    public DefineClassInstr(Variable result2, IRClassBody newIRClassBody, Operand container, Operand superClass) {
        super(Operation.DEF_CLASS, result2, new Operand[]{container, superClass == null ? UndefinedValue.UNDEFINED : superClass});
        assert (result2 != null) : "DefineClassInstr result is null";
        this.newIRClassBody = newIRClassBody;
    }

    public IRClassBody getNewIRClassBody() {
        return this.newIRClassBody;
    }

    public Operand getContainer() {
        return this.operands[0];
    }

    public Operand getSuperClass() {
        return this.operands[1];
    }

    @Override
    public Instr clone(CloneInfo ii) {
        return new DefineClassInstr(ii.getRenamedVariable(this.result), this.newIRClassBody, this.getContainer().cloneForInlining(ii), this.getSuperClass().cloneForInlining(ii));
    }

    @Override
    public Object interpret(ThreadContext context, StaticScope currScope, DynamicScope currDynScope, IRubyObject self2, Object[] temp) {
        Object container = this.getContainer().retrieve(context, self2, currScope, currDynScope, temp);
        Object superClass = this.getSuperClass().retrieve(context, self2, currScope, currDynScope, temp);
        return IRRuntimeHelpers.newInterpretedClassBody(context, this.newIRClassBody, container, superClass);
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.DefineClassInstr(this);
    }
}

