/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.dataflow;

import java.util.BitSet;
import java.util.List;
import java.util.ListIterator;
import org.jruby.dirgra.Edge;
import org.jruby.ir.dataflow.DataFlowProblem;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.representations.BasicBlock;
import org.jruby.ir.representations.CFG;

public abstract class FlowGraphNode<T extends DataFlowProblem<T, U>, U extends FlowGraphNode<T, U>> {
    protected final T problem;
    protected final BasicBlock basicBlock;
    private final BasicBlock rescuer;

    public FlowGraphNode(T problem, BasicBlock basicBlock) {
        this.problem = problem;
        this.basicBlock = basicBlock;
        this.rescuer = ((DataFlowProblem)problem).getScope().cfg().getRescuerBBFor(basicBlock);
    }

    public abstract void buildDataFlowVars(Instr var1);

    public void init() {
    }

    public abstract void applyPreMeetHandler();

    public abstract void compute_MEET(Edge var1, U var2);

    public void initSolution() {
    }

    public abstract void applyTransferFunction(Instr var1);

    public abstract boolean solutionChanged();

    public void finalizeSolution() {
    }

    public BasicBlock getBB() {
        return this.basicBlock;
    }

    public CFG getCFG() {
        return ((DataFlowProblem)this.problem).scope.getCFG();
    }

    public void buildDataFlowVars() {
        for (Instr i2 : this.basicBlock.getInstrs()) {
            this.buildDataFlowVars(i2);
        }
    }

    private void processDestBB(List<U> workList, BitSet bbSet, BasicBlock d) {
        int id2 = d.getID();
        if (!bbSet.get(id2)) {
            bbSet.set(id2);
            workList.add(((DataFlowProblem)this.problem).getFlowGraphNode(d));
        }
    }

    public void computeDataFlowInfo(List<U> workList, BitSet bbSet) {
        if (((DataFlowProblem)this.problem).getFlowDirection() == DataFlowProblem.DF_Direction.BIDIRECTIONAL) {
            throw new RuntimeException("Bidirectional data flow computation not implemented yet!");
        }
        bbSet.clear(this.basicBlock.getID());
        this.applyPreMeetHandler();
        if (((DataFlowProblem)this.problem).getFlowDirection() == DataFlowProblem.DF_Direction.FORWARD) {
            this.computeDataFlowInfoForward(workList, bbSet);
        } else {
            this.computeDataFlowInfoBackward(workList, bbSet);
        }
    }

    public void computeDataFlowInfoBackward(List<U> workList, BitSet bbSet) {
        for (Edge<BasicBlock> e : this.getCFG().getOutgoingEdges(this.basicBlock)) {
            this.compute_MEET(e, ((DataFlowProblem)this.problem).getFlowGraphNode(e.getDestination().getData()));
        }
        this.initSolution();
        List<Instr> instrs = this.basicBlock.getInstrs();
        ListIterator<Instr> it = instrs.listIterator(instrs.size());
        while (it.hasPrevious()) {
            Instr i2 = it.previous();
            this.applyTransferFunction(i2);
        }
        if (this.solutionChanged()) {
            for (BasicBlock b2 : this.getCFG().getIncomingSources(this.basicBlock)) {
                this.processDestBB(workList, bbSet, b2);
            }
        }
        this.finalizeSolution();
    }

    public void computeDataFlowInfoForward(List<U> workList, BitSet bbSet) {
        for (Edge<BasicBlock> e : this.getCFG().getIncomingEdges(this.basicBlock)) {
            this.compute_MEET(e, ((DataFlowProblem)this.problem).getFlowGraphNode(e.getSource().getData()));
        }
        this.initSolution();
        for (Instr i2 : this.basicBlock.getInstrs()) {
            this.applyTransferFunction(i2);
        }
        if (this.solutionChanged()) {
            for (BasicBlock b2 : this.getCFG().getOutgoingDestinations(this.basicBlock)) {
                this.processDestBB(workList, bbSet, b2);
            }
        }
        this.finalizeSolution();
    }

    public boolean hasExceptionsRescued() {
        return this.rescuer != null;
    }

    public U getExceptionTargetNode() {
        return ((DataFlowProblem)this.problem).getFlowGraphNode(this.rescuer == null ? this.getCFG().getExitBB() : this.rescuer);
    }
}

