/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir;

import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jcodings.specific.USASCIIEncoding;
import org.jruby.ast.MethodDefNode;
import org.jruby.internal.runtime.methods.IRMethodArgs;
import org.jruby.ir.IRBuilder;
import org.jruby.ir.IRManager;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRScopeType;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.ReceiveArgBase;
import org.jruby.ir.instructions.ReceiveKeywordArgInstr;
import org.jruby.ir.instructions.ReceiveKeywordRestArgInstr;
import org.jruby.ir.instructions.ReceiveRestArgInstr;
import org.jruby.ir.interpreter.InterpreterContext;
import org.jruby.ir.operands.Hash;
import org.jruby.ir.operands.LocalVariable;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Splat;
import org.jruby.ir.operands.Symbol;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.representations.BasicBlock;
import org.jruby.parser.StaticScope;
import org.jruby.util.KeyValuePair;

public class IRMethod
extends IRScope {
    public final boolean isInstanceMethod;
    private List<Operand> callArgs;
    private List<KeyValuePair<Operand, Operand>> keywordArgs;
    private List<String[]> argDesc;
    private Map<Integer, MethodType> signatures;
    private String jittedName;
    private MethodDefNode defn;

    public IRMethod(IRManager manager, IRScope lexicalParent, MethodDefNode defn, String name2, boolean isInstanceMethod, int lineNumber, StaticScope staticScope) {
        super(manager, lexicalParent, name2, lexicalParent.getFileName(), lineNumber, staticScope);
        this.defn = defn;
        this.isInstanceMethod = isInstanceMethod;
        this.callArgs = new ArrayList<Operand>();
        this.keywordArgs = new ArrayList<KeyValuePair<Operand, Operand>>();
        this.argDesc = new ArrayList<String[]>();
        this.signatures = new HashMap<Integer, MethodType>();
        if (!this.getManager().isDryRun() && staticScope != null) {
            staticScope.setIRScope(this);
            staticScope.setScopeType(this.getScopeType());
        }
    }

    @Override
    public synchronized InterpreterContext prepareForInterpretation() {
        if (this.defn != null) {
            IRBuilder.newIRBuilder(this.getManager()).defineMethodInner(this.defn, this, this.getLexicalParent());
            this.defn = null;
        }
        return super.prepareForInterpretation();
    }

    @Override
    public synchronized List<BasicBlock> prepareForCompilation() {
        if (this.defn != null) {
            this.prepareForInterpretation();
        }
        return super.prepareForCompilation();
    }

    @Override
    public IRScopeType getScopeType() {
        return this.isInstanceMethod ? IRScopeType.INSTANCE_METHOD : IRScopeType.CLASS_METHOD;
    }

    @Override
    public void addInstr(Instr i2) {
        if (i2 instanceof ReceiveKeywordRestArgInstr) {
            this.keywordArgs.add(0, new KeyValuePair<Symbol, Variable>(Symbol.KW_REST_ARG_DUMMY, ((ReceiveArgBase)i2).getResult()));
        } else if (i2 instanceof ReceiveKeywordArgInstr) {
            ReceiveKeywordArgInstr rkai = (ReceiveKeywordArgInstr)i2;
            this.keywordArgs.add(new KeyValuePair<Symbol, Variable>(new Symbol(rkai.argName, USASCIIEncoding.INSTANCE), rkai.getResult()));
        } else if (i2 instanceof ReceiveRestArgInstr) {
            this.callArgs.add(new Splat(((ReceiveRestArgInstr)i2).getResult()));
        } else if (i2 instanceof ReceiveArgBase) {
            this.callArgs.add(((ReceiveArgBase)i2).getResult());
        }
        super.addInstr(i2);
    }

    public void addArgDesc(IRMethodArgs.ArgType type2, String argName) {
        this.argDesc.add(new String[]{type2.name(), argName});
    }

    public List<String[]> getArgDesc() {
        return this.argDesc;
    }

    public Operand[] getCallArgs() {
        if (this.receivesKeywordArgs()) {
            int i2 = 0;
            Operand[] args2 = new Operand[this.callArgs.size() + 1];
            for (Operand arg2 : this.callArgs) {
                args2[i2++] = arg2;
            }
            args2[i2] = new Hash(this.keywordArgs, true);
            return args2;
        }
        return this.callArgs.toArray(new Operand[this.callArgs.size()]);
    }

    @Override
    protected LocalVariable findExistingLocalVariable(String name2, int scopeDepth) {
        assert (scopeDepth == 0) : "Local variable depth in IRMethod should always be zero (" + name2 + " had depth of " + scopeDepth + ")";
        return (LocalVariable)this.localVars.get(name2);
    }

    @Override
    public LocalVariable getLocalVariable(String name2, int scopeDepth) {
        LocalVariable lvar = this.findExistingLocalVariable(name2, scopeDepth);
        if (lvar == null) {
            lvar = this.getNewLocalVariable(name2, scopeDepth);
        }
        return lvar;
    }

    public void addNativeSignature(int arity2, MethodType signature) {
        this.signatures.put(arity2, signature);
    }

    public MethodType getNativeSignature(int arity2) {
        return this.signatures.get(arity2);
    }

    public Map<Integer, MethodType> getNativeSignatures() {
        return Collections.unmodifiableMap(this.signatures);
    }

    public String getJittedName() {
        return this.jittedName;
    }

    public void setJittedName(String jittedName) {
        this.jittedName = jittedName;
    }
}

