/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.ast.AssignableNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Arity;

public class MultipleAsgnNode
extends AssignableNode {
    private final ListNode pre;
    private final Node rest;

    public MultipleAsgnNode(ISourcePosition position, ListNode pre, Node rest2) {
        super(position);
        this.pre = pre;
        this.rest = rest2;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.MULTIPLEASGNNODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitMultipleAsgnNode(this);
    }

    public ListNode getHeadNode() {
        return this.pre;
    }

    public ListNode getPre() {
        return this.pre;
    }

    public int getPreCount() {
        return this.pre == null ? 0 : this.pre.size();
    }

    public Node getArgsNode() {
        return this.rest;
    }

    public Node getRest() {
        return this.rest;
    }

    @Override
    public Arity getArity() {
        if (this.rest != null) {
            return Arity.required(this.pre == null ? 0 : this.pre.size());
        }
        return Arity.fixed(this.pre.size());
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList((Node)this.pre, this.rest, this.getValueNode());
    }

    @Override
    public boolean needsDefinitionCheck() {
        return false;
    }
}

