/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.ArrayList;
import java.util.List;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.util.KeyValuePair;

public class HashNode
extends Node {
    private final List<KeyValuePair<Node, Node>> pairs = new ArrayList<KeyValuePair<Node, Node>>();

    public HashNode(ISourcePosition position) {
        super(position);
    }

    public HashNode(ISourcePosition position, KeyValuePair<Node, Node> pair) {
        this(position);
        this.pairs.add(pair);
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.HASHNODE;
    }

    public HashNode add(KeyValuePair<Node, Node> pair) {
        this.pairs.add(pair);
        return this;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitHashNode(this);
    }

    public boolean isEmpty() {
        return this.pairs.isEmpty();
    }

    public List<KeyValuePair<Node, Node>> getPairs() {
        return this.pairs;
    }

    @Override
    public List<Node> childNodes() {
        ArrayList<Node> children = new ArrayList<Node>();
        for (KeyValuePair<Node, Node> pair : this.pairs) {
            children.add(pair.getKey());
            children.add(pair.getValue());
        }
        return children;
    }
}

