/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.lexer.yacc.ISourcePosition;

public class ArgsCatNode
extends Node {
    private final Node firstNode;
    private final Node secondNode;

    public ArgsCatNode(ISourcePosition position, Node firstNode, Node secondNode) {
        super(position);
        assert (firstNode != null) : "ArgsCatNode.first == null";
        assert (secondNode != null) : "ArgsCatNode.second == null";
        this.firstNode = firstNode;
        this.secondNode = secondNode;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.ARGSCATNODE;
    }

    public Object accept(NodeVisitor visitor) {
        return visitor.visitArgsCatNode(this);
    }

    public Node getFirstNode() {
        return this.firstNode;
    }

    public Node getSecondNode() {
        return this.secondNode;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.firstNode, this.secondNode);
    }
}

