/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.instrument;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrument.Instrument;
import com.oracle.truffle.api.instrument.InstrumentationNode;
import com.oracle.truffle.api.instrument.Probe;
import com.oracle.truffle.api.instrument.SyntaxTagTrap;
import com.oracle.truffle.api.instrument.TruffleEventReceiver;
import com.oracle.truffle.api.nodes.InvalidAssumptionException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.source.SourceSection;

public abstract class ProbeNode
extends Node
implements TruffleEventReceiver,
InstrumentationNode {
    public static Probe insertProbe(WrapperNode wrapper) {
        SourceSection sourceSection = wrapper.getChild().getSourceSection();
        ProbeFullNode probeFullNode = new ProbeFullNode();
        Probe probe = new Probe(probeFullNode, sourceSection);
        probeFullNode.setProbe(probe);
        wrapper.insertProbe(probeFullNode);
        return probe;
    }

    public static void insertProbeLite(WrapperNode wrapper, TruffleEventReceiver eventReceiver) {
        ProbeLiteNode probeLiteNode = new ProbeLiteNode(eventReceiver);
        wrapper.insertProbe(probeLiteNode);
    }

    public abstract Probe getProbe() throws IllegalStateException;

    abstract void addInstrument(Instrument var1);

    abstract void removeInstrument(Instrument var1);

    public static interface Instrumentable {
        public Probe probe();

        public void probeLite(TruffleEventReceiver var1);
    }

    @NodeInfo(cost=NodeCost.NONE)
    private static final class ProbeFullNode
    extends ProbeNode {
        @Node.Child
        protected Instrument.InstrumentNode firstInstrument = null;
        @CompilerDirectives.CompilationFinal
        private Probe probe = null;
        private Assumption probeUnchangedAssumption;

        private ProbeFullNode() {
        }

        @Override
        public Probe getProbe() throws IllegalStateException {
            return this.probe;
        }

        @Override
        public Node copy() {
            Node node = super.copy();
            this.probe.registerProbeNodeClone((ProbeNode)node);
            return node;
        }

        private void setProbe(Probe probe) {
            this.probe = probe;
            this.probeUnchangedAssumption = probe.getUnchangedAssumption();
        }

        private void checkProbeUnchangedAssumption() {
            try {
                this.probeUnchangedAssumption.check();
            }
            catch (InvalidAssumptionException ex) {
                this.probeUnchangedAssumption = this.probe.getUnchangedAssumption();
            }
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        void addInstrument(Instrument instrument) {
            assert (instrument.getProbe() == this.probe);
            this.firstInstrument = this.insert(instrument.addToChain(this.firstInstrument));
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        void removeInstrument(Instrument instrument) {
            assert (instrument.getProbe() == this.probe);
            Instrument.InstrumentNode modifiedChain = instrument.removeFromChain(this.firstInstrument);
            this.firstInstrument = modifiedChain == null ? null : this.insert(modifiedChain);
        }

        @Override
        public void enter(Node node, VirtualFrame frame) {
            SyntaxTagTrap trap = this.probe.getTrap();
            if (trap != null) {
                this.checkProbeUnchangedAssumption();
                trap.tagTrappedAt(((WrapperNode)((Object)this.getParent())).getChild(), frame.materialize());
            }
            if (this.firstInstrument != null) {
                this.checkProbeUnchangedAssumption();
                this.firstInstrument.enter(node, frame);
            }
        }

        @Override
        public void returnVoid(Node node, VirtualFrame frame) {
            if (this.firstInstrument != null) {
                this.checkProbeUnchangedAssumption();
                this.firstInstrument.returnVoid(node, frame);
            }
        }

        @Override
        public void returnValue(Node node, VirtualFrame frame, Object result2) {
            if (this.firstInstrument != null) {
                this.checkProbeUnchangedAssumption();
                this.firstInstrument.returnValue(node, frame, result2);
            }
        }

        @Override
        public void returnExceptional(Node node, VirtualFrame frame, Exception exception2) {
            if (this.firstInstrument != null) {
                this.checkProbeUnchangedAssumption();
                this.firstInstrument.returnExceptional(node, frame, exception2);
            }
        }

        @Override
        public String instrumentationInfo() {
            return "Standard probe";
        }
    }

    @NodeInfo(cost=NodeCost.NONE)
    private static final class ProbeLiteNode
    extends ProbeNode {
        private final TruffleEventReceiver eventReceiver;

        private ProbeLiteNode(TruffleEventReceiver eventReceiver) {
            this.eventReceiver = eventReceiver;
        }

        @Override
        public Probe getProbe() throws IllegalStateException {
            throw new IllegalStateException("\"lite-Probed\" nodes have no explicit Probe");
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        void addInstrument(Instrument instrument) {
            throw new IllegalStateException("Instruments may not be added at a \"lite-probed\" location");
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        void removeInstrument(Instrument instrument) {
            throw new IllegalStateException("Instruments may not be removed at a \"lite-probed\" location");
        }

        @Override
        public void enter(Node node, VirtualFrame frame) {
            this.eventReceiver.enter(node, frame);
        }

        @Override
        public void returnVoid(Node node, VirtualFrame frame) {
            this.eventReceiver.returnVoid(node, frame);
        }

        @Override
        public void returnValue(Node node, VirtualFrame frame, Object result2) {
            this.eventReceiver.returnValue(node, frame, result2);
        }

        @Override
        public void returnExceptional(Node node, VirtualFrame frame, Exception exception2) {
            this.eventReceiver.returnExceptional(node, frame, exception2);
        }

        @Override
        public String instrumentationInfo() {
            return "\"Lite\" probe";
        }
    }

    public static interface WrapperNode
    extends InstrumentationNode {
        public Node getChild();

        public Probe getProbe();

        public void insertProbe(ProbeNode var1);
    }
}

