/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.io;

import jnr.constants.platform.OpenFlags;
import org.jruby.util.io.InvalidValueException;

public class ModeFlags
implements Cloneable {
    public static final int RDONLY = OpenFlags.O_RDONLY.intValue();
    public static final int WRONLY = OpenFlags.O_WRONLY.intValue();
    public static final int RDWR = OpenFlags.O_RDWR.intValue();
    public static final int CREAT = OpenFlags.O_CREAT.intValue();
    public static final int EXCL = OpenFlags.O_EXCL.intValue();
    public static final int TRUNC = OpenFlags.O_TRUNC.intValue();
    public static final int APPEND = OpenFlags.O_APPEND.intValue();
    public static final int NONBLOCK = OpenFlags.O_NONBLOCK.intValue();
    public static final int BINARY = OpenFlags.O_BINARY.intValue();
    public static final int TEXT = 0x10000000;
    public static final int ACCMODE = RDWR | WRONLY | RDONLY;
    private final int flags;

    public ModeFlags() {
        this.flags = RDONLY;
    }

    public ModeFlags(long flags) throws InvalidValueException {
        this.flags = (int)flags;
        if (this.isReadOnly() && (flags & (long)APPEND) != 0L) {
            throw new InvalidValueException();
        }
    }

    @Deprecated
    public ModeFlags(String flagString) throws InvalidValueException {
        this.flags = ModeFlags.getOFlagsFromString(flagString);
    }

    @Deprecated
    public static int getOFlagsFromString(String modesString) throws InvalidValueException {
        int modes = 0;
        int length2 = modesString.length();
        if (length2 == 0) {
            throw new InvalidValueException();
        }
        switch (modesString.charAt(0)) {
            case 'r': {
                modes |= RDONLY;
                break;
            }
            case 'a': {
                modes |= APPEND | WRONLY | CREAT;
                break;
            }
            case 'w': {
                modes |= WRONLY | TRUNC | CREAT;
                break;
            }
            default: {
                throw new InvalidValueException();
            }
        }
        block11: for (int n = 1; n < length2; ++n) {
            switch (modesString.charAt(n)) {
                case 'b': {
                    modes |= BINARY;
                    continue block11;
                }
                case '+': {
                    modes = modes & ~ACCMODE | RDWR;
                    continue block11;
                }
                case 't': {
                    modes |= 0x10000000;
                    continue block11;
                }
                case ':': {
                    break block11;
                }
                default: {
                    throw new InvalidValueException();
                }
            }
        }
        return modes;
    }

    public String toJavaModeString() {
        if (this.isWritable() || this.isCreate() || this.isTruncate()) {
            return "rw";
        }
        return "r";
    }

    public final boolean isReadOnly() {
        return (this.flags & WRONLY) == 0 && (this.flags & RDWR) == 0;
    }

    public boolean isReadable() {
        return (this.flags & RDWR) != 0 || this.isReadOnly();
    }

    public boolean isBinary() {
        return (this.flags & BINARY) != 0;
    }

    public boolean isText() {
        return (this.flags & 0x10000000) != 0;
    }

    public boolean isCreate() {
        return (this.flags & CREAT) != 0;
    }

    public boolean isWritable() {
        return (this.flags & RDWR) != 0 || (this.flags & WRONLY) != 0;
    }

    public boolean isExclusive() {
        return (this.flags & EXCL) != 0;
    }

    public boolean isAppendable() {
        return (this.flags & APPEND) != 0;
    }

    public boolean isTruncate() {
        return (this.flags & TRUNC) != 0;
    }

    public boolean isSubsetOf(ModeFlags superset) {
        return !(!superset.isReadable() && this.isReadable() || !superset.isWritable() && this.isWritable()) && (superset.isAppendable() || !this.isAppendable());
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("ModeFlags(" + this.flags + "): ");
        if (this.isAppendable()) {
            buf.append("APPENDABLE ");
        }
        if (this.isBinary()) {
            buf.append("BINARY ");
        }
        if (this.isCreate()) {
            buf.append("CREATE ");
        }
        if (this.isExclusive()) {
            buf.append("EXCLUSIVE ");
        }
        if (this.isReadOnly()) {
            buf.append("READONLY ");
        }
        if (this.isText()) {
            buf.append("TEXT ");
        }
        if (this.isTruncate()) {
            buf.append("TRUNCATE ");
        }
        if (this.isWritable()) {
            if (this.isReadable()) {
                buf.append("RDWR");
            } else {
                buf.append("WRITABLE ");
            }
        }
        return buf.toString();
    }

    public int getFlags() {
        return this.flags;
    }

    public static int getOpenFileFlagsFor(int flags) {
        int readWrite = flags & 3;
        int fmodeFlags = readWrite == RDONLY ? 1 : (readWrite == WRONLY ? 2 : 3);
        if ((flags & APPEND) != 0) {
            fmodeFlags |= 0x40;
        }
        if ((flags & CREAT) != 0) {
            fmodeFlags |= 0x80;
        }
        if ((flags & BINARY) == BINARY) {
            fmodeFlags |= 4;
        }
        if ((flags & 0x10000000) == 0x10000000) {
            fmodeFlags |= 0x1000;
        }
        return fmodeFlags;
    }

    public int getOpenFileFlags() {
        return ModeFlags.getOpenFileFlagsFor(this.flags);
    }

    public int getFcntlFileFlags() {
        int readWrite = this.flags & 3;
        int fcntlFlags = readWrite == RDONLY ? 0 : (readWrite == WRONLY ? 1 : 2);
        return fcntlFlags;
    }

    public static ModeFlags createModeFlags(int oflags) {
        try {
            return new ModeFlags(oflags);
        }
        catch (InvalidValueException e) {
            return new ModeFlags();
        }
    }
}

