/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.log;

import java.lang.reflect.Constructor;
import org.jruby.util.cli.Options;
import org.jruby.util.log.Logger;
import org.jruby.util.log.StandardErrorLogger;

public class LoggerFactory {
    private static final String LOGGER_CLASS;
    private static final String BACKUP_LOGGER_CLASS = "org.jruby.util.log.StandardErrorLogger";
    private static final Constructor<?> CTOR;

    public static Logger getLogger(String loggerName) {
        try {
            Logger logger = (Logger)CTOR.newInstance(loggerName);
            return logger;
        }
        catch (Exception e) {
            Throwable rootCause = e;
            while (rootCause.getCause() != null) {
                rootCause = rootCause.getCause();
            }
            if (rootCause instanceof SecurityException) {
                return new StandardErrorLogger(loggerName);
            }
            throw new IllegalStateException("unable to instantiate logger", e);
        }
    }

    static {
        Constructor<?> ctor;
        LOGGER_CLASS = Options.LOGGER_CLASS.load();
        try {
            Class<?> cls = Class.forName(LOGGER_CLASS);
            ctor = cls.getDeclaredConstructor(String.class);
            Logger log3 = (Logger)ctor.newInstance("LoggerFactory");
        }
        catch (Exception e1) {
            try {
                Class<?> cls = Class.forName(BACKUP_LOGGER_CLASS);
                ctor = cls.getDeclaredConstructor(String.class);
                Logger log4 = (Logger)ctor.newInstance("LoggerFactory");
                log4.debug("failed to create logger \"" + LOGGER_CLASS + "\", using \"" + BACKUP_LOGGER_CLASS + "\"", new Object[0]);
            }
            catch (Exception e2) {
                throw new IllegalStateException("unable to instantiate any logger", e1);
            }
        }
        CTOR = ctor;
    }
}

