/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jruby.RubyThread;
import org.jruby.internal.runtime.ThreadLike;
import org.jruby.internal.runtime.ThreadedRunnable;

public class FutureThread
implements ThreadLike {
    private volatile Future future;
    private volatile Thread nativeThread;
    private ThreadedRunnable runnable;
    public RubyThread rubyThread;

    public FutureThread(RubyThread rubyThread, ThreadedRunnable runnable) {
        this.rubyThread = rubyThread;
        this.runnable = runnable;
    }

    public Future getFuture() {
        return this.future;
    }

    @Override
    public void start() {
        this.future = this.rubyThread.getRuntime().getExecutor().submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                FutureThread.this.nativeThread = Thread.currentThread();
                try {
                    FutureThread.this.runnable.run();
                }
                finally {
                    FutureThread.this.rubyThread.getRuntime().getThreadService().dissociateThread(FutureThread.this.future);
                    FutureThread.this.nativeThread = null;
                }
            }
        });
    }

    @Override
    public void interrupt() {
        if (this.runnable.getJavaThread() != null) {
            this.runnable.getJavaThread().interrupt();
        }
    }

    @Override
    public boolean isAlive() {
        return this.future == null || !this.future.isDone();
    }

    @Override
    public void join() throws InterruptedException, ExecutionException {
        try {
            this.future.get();
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
    }

    @Override
    public void join(long millis) throws InterruptedException, ExecutionException {
        if (millis == 0L) {
            this.join();
        } else {
            try {
                this.future.get(millis, TimeUnit.MILLISECONDS);
            }
            catch (CancellationException cancellationException) {
            }
            catch (TimeoutException timeoutException) {
                // empty catch block
            }
        }
    }

    @Override
    public int getPriority() {
        if (this.nativeThread == null) {
            return 1;
        }
        return this.nativeThread.getPriority();
    }

    @Override
    public void setPriority(int priority2) {
        if (this.nativeThread == null) {
            return;
        }
        this.nativeThread.setPriority(priority2);
    }

    @Override
    public boolean isCurrent() {
        return this.rubyThread == this.rubyThread.getRuntime().getCurrentContext().getThread();
    }

    @Override
    public boolean isInterrupted() {
        return this.future.isCancelled();
    }

    @Override
    public Thread nativeThread() {
        return this.nativeThread;
    }
}

