/*
 * Decompiled with CFR 0.152.
 */
package jnr.posix.util;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import jnr.ffi.Memory;
import jnr.ffi.Pointer;
import jnr.ffi.Runtime;
import jnr.posix.POSIX;
import jnr.posix.util.Finder;

public class WindowsHelpers {
    static final Runtime runtime = Runtime.getSystemRuntime();
    static final int WORDSIZE = Runtime.getSystemRuntime().addressSize();
    private static final String COMMAND_DOT_COM = "command.com";
    private static final int CDC_LENGTH = "command.com".length();
    private static Map<String, InternalType> INTERNAL_COMMANDS = new HashMap<String, InternalType>(){
        {
            this.put("assoc", InternalType.COMMAND);
            this.put("break", InternalType.BOTH);
            this.put("call", InternalType.BOTH);
            this.put("cd", InternalType.BOTH);
            this.put("chcp", InternalType.SHELL);
            this.put("chdir", InternalType.BOTH);
            this.put("cls", InternalType.BOTH);
            this.put("color", InternalType.COMMAND);
            this.put("copy", InternalType.BOTH);
            this.put("ctty", InternalType.SHELL);
            this.put("date", InternalType.BOTH);
            this.put("del", InternalType.BOTH);
            this.put("dir", InternalType.BOTH);
            this.put("echo", InternalType.BOTH);
            this.put("endlocal", InternalType.COMMAND);
            this.put("erase", InternalType.BOTH);
            this.put("exit", InternalType.BOTH);
            this.put("for", InternalType.BOTH);
            this.put("ftype", InternalType.COMMAND);
            this.put("goto", InternalType.BOTH);
            this.put("if", InternalType.BOTH);
            this.put("lfnfor", InternalType.SHELL);
            this.put("lh", InternalType.SHELL);
            this.put("lock", InternalType.SHELL);
            this.put("md", InternalType.BOTH);
            this.put("mkdir", InternalType.BOTH);
            this.put("move", InternalType.COMMAND);
            this.put("path", InternalType.BOTH);
            this.put("pause", InternalType.BOTH);
            this.put("popd", InternalType.COMMAND);
            this.put("prompt", InternalType.BOTH);
            this.put("pushd", InternalType.COMMAND);
            this.put("rd", InternalType.BOTH);
            this.put("rem", InternalType.BOTH);
            this.put("ren", InternalType.BOTH);
            this.put("rename", InternalType.BOTH);
            this.put("rmdir", InternalType.BOTH);
            this.put("set", InternalType.BOTH);
            this.put("setlocal", InternalType.COMMAND);
            this.put("shift", InternalType.BOTH);
            this.put("start", InternalType.COMMAND);
            this.put("time", InternalType.BOTH);
            this.put("title", InternalType.COMMAND);
            this.put("truename", InternalType.SHELL);
            this.put("type", InternalType.BOTH);
            this.put("unlock", InternalType.SHELL);
            this.put("ver", InternalType.BOTH);
            this.put("verify", InternalType.BOTH);
            this.put("vol", InternalType.BOTH);
        }
    };

    public static byte[] toWPath(String path2) {
        boolean absolute = new File(path2).isAbsolute();
        if (absolute) {
            path2 = "//?/" + path2;
        }
        return WindowsHelpers.toWString(path2);
    }

    public static byte[] toWString(String string2) {
        if (string2 == null) {
            return null;
        }
        string2 = string2 + '\u0000';
        try {
            return string2.getBytes("UTF-16LE");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static Pointer createWideEnv(String[] envp) {
        if (envp == null) {
            return null;
        }
        byte[] marker = new byte[]{0};
        int envLength = envp.length;
        Pointer result2 = Memory.allocateDirect(runtime, WORDSIZE * (envLength + 1));
        for (int i2 = 0; i2 < envLength; ++i2) {
            byte[] bytes2 = WindowsHelpers.toWString(envp[i2]);
            Pointer envElement = Memory.allocateDirect(runtime, bytes2.length + 1);
            envElement.put(0L, bytes2, 0, bytes2.length);
            envElement.put((long)bytes2.length, marker, 0, marker.length);
            result2.putPointer(i2 * WORDSIZE, envElement);
        }
        Pointer nullMarker = Memory.allocateDirect(runtime, marker.length);
        nullMarker.put(0L, marker, 0, marker.length);
        result2.putPointer(WORDSIZE * envLength, nullMarker);
        return result2;
    }

    private static void joinSingleArgv(StringBuilder buffer, String arg2, boolean quote2, boolean escape) {
        int backslashCount = 0;
        int start2 = 0;
        if (quote2) {
            buffer.append('\"');
        }
        block5: for (int i2 = 0; i2 < arg2.length(); ++i2) {
            char c = arg2.charAt(i2);
            switch (c) {
                case '\\': {
                    ++backslashCount;
                    continue block5;
                }
                case '\"': {
                    buffer.append(arg2.substring(start2, i2));
                    for (int j = 0; j < backslashCount + 1; ++j) {
                        buffer.append('\\');
                    }
                    backslashCount = 0;
                    start2 = i2;
                }
                case '<': 
                case '>': 
                case '^': 
                case '|': {
                    if (escape && !quote2) {
                        buffer.append(arg2.substring(start2, i2));
                        buffer.append('^');
                        start2 = i2;
                        continue block5;
                    }
                }
                default: {
                    backslashCount = 0;
                }
            }
        }
        buffer.append(arg2.substring(start2));
        if (quote2) {
            buffer.append('\"');
        }
    }

    public static String joinArgv(String command, String[] argv, boolean escape) {
        StringBuilder buffer = new StringBuilder();
        if (command != null) {
            buffer.append(command);
            buffer.append(' ');
        }
        int last_index = argv.length - 1;
        for (int i2 = 0; i2 <= last_index; ++i2) {
            WindowsHelpers.joinSingleArgv(buffer, argv[i2], WindowsHelpers.quotable(argv[i2]), escape);
            if (i2 == last_index) continue;
            buffer.append(' ');
        }
        return buffer.toString();
    }

    public static boolean quotable(String value2) {
        if (value2 == null) {
            return false;
        }
        StringTokenizer toker = new StringTokenizer(value2, " \t\"'");
        toker.nextToken();
        return toker.hasMoreTokens();
    }

    public static boolean isBatch(String value2) {
        if (value2 == null) {
            return false;
        }
        int length2 = value2.length();
        if (length2 < 5) {
            return false;
        }
        String end2 = value2.substring(length2 - 4);
        return end2.equalsIgnoreCase(".bat") || end2.equalsIgnoreCase(".cmd");
    }

    public static String[] processCommandLine(POSIX posix, String command, String program, String path2) {
        String shell = null;
        if (program != null) {
            String fullPath = Finder.findFileInPath(posix, program, path2);
            shell = fullPath == null ? program : fullPath.replace('/', '\\');
        } else {
            command = command.substring(WindowsHelpers.firstNonWhitespaceIndex(command));
            shell = System.getenv("COMSPEC");
            boolean notHandledYet = true;
            if (shell != null) {
                boolean commandDotCom = WindowsHelpers.isCommandDotCom(shell);
                if (WindowsHelpers.hasBuiltinSpecialNeeds(command) || WindowsHelpers.isInternalCommand(command, commandDotCom)) {
                    String quote2 = commandDotCom ? "\"" : "";
                    command = shell + " /c " + quote2 + command + quote2;
                    notHandledYet = false;
                }
            }
            if (notHandledYet) {
                int i2;
                char firstChar = command.charAt(0);
                char quote3 = firstChar == '\"' ? firstChar : (firstChar == '\'' ? firstChar : (char)'\u0000');
                int commandLength = command.length();
                int n = i2 = quote3 == '\u0000' ? 0 : 1;
                while (true) {
                    if (i2 == commandLength) {
                        shell = command;
                        break;
                    }
                    char c = command.charAt(i2);
                    if (c == quote3) {
                        shell = command.substring(1, i2);
                        break;
                    }
                    if (quote3 == '\u0000' && (Character.isSpaceChar(c) || WindowsHelpers.isFunnyChar(c))) {
                        shell = command.substring(0, i2);
                        break;
                    }
                    ++i2;
                }
                shell = Finder.findFileInPath(posix, shell, path2);
                if (shell == null) {
                    shell = command.substring(0, i2);
                } else {
                    if (!shell.contains(" ")) {
                        quote3 = '\u0000';
                    }
                    shell.replace('/', '\\');
                }
            }
        }
        return new String[]{command, shell};
    }

    public static String[] processCommandArgs(POSIX posix, String program, String[] argv, String path2) {
        boolean commandDotCom;
        if (program == null || program.length() == 0) {
            program = argv[0];
        }
        boolean addSlashC = false;
        boolean isNotBuiltin = false;
        boolean notHandledYet = true;
        String shell = System.getenv("COMSPEC");
        String command = null;
        if (shell != null && WindowsHelpers.isInternalCommand(program, commandDotCom = WindowsHelpers.isCommandDotCom(shell))) {
            isNotBuiltin = !commandDotCom;
            program = shell;
            addSlashC = true;
            notHandledYet = false;
        }
        if (notHandledYet) {
            command = Finder.findFileInPath(posix, program, path2);
            if (command != null) {
                program = command.replace('/', '\\');
            } else if (program.contains("/")) {
                program = command = program.replace('/', '\\');
            }
        }
        if (addSlashC || WindowsHelpers.isBatch(program)) {
            if (addSlashC) {
                command = program + " /c ";
            } else {
                String[] newArgv = new String[argv.length - 1];
                System.arraycopy(argv, 1, newArgv, 0, argv.length - 1);
                argv = newArgv;
            }
            if (argv.length > 0) {
                command = WindowsHelpers.joinArgv(command, argv, isNotBuiltin);
            }
            program = addSlashC ? shell : null;
        } else {
            command = WindowsHelpers.joinArgv(null, argv, false);
        }
        return new String[]{command, program};
    }

    private static boolean isFunnyChar(char c) {
        return c == '<' || c == '>' || c == '|' || c == '*' || c == '?' || c == '\"';
    }

    private static boolean hasBuiltinSpecialNeeds(String value2) {
        int length2 = value2.length();
        char quote2 = '\u0000';
        block5: for (int i2 = 0; i2 < length2; ++i2) {
            char c = value2.charAt(i2);
            switch (c) {
                case '\"': 
                case '\'': {
                    if (quote2 == '\u0000') {
                        quote2 = c;
                        continue block5;
                    }
                    if (quote2 != c) continue block5;
                    quote2 = '\u0000';
                    continue block5;
                }
                case '\n': 
                case '<': 
                case '>': 
                case '|': {
                    if (quote2 == '\u0000') continue block5;
                    return true;
                }
                case '%': {
                    char c2;
                    if (i2 + 1 >= length2 || (c2 = value2.charAt(++i2)) != ' ' && !Character.isLetter(c2)) continue block5;
                    for (int j = i2; j < length2 && ((c2 = value2.charAt(j)) == ' ' || Character.isLetterOrDigit(c2)); ++j) {
                    }
                    if (c2 != '%') continue block5;
                    return true;
                }
            }
        }
        return false;
    }

    private static int firstNonWhitespaceIndex(String value2) {
        int i2;
        int length2 = value2.length();
        for (i2 = 0; i2 < length2 && Character.isSpaceChar(value2.charAt(i2)); ++i2) {
        }
        return i2;
    }

    public static String escapePath(String path2) {
        StringBuilder buf = new StringBuilder();
        for (int i2 = 0; i2 < path2.length(); ++i2) {
            char c = path2.charAt(i2);
            buf.append(c);
            if (c != '\\') continue;
            buf.append(c);
        }
        return buf.toString() + "\\\\";
    }

    private static boolean isDirectorySeparator(char value2) {
        return value2 == '/' || value2 == '\\';
    }

    private static boolean isCommandDotCom(String command) {
        int length2 = command.length();
        int i2 = length2 - CDC_LENGTH;
        return i2 == 0 || i2 > 0 && WindowsHelpers.isDirectorySeparator(command.charAt(i2 - 1)) && command.regionMatches(true, i2, COMMAND_DOT_COM, 0, CDC_LENGTH);
    }

    private static boolean isInternalCommand(String command, boolean hasCommandDotCom) {
        InternalType kindOf;
        int i2;
        assert (command != null && !Character.isSpaceChar(command.charAt(0))) : "Spaces should have been stripped off already";
        int length2 = command.length();
        StringBuilder buf = new StringBuilder();
        char c = '\u0000';
        for (i2 = 0; i2 < length2 && Character.isLetter(c = command.charAt(i2)); ++i2) {
            buf.append(Character.toLowerCase(c));
        }
        if (i2 < length2) {
            if (c == '.' && i2 + 1 < length2) {
                ++i2;
            }
            switch (command.charAt(i2)) {
                case '<': 
                case '>': 
                case '|': {
                    return true;
                }
                case '\u0000': 
                case '\t': 
                case '\n': 
                case ' ': {
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        return (kindOf = INTERNAL_COMMANDS.get(buf.toString())) == InternalType.BOTH || (hasCommandDotCom ? kindOf == InternalType.COMMAND : kindOf == InternalType.SHELL);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum InternalType {
        SHELL,
        COMMAND,
        BOTH;

    }
}

