/*
 * Decompiled with CFR 0.152.
 */
package org.joni;

import org.joni.CaptureTreeNode;

public final class Region {
    static final int REGION_NOTPOS = -1;
    public final int numRegs;
    public final int[] beg;
    public final int[] end;
    public CaptureTreeNode historyRoot;

    public Region(int num) {
        this.numRegs = num;
        this.beg = new int[num];
        this.end = new int[num];
    }

    public Region(int begin2, int end2) {
        this.numRegs = 1;
        this.beg = new int[]{begin2};
        this.end = new int[]{end2};
    }

    public Region clone() {
        Region region = new Region(this.numRegs);
        System.arraycopy(this.beg, 0, region.beg, 0, this.beg.length);
        System.arraycopy(this.end, 0, region.end, 0, this.end.length);
        if (this.historyRoot != null) {
            region.historyRoot = this.historyRoot.cloneTree();
        }
        return region;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Region: \n");
        for (int i2 = 0; i2 < this.beg.length; ++i2) {
            sb.append(" " + i2 + ": (" + this.beg[i2] + "-" + this.end[i2] + ")");
        }
        return sb.toString();
    }

    CaptureTreeNode getCaptureTree() {
        return this.historyRoot;
    }

    void clear() {
        for (int i2 = 0; i2 < this.beg.length; ++i2) {
            this.end[i2] = -1;
            this.beg[i2] = -1;
        }
    }
}

