/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.variable;

import org.jruby.Ruby;
import org.jruby.RubyObject;
import org.jruby.embed.internal.BiVariableMap;
import org.jruby.embed.variable.BiVariable;
import org.jruby.embed.variable.GlobalVariable;
import org.jruby.internal.runtime.GlobalVariables;
import org.jruby.runtime.builtin.IRubyObject;

public class LocalGlobalVariable
extends GlobalVariable {
    private static final String VALID_NAME = "([a-zA-Z]|(_([a-zA-Z]|_|\\d)))([a-zA-Z]|_|\\d)*";

    public static BiVariable getInstance(RubyObject receiver2, String name2, Object ... javaObject) {
        if (name2.matches(VALID_NAME)) {
            return new LocalGlobalVariable(receiver2, name2, javaObject);
        }
        return null;
    }

    private LocalGlobalVariable(RubyObject receiver2, String name2, Object ... javaObject) {
        super(receiver2, name2, javaObject);
    }

    LocalGlobalVariable(RubyObject receiver2, String name2, IRubyObject irubyObject) {
        super(receiver2, name2, irubyObject);
    }

    public static void retrieve(RubyObject receiver2, BiVariableMap vars) {
        if (vars.isLazy()) {
            return;
        }
        GlobalVariables globalVars = receiver2.getRuntime().getGlobalVariables();
        for (String name2 : globalVars.getNames()) {
            if (LocalGlobalVariable.isPredefined(name2)) continue;
            IRubyObject value2 = globalVars.get(name2);
            String javaName = name2.substring(1);
            LocalGlobalVariable.updateLocalGlobal(LocalGlobalVariable.getTopSelf(receiver2), vars, javaName, value2);
        }
    }

    private static void updateLocalGlobal(RubyObject receiver2, BiVariableMap vars, String name2, IRubyObject value2) {
        vars.updateVariable(receiver2, name2, value2, LocalGlobalVariable.class);
    }

    public static void retrieveByKey(Ruby runtime, BiVariableMap vars, String name2) {
        GlobalVariables globalVars = runtime.getGlobalVariables();
        String gName = ("$" + name2).intern();
        if (!globalVars.getNames().contains(gName)) {
            return;
        }
        IRubyObject value2 = globalVars.get(gName);
        LocalGlobalVariable.updateLocalGlobal((RubyObject)runtime.getTopSelf(), vars, name2, value2);
    }

    @Override
    public BiVariable.Type getType() {
        return BiVariable.Type.LocalGlobalVariable;
    }

    public static boolean isValidName(Object name2) {
        return LocalGlobalVariable.isValidName(VALID_NAME, name2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void inject() {
        Ruby ruby2 = this.getRuntime();
        synchronized (ruby2) {
            String gName = this.name.startsWith("$") ? this.name : "$" + this.name;
            this.getRuntime().getGlobalVariables().set(gName.intern(), this.irubyObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove() {
        Ruby ruby2 = this.getRuntime();
        synchronized (ruby2) {
            String gName = this.name.startsWith("$") ? this.name : "$" + this.name;
            this.getRuntime().getGlobalVariables().clear(gName.intern());
        }
    }
}

