/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import org.jruby.Ruby;
import org.jruby.ast.Match2Node;
import org.jruby.ast.Node;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class Match2CaptureNode
extends Match2Node {
    private int[] scopeOffsets;

    public Match2CaptureNode(ISourcePosition position, Node receiverNode, Node valueNode, int[] scopeOffsets) {
        super(position, receiverNode, valueNode);
        this.scopeOffsets = scopeOffsets;
    }

    public int[] getScopeOffsets() {
        return this.scopeOffsets;
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self2, Block aBlock) {
        IRubyObject result2 = super.interpret(runtime, context, self2, aBlock);
        Helpers.updateScopeWithCaptures(context, this.scopeOffsets, result2);
        return result2;
    }
}

