/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.impl;

import org.jruby.Ruby;
import org.jruby.anno.JRubyMethod;
import org.jruby.compiler.ASTInspector;
import org.jruby.compiler.CompilerCallback;
import org.jruby.compiler.impl.HeapBasedVariableCompiler;
import org.jruby.compiler.impl.RootScopedBodyCompiler;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.compiler.impl.StackBasedVariableCompiler;
import org.jruby.compiler.impl.StandardASMCompiler;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.CodegenUtils;
import org.objectweb.asm.AnnotationVisitor;

public class MethodBodyCompiler
extends RootScopedBodyCompiler {
    protected boolean specificArity;

    public MethodBodyCompiler(StandardASMCompiler scriptCompiler, String rubyName, String javaName, ASTInspector inspector, StaticScope scope, int scopeIndex) {
        super(scriptCompiler, javaName, rubyName, inspector, scope, scopeIndex);
    }

    public boolean isSpecificArity() {
        return this.specificArity;
    }

    @Override
    public String getSignature() {
        if (this.shouldUseBoxedArgs(this.scope)) {
            this.specificArity = false;
            return StandardASMCompiler.getStaticMethodSignature(this.script.getClassname(), 4);
        }
        this.specificArity = true;
        return StandardASMCompiler.getStaticMethodSignature(this.script.getClassname(), this.scope.getRequiredArgs());
    }

    @Override
    protected void createVariableCompiler() {
        this.variableCompiler = this.inspector == null ? new HeapBasedVariableCompiler(this, this.method, this.scope, this.specificArity, 3, this.getFirstTempIndex()) : (this.inspector.hasClosure() || this.inspector.hasScopeAwareMethods() ? new HeapBasedVariableCompiler(this, this.method, this.scope, this.specificArity, 3, this.getFirstTempIndex()) : new StackBasedVariableCompiler(this, this.method, this.scope, this.specificArity, 3, this.getFirstTempIndex()));
    }

    @Override
    public void beginMethod(CompilerCallback args2, StaticScope scope) {
        this.method.start();
        this.variableCompiler.beginMethod(args2, scope);
        this.method.label(this.scopeStart);
    }

    @Override
    public void endBody() {
        this.method.areturn();
        this.method.label(this.scopeEnd);
        this.variableCompiler.declareLocals(this.scope, this.scopeStart, this.scopeEnd);
        AnnotationVisitor annotation2 = this.method.visitAnnotation(CodegenUtils.ci(JRubyMethod.class), true);
        annotation2.visit("name", this.rubyName);
        annotation2.visit("frame", true);
        annotation2.visit("required", this.scope.getRequiredArgs());
        annotation2.visit("optional", this.scope.getOptionalArgs());
        annotation2.visit("rest", this.scope.getRestArg() >= 0);
        this.method.end();
        if (this.specificArity) {
            this.method = new SkinnyMethodAdapter(this.script.getClassVisitor(), 4105, this.methodName, StandardASMCompiler.getStaticMethodSignature(this.script.getClassname(), 4), null, null);
            this.method.start();
            this.method.aload(1);
            this.method.aload(3);
            this.method.pushInt(this.scope.getRequiredArgs());
            this.invokeUtilityMethod("checkArgumentCount", CodegenUtils.sig(Void.TYPE, ThreadContext.class, IRubyObject[].class, Integer.TYPE));
            this.loadThis();
            this.loadThreadContext();
            this.loadSelf();
            for (int i2 = 0; i2 < this.scope.getRequiredArgs(); ++i2) {
                this.method.aload(3);
                this.method.ldc(i2);
                this.method.arrayload();
            }
            this.method.aload(4);
            this.method.invokestatic(this.script.getClassname(), this.methodName, this.getSignature());
            this.method.areturn();
            this.method.end();
        }
    }

    @Override
    public void performReturn() {
        if (this.inRescue) {
            this.clearErrorInfo();
        }
        if (this.inNestedMethod) {
            this.loadThreadContext();
            this.invokeUtilityMethod("throwReturnJump", CodegenUtils.sig(IRubyObject.class, IRubyObject.class, ThreadContext.class));
        } else {
            this.method.areturn();
        }
    }

    @Override
    public void issueBreakEvent(CompilerCallback value2) {
        if (this.currentLoopLabels != null) {
            value2.call(this);
            this.issueLoopBreak();
        } else if (this.inNestedMethod) {
            this.loadThreadContext();
            value2.call(this);
            this.invokeUtilityMethod("breakJump", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class));
        } else {
            this.loadRuntime();
            value2.call(this);
            this.invokeUtilityMethod("breakLocalJumpError", CodegenUtils.sig(IRubyObject.class, Ruby.class, IRubyObject.class));
        }
    }

    @Override
    public void issueNextEvent(CompilerCallback value2) {
        if (this.currentLoopLabels != null) {
            value2.call(this);
            this.issueLoopNext();
        } else if (this.inNestedMethod) {
            value2.call(this);
            this.invokeUtilityMethod("nextJump", CodegenUtils.sig(IRubyObject.class, IRubyObject.class));
        } else {
            this.loadRuntime();
            value2.call(this);
            this.invokeUtilityMethod("nextLocalJumpError", CodegenUtils.sig(IRubyObject.class, Ruby.class, IRubyObject.class));
        }
    }

    @Override
    public void issueRedoEvent() {
        if (this.currentLoopLabels != null) {
            this.issueLoopRedo();
        } else if (this.inNestedMethod) {
            this.invokeUtilityMethod("redoJump", CodegenUtils.sig(IRubyObject.class, new Class[0]));
        } else {
            this.loadRuntime();
            this.invokeUtilityMethod("redoLocalJumpError", CodegenUtils.sig(IRubyObject.class, Ruby.class));
        }
    }

    @Override
    public boolean isSimpleRoot() {
        return !this.inNestedMethod;
    }
}

