/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jffi;

import com.kenai.jffi.ObjectParameterInfo;
import com.kenai.jffi.ObjectParameterType;

public abstract class ObjectParameterStrategy {
    private final boolean isDirect;
    final int typeInfo;
    protected static final StrategyType DIRECT = StrategyType.DIRECT;
    protected static final StrategyType HEAP = StrategyType.HEAP;

    public ObjectParameterStrategy(boolean isDirect) {
        this(isDirect, ObjectParameterType.INVALID);
    }

    public ObjectParameterStrategy(boolean isDirect, ObjectParameterType type2) {
        this.isDirect = isDirect;
        this.typeInfo = type2.typeInfo;
    }

    public ObjectParameterStrategy(StrategyType type2) {
        this(type2, ObjectParameterType.INVALID);
    }

    public ObjectParameterStrategy(StrategyType strategyType, ObjectParameterType parameterType) {
        this.isDirect = strategyType == DIRECT;
        this.typeInfo = parameterType.typeInfo;
    }

    public final boolean isDirect() {
        return this.isDirect;
    }

    final int objectInfo(ObjectParameterInfo info) {
        int objectInfo = info.asObjectInfo();
        if (this.typeInfo != 0) {
            return objectInfo & 0xFFFFFF | this.typeInfo;
        }
        return objectInfo;
    }

    public abstract long address(Object var1);

    public abstract Object object(Object var1);

    public abstract int offset(Object var1);

    public abstract int length(Object var1);

    protected static enum StrategyType {
        DIRECT,
        HEAP;

    }
}

