/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import org.jruby.CompatVersion;
import org.jruby.Profile;
import org.jruby.Ruby;
import org.jruby.ast.executable.Script;
import org.jruby.compiler.ASTCompiler;
import org.jruby.compiler.ASTCompiler19;
import org.jruby.embed.util.SystemPropertyCatcher;
import org.jruby.exceptions.MainExitException;
import org.jruby.runtime.backtrace.TraceType;
import org.jruby.runtime.load.LoadService;
import org.jruby.runtime.load.LoadService19;
import org.jruby.runtime.profile.ProfileOutput;
import org.jruby.util.ClassCache;
import org.jruby.util.InputStreamMarkCursor;
import org.jruby.util.JRubyFile;
import org.jruby.util.KCode;
import org.jruby.util.NormalizedFile;
import org.jruby.util.SafePropertyAccessor;
import org.jruby.util.cli.ArgumentProcessor;
import org.jruby.util.cli.Options;
import org.jruby.util.cli.OutputStrings;

public class RubyInstanceConfig {
    private static final Pattern RUBY_SHEBANG = Pattern.compile("#!.*ruby.*");
    private boolean xFlag = Options.CLI_STRIP_HEADER.load();
    private boolean hasShebangLine;
    private InputStream input = System.in;
    private PrintStream output = System.out;
    private PrintStream error = System.err;
    private Profile profile = Profile.DEFAULT;
    private boolean objectSpaceEnabled = Options.OBJECTSPACE_ENABLED.load();
    private boolean siphashEnabled = Options.SIPHASH_ENABLED.load();
    private CompileMode compileMode = CompileMode.JIT;
    private boolean runRubyInProcess = true;
    private String currentDirectory;
    private Map environment;
    private String[] argv = new String[0];
    private final boolean jitLogging;
    private final boolean jitDumping;
    private final boolean jitLoggingVerbose;
    private int jitLogEvery;
    private int jitThreshold;
    private int jitMax;
    private int jitMaxSize;
    private CompatVersion compatVersion;
    private String internalEncoding = Options.CLI_ENCODING_INTERNAL.load();
    private String externalEncoding = Options.CLI_ENCODING_EXTERNAL.load();
    private String sourceEncoding = Options.CLI_ENCODING_SOURCE.load();
    private ProfilingMode profilingMode = Options.CLI_PROFILING_MODE.load();
    private ProfileOutput profileOutput = new ProfileOutput(System.err);
    private ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
    private ClassLoader loader = this.contextLoader == null ? RubyInstanceConfig.class.getClassLoader() : this.contextLoader;
    private ClassCache<Script> classCache;
    private List<String> loadPaths = new ArrayList<String>();
    private Set<String> excludedMethods = new HashSet<String>();
    private StringBuffer inlineScript = new StringBuffer();
    private boolean hasInlineScript = false;
    private String scriptFileName = null;
    private Collection<String> requiredLibraries = new LinkedHashSet<String>();
    private boolean argvGlobalsOn = false;
    private boolean assumeLoop = Options.CLI_ASSUME_LOOP.load();
    private boolean assumePrinting = Options.CLI_ASSUME_PRINT.load();
    private Map optionGlobals = new HashMap();
    private boolean processLineEnds = Options.CLI_PROCESS_LINE_ENDS.load();
    private boolean split = Options.CLI_AUTOSPLIT.load();
    private Verbosity verbosity = Options.CLI_WARNING_LEVEL.load();
    private boolean debug = Options.CLI_DEBUG.load();
    private boolean showVersion = Options.CLI_VERSION.load();
    private boolean showBytecode = Options.CLI_BYTECODE.load();
    private boolean showCopyright = Options.CLI_COPYRIGHT.load();
    private boolean shouldRunInterpreter = true;
    private boolean shouldPrintUsage = Options.CLI_HELP.load();
    private boolean shouldPrintProperties = Options.CLI_PROPERTIES.load();
    private boolean dumpConfig = false;
    private KCode kcode = Options.CLI_KCODE.load();
    private String recordSeparator = Options.CLI_RECORD_SEPARATOR.load();
    private boolean shouldCheckSyntax = Options.CLI_CHECK_SYNTAX.load();
    private String inputFieldSeparator = Options.CLI_AUTOSPLIT_SEPARATOR.load();
    private boolean managementEnabled = false;
    private String inPlaceBackupExtension = Options.CLI_BACKUP_EXTENSION.load();
    private boolean parserDebug = false;
    private String threadDumpSignal = null;
    private boolean hardExit = false;
    private boolean disableGems = Options.CLI_RUBYGEMS_ENABLE.load() == false;
    private boolean updateNativeENVEnabled = true;
    private boolean kernelGsubDefined;
    private boolean hasScriptArgv = false;
    private boolean preferIPv4 = Options.PREFER_IPV4.load();
    private String jrubyHome;
    private boolean _nativeEnabled = NATIVE_ENABLED;
    private boolean _cextEnabled = CEXT_ENABLED;
    private TraceType traceType = TraceType.traceTypeFor(Options.BACKTRACE_STYLE.load());
    private boolean backtraceMask = Options.BACKTRACE_MASK.load();
    private boolean backtraceColor = Options.BACKTRACE_COLOR.load();
    private LoadServiceCreator creator = LoadServiceCreator.DEFAULT;
    private boolean globalRequireLock = Options.GLOBAL_REQUIRE_LOCK.load();
    private boolean jitBackground = Options.JIT_BACKGROUND.load();
    private boolean loadGemfile = Options.CLI_LOAD_GEMFILE.load();
    private int profileMaxMethods = Options.PROFILE_MAX_METHODS.load();
    private boolean allowUppercasePackageNames = Options.JI_UPPER_CASE_PACKAGE_NAME_ALLOWED.load();
    public static final int JAVA_VERSION = RubyInstanceConfig.initGlobalJavaVersion();
    public static final int CHAINED_COMPILE_LINE_COUNT = Options.COMPILE_CHAINSIZE.load();
    public static final boolean PEEPHOLE_OPTZ = Options.COMPILE_PEEPHOLE.load();
    public static boolean NOGUARDS_COMPILE_ENABLED = Options.COMPILE_NOGUARDS.load();
    public static boolean FASTEST_COMPILE_ENABLED = Options.COMPILE_FASTEST.load();
    public static boolean FASTOPS_COMPILE_ENABLED = FASTEST_COMPILE_ENABLED || Options.COMPILE_FASTOPS.load() != false;
    public static boolean THREADLESS_COMPILE_ENABLED = FASTEST_COMPILE_ENABLED || Options.COMPILE_THREADLESS.load() != false;
    public static boolean FASTSEND_COMPILE_ENABLED = FASTEST_COMPILE_ENABLED || Options.COMPILE_FASTSEND.load() != false;
    public static boolean LAZYHANDLES_COMPILE = Options.COMPILE_LAZYHANDLES.load();
    public static boolean FAST_MULTIPLE_ASSIGNMENT = Options.COMPILE_FASTMASGN.load();
    public static final boolean POOLING_ENABLED = Options.THREADPOOL_ENABLED.load();
    public static final int POOL_MAX = Options.THREADPOOL_MAX.load();
    public static final int POOL_MIN = Options.THREADPOOL_MIN.load();
    public static final int POOL_TTL = Options.THREADPOOL_TTL.load();
    public static final int FIBER_POOL_TTL = Options.FIBER_THREADPOOL_TTL.load();
    public static final boolean NATIVE_NET_PROTOCOL = Options.NATIVE_NET_PROTOCOL.load();
    public static boolean FULL_TRACE_ENABLED = Options.DEBUG_FULLTRACE.load();
    public static final String COMPILE_EXCLUDE = Options.JIT_EXCLUDE.load();
    public static final boolean NATIVE_ENABLED = Options.NATIVE_ENABLED.load();
    public static final boolean CEXT_ENABLED = Options.CEXT_ENABLED.load();
    public static final boolean REIFY_RUBY_CLASSES = Options.REIFY_CLASSES.load();
    public static final boolean REIFY_LOG_ERRORS = Options.REIFY_LOGERRORS.load();
    public static final boolean USE_GENERATED_HANDLES = Options.JAVA_HANDLES.load();
    public static final boolean DEBUG_LOAD_SERVICE = Options.DEBUG_LOADSERVICE.load();
    public static final boolean DEBUG_LOAD_TIMINGS = Options.DEBUG_LOADSERVICE_TIMING.load();
    public static final boolean DEBUG_LAUNCHING = Options.DEBUG_LAUNCH.load();
    public static final boolean DEBUG_SCRIPT_RESOLUTION = Options.DEBUG_SCRIPTRESOLUTION.load();
    public static final boolean DEBUG_PARSER = Options.DEBUG_PARSER.load();
    public static final boolean JUMPS_HAVE_BACKTRACE = Options.JUMP_BACKTRACE.load();
    public static final boolean JIT_CACHE_ENABLED = Options.JIT_CACHE.load();
    public static final String JIT_CODE_CACHE = Options.JIT_CODECACHE.load();
    public static final boolean REFLECTED_HANDLES = Options.REFLECTED_HANDLES.load();
    public static final boolean NO_UNWRAP_PROCESS_STREAMS = Options.PROCESS_NOUNWRAP.load();
    public static final boolean INTERFACES_USE_PROXY = Options.INTERFACES_USEPROXY.load();
    public static final boolean JIT_LOADING_DEBUG = Options.JIT_DEBUG.load();
    public static final boolean CAN_SET_ACCESSIBLE = Options.JI_SETACCESSIBLE.load();
    @Deprecated
    public static final boolean UPPER_CASE_PACKAGE_NAME_ALLOWED = Options.JI_UPPER_CASE_PACKAGE_NAME_ALLOWED.load();
    public static final boolean USE_INVOKEDYNAMIC = Options.COMPILE_INVOKEDYNAMIC.load();
    public static final int MAX_FAIL_COUNT = Options.INVOKEDYNAMIC_MAXFAIL.load();
    public static final int MAX_POLY_COUNT = Options.INVOKEDYNAMIC_MAXPOLY.load();
    public static final boolean LOG_INDY_BINDINGS = Options.INVOKEDYNAMIC_LOG_BINDING.load();
    public static final boolean LOG_INDY_CONSTANTS = Options.INVOKEDYNAMIC_LOG_CONSTANTS.load();
    public static final boolean INVOKEDYNAMIC_ALL = USE_INVOKEDYNAMIC && Options.INVOKEDYNAMIC_ALL.load() != false;
    public static final boolean INVOKEDYNAMIC_SAFE = USE_INVOKEDYNAMIC && Options.INVOKEDYNAMIC_SAFE.load() != false;
    private static final boolean invokedynamicOn = INVOKEDYNAMIC_ALL || INVOKEDYNAMIC_SAFE || USE_INVOKEDYNAMIC;
    public static final boolean INVOKEDYNAMIC_INVOCATION = invokedynamicOn && Options.INVOKEDYNAMIC_INVOCATION.load() != false;
    private static final boolean invokedynamicInvocation = invokedynamicOn && INVOKEDYNAMIC_INVOCATION;
    public static final boolean INVOKEDYNAMIC_INVOCATION_SWITCHPOINT = invokedynamicInvocation && Options.INVOKEDYNAMIC_INVOCATION_SWITCHPOINT.load() != false;
    public static final boolean INVOKEDYNAMIC_INDIRECT = invokedynamicInvocation && Options.INVOKEDYNAMIC_INVOCATION_INDIRECT.load() != false;
    public static final boolean INVOKEDYNAMIC_JAVA = invokedynamicInvocation && Options.INVOKEDYNAMIC_INVOCATION_JAVA.load() != false;
    public static final boolean INVOKEDYNAMIC_ATTR = invokedynamicInvocation && Options.INVOKEDYNAMIC_INVOCATION_ATTR.load() != false;
    public static final boolean INVOKEDYNAMIC_FASTOPS = invokedynamicInvocation && Options.INVOKEDYNAMIC_INVOCATION_FASTOPS.load() != false;
    public static final boolean INVOKEDYNAMIC_CACHE = invokedynamicOn && Options.INVOKEDYNAMIC_CACHE.load() != false;
    private static final boolean invokedynamicCache = invokedynamicOn && INVOKEDYNAMIC_CACHE;
    public static final boolean INVOKEDYNAMIC_CONSTANTS = invokedynamicCache && Options.INVOKEDYNAMIC_CACHE_CONSTANTS.load() != false;
    public static final boolean INVOKEDYNAMIC_LITERALS = invokedynamicCache && Options.INVOKEDYNAMIC_CACHE_LITERALS.load() != false;
    public static final boolean INVOKEDYNAMIC_IVARS = invokedynamicCache && Options.INVOKEDYNAMIC_CACHE_IVARS.load() != false;
    public static final boolean LOG_EXCEPTIONS = Options.LOG_EXCEPTIONS.load();
    public static final boolean LOG_BACKTRACES = Options.LOG_BACKTRACES.load();
    public static final boolean LOG_CALLERS = Options.LOG_CALLERS.load();
    public static final boolean LOG_WARNINGS = Options.LOG_WARNINGS.load();
    public static final boolean ERRNO_BACKTRACE = Options.ERRNO_BACKTRACE.load();
    public static final boolean STOPITERATION_BACKTRACE = Options.STOPITERATION_BACKTRACE.load();
    public static boolean IR_DEBUG = Options.IR_DEBUG.load();
    public static boolean IR_PROFILE = Options.IR_PROFILE.load();
    public static boolean IR_COMPILER_DEBUG = Options.IR_COMPILER_DEBUG.load();
    public static boolean IR_VISUALIZER = Options.IR_VISUALIZER.load();
    public static String IR_COMPILER_PASSES = Options.IR_COMPILER_PASSES.load();
    public static String IR_INLINE_COMPILER_PASSES = Options.IR_INLINE_COMPILER_PASSES.load();
    public static final boolean COROUTINE_FIBERS = Options.FIBER_COROUTINES.load();
    public static final boolean CONSISTENT_HASHING_ENABLED = Options.CONSISTENT_HASHING.load();
    private static volatile boolean loadedNativeExtensions = false;
    @Deprecated
    public static final int JIT_MAX_METHODS_LIMIT = 4096;
    @Deprecated
    public static final int JIT_MAX_SIZE_LIMIT = 30000;
    @Deprecated
    public static final int JIT_THRESHOLD = 50;
    @Deprecated
    public static final int CHAINED_COMPILE_LINE_COUNT_DEFAULT = 500;
    @Deprecated
    public static final boolean nativeEnabled = NATIVE_ENABLED;

    public RubyInstanceConfig() {
        this.currentDirectory = Ruby.isSecurityRestricted() ? "/" : JRubyFile.getFileProperty("user.dir");
        String compatString = Options.COMPAT_VERSION.load();
        this.compatVersion = CompatVersion.getVersionFromString(compatString);
        if (this.compatVersion == null) {
            this.error.println("Compatibility version `" + compatString + "' invalid; use 1.8, 1.9, or 2.0. Using 1.8.");
            this.compatVersion = CompatVersion.RUBY1_9;
        }
        if (Ruby.isSecurityRestricted()) {
            this.compileMode = CompileMode.OFF;
            this.jitLogging = false;
            this.jitDumping = false;
            this.jitLoggingVerbose = false;
            this.jitLogEvery = 0;
            this.jitThreshold = -1;
            this.jitMax = 0;
            this.jitMaxSize = -1;
            this.managementEnabled = false;
        } else {
            if (COMPILE_EXCLUDE != null) {
                String[] elements = COMPILE_EXCLUDE.split(",");
                this.excludedMethods.addAll(Arrays.asList(elements));
            }
            this.managementEnabled = Options.MANAGEMENT_ENABLED.load();
            this.runRubyInProcess = Options.LAUNCH_INPROC.load();
            String jitModeProperty = Options.COMPILE_MODE.load();
            if (jitModeProperty.equals("OFF")) {
                this.compileMode = CompileMode.OFF;
            } else if (jitModeProperty.equals("OFFIR")) {
                this.compileMode = CompileMode.OFFIR;
            } else if (jitModeProperty.equals("JIT")) {
                this.compileMode = CompileMode.JIT;
            } else if (jitModeProperty.equals("FORCE")) {
                this.compileMode = CompileMode.FORCE;
            } else {
                this.error.print(Options.COMPILE_MODE + " property must be OFF, JIT, FORCE, or unset; defaulting to JIT");
                this.compileMode = CompileMode.JIT;
            }
            this.jitLogging = Options.JIT_LOGGING.load();
            this.jitDumping = Options.JIT_DUMPING.load();
            this.jitLoggingVerbose = Options.JIT_LOGGING_VERBOSE.load();
            this.jitLogEvery = Options.JIT_LOGEVERY.load();
            this.jitThreshold = Options.JIT_THRESHOLD.load();
            this.jitMax = Options.JIT_MAX.load();
            this.jitMaxSize = Options.JIT_MAXSIZE.load();
        }
        this.classCache = new ClassCache(this.loader, this.jitMax);
        this.threadDumpSignal = Options.THREAD_DUMP_SIGNAL.load();
        try {
            this.environment = System.getenv();
        }
        catch (SecurityException se) {
            this.environment = new HashMap();
        }
    }

    public RubyInstanceConfig(RubyInstanceConfig parentConfig) {
        this.currentDirectory = parentConfig.getCurrentDirectory();
        this.compatVersion = parentConfig.compatVersion;
        this.compileMode = parentConfig.getCompileMode();
        this.jitLogging = parentConfig.jitLogging;
        this.jitDumping = parentConfig.jitDumping;
        this.jitLoggingVerbose = parentConfig.jitLoggingVerbose;
        this.jitLogEvery = parentConfig.jitLogEvery;
        this.jitThreshold = parentConfig.jitThreshold;
        this.jitMax = parentConfig.jitMax;
        this.jitMaxSize = parentConfig.jitMaxSize;
        this.managementEnabled = parentConfig.managementEnabled;
        this.runRubyInProcess = parentConfig.runRubyInProcess;
        this.excludedMethods = parentConfig.excludedMethods;
        this.threadDumpSignal = parentConfig.threadDumpSignal;
        this.updateNativeENVEnabled = parentConfig.updateNativeENVEnabled;
        this.classCache = new ClassCache(this.loader, this.jitMax);
        try {
            this.environment = System.getenv();
        }
        catch (SecurityException se) {
            this.environment = new HashMap();
        }
    }

    public RubyInstanceConfig(InputStream in, PrintStream out, PrintStream err) {
        this();
        this.setInput(in);
        this.setOutput(out);
        this.setError(err);
    }

    public LoadService createLoadService(Ruby runtime) {
        return this.creator.create(runtime);
    }

    public void processArguments(String[] arguments) {
        new ArgumentProcessor(arguments, this).processArguments();
        this.tryProcessArgumentsWithRubyopts();
    }

    public void tryProcessArgumentsWithRubyopts() {
        try {
            String rubyopt;
            Object rubyoptObj = this.environment.get("RUBYOPT");
            String string2 = rubyopt = rubyoptObj == null ? null : rubyoptObj.toString();
            if (rubyopt == null || "".equals(rubyopt)) {
                return;
            }
            if (rubyopt.split("\\s").length != 0) {
                String[] rubyoptArgs = rubyopt.split("\\s+");
                new ArgumentProcessor(rubyoptArgs, false, true, this).processArguments();
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    private boolean isShebang(InputStreamMarkCursor cursor) throws IOException {
        if (cursor.read() == 35) {
            int c = cursor.read();
            if (c == 33) {
                cursor.endPoint(-2);
                return true;
            }
            if (c == 10) {
                cursor.rewind();
            }
        } else {
            cursor.rewind();
        }
        return false;
    }

    private boolean skipToNextLine(InputStreamMarkCursor cursor) throws IOException {
        int c = cursor.read();
        do {
            if (c != 10) continue;
            return true;
        } while ((c = cursor.read()) != -1);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void eatToShebang(InputStream in) {
        InputStreamMarkCursor cursor = new InputStreamMarkCursor(in, 8192);
        try {
            do {
                if (!this.isShebang(cursor)) continue;
                break;
            } while (this.skipToNextLine(cursor));
        }
        catch (IOException e) {
        }
        finally {
            try {
                cursor.finish();
            }
            catch (IOException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] parseShebangOptions(InputStream in) {
        BufferedReader reader = null;
        String[] result2 = new String[]{};
        if (in == null) {
            return result2;
        }
        if (this.isXFlag()) {
            this.eatToShebang(in);
        }
        try {
            InputStreamMarkCursor cursor = new InputStreamMarkCursor(in, 8192);
            try {
                if (!this.isShebang(cursor)) {
                    String[] stringArray = result2;
                    return stringArray;
                }
            }
            finally {
                cursor.finish();
            }
            in.mark(8192);
            reader = new BufferedReader(new InputStreamReader(in, "iso-8859-1"), 8192);
            String firstLine = reader.readLine();
            boolean usesEnv = false;
            if (firstLine.length() > 2 && firstLine.charAt(0) == '#' && firstLine.charAt(1) == '!') {
                int i2;
                String[] options2 = firstLine.substring(2).split("\\s+");
                for (i2 = 0; i2 < options2.length; ++i2) {
                    String basename2;
                    if (i2 == 0 && options2[i2].endsWith("/env")) {
                        usesEnv = true;
                        continue;
                    }
                    if (!(usesEnv && options2[i2].indexOf(61) > 0 || usesEnv && options2[i2].startsWith("-") || (basename2 = new File(options2[i2]).getName()).indexOf("ruby") <= 0)) break;
                }
                this.setHasShebangLine(true);
                System.arraycopy(options2, i2, result2, 0, options2.length - i2);
            } else {
                this.setHasShebangLine(false);
            }
        }
        catch (Exception ex) {
        }
        finally {
            try {
                in.reset();
            }
            catch (IOException ex) {}
        }
        return result2;
    }

    protected static boolean isRubyShebangLine(String line) {
        return RUBY_SHEBANG.matcher(line).matches();
    }

    private String calculateJRubyHome() {
        String newJRubyHome = null;
        if (!Ruby.isSecurityRestricted()) {
            newJRubyHome = SafePropertyAccessor.getProperty("jruby.home");
        }
        if (newJRubyHome != null) {
            newJRubyHome = RubyInstanceConfig.verifyHome(newJRubyHome, this.error);
        } else {
            try {
                newJRubyHome = SystemPropertyCatcher.findFromJar(this);
            }
            catch (Exception exception2) {
                // empty catch block
            }
            newJRubyHome = newJRubyHome != null ? RubyInstanceConfig.verifyHome(newJRubyHome, this.error) : SafePropertyAccessor.getProperty("java.io.tmpdir");
        }
        return newJRubyHome;
    }

    private static String verifyHome(String home2, PrintStream error2) {
        if (home2.equals(".")) {
            home2 = SafePropertyAccessor.getProperty("user.dir");
        }
        if (home2.startsWith("cp:")) {
            home2 = home2.substring(3);
        } else if (!home2.startsWith("file:") && !home2.startsWith("classpath:")) {
            NormalizedFile f = new NormalizedFile(home2);
            if (!f.isAbsolute()) {
                home2 = f.getAbsolutePath();
            }
            if (!f.exists()) {
                error2.println("Warning: JRuby home \"" + f + "\" does not exist, using " + SafePropertyAccessor.getProperty("java.io.tmpdir"));
                return System.getProperty("java.io.tmpdir");
            }
        }
        return home2;
    }

    public boolean isUpdateNativeENVEnabled() {
        return this.updateNativeENVEnabled;
    }

    public void setUpdateNativeENVEnabled(boolean updateNativeENVEnabled) {
        this.updateNativeENVEnabled = updateNativeENVEnabled;
    }

    public byte[] inlineScript() {
        return this.inlineScript.toString().getBytes();
    }

    public InputStream getScriptSource() {
        try {
            if (this.hasInlineScript) {
                return new ByteArrayInputStream(this.inlineScript());
            }
            if (this.isSourceFromStdin()) {
                if (this.isShowVersion()) {
                    return null;
                }
                return this.getInput();
            }
            String script = this.getScriptFileName();
            InputStream stream = null;
            if (script.startsWith("file:") && script.indexOf(".jar!/") != -1) {
                stream = new URL("jar:" + script).openStream();
            } else if (script.startsWith("classpath:")) {
                stream = Ruby.getClassLoader().getResourceAsStream(script.substring("classpath:".length()));
            } else {
                JRubyFile file2 = JRubyFile.create(this.getCurrentDirectory(), this.getScriptFileName());
                if (this.isXFlag()) {
                    return RubyInstanceConfig.findScript(file2);
                }
                stream = new FileInputStream(file2);
            }
            return new BufferedInputStream(stream, 8192);
        }
        catch (IOException e) {
            InputStream is = RubyInstanceConfig.getJarScriptSource(this.scriptFileName);
            if (is != null) {
                return new BufferedInputStream(is, 8129);
            }
            throw new MainExitException(1, "Error opening script file: " + e.getMessage());
        }
    }

    private static InputStream findScript(File file2) throws IOException {
        StringBuffer buf = new StringBuffer();
        BufferedReader br = new BufferedReader(new FileReader(file2));
        String currentLine = br.readLine();
        while (currentLine != null && !RubyInstanceConfig.isRubyShebangLine(currentLine)) {
            currentLine = br.readLine();
        }
        buf.append(currentLine);
        buf.append("\n");
        do {
            if ((currentLine = br.readLine()) == null) continue;
            buf.append(currentLine);
            buf.append("\n");
        } while (currentLine != null && !currentLine.contains("__END__") && !currentLine.contains("\u0016"));
        return new BufferedInputStream(new ByteArrayInputStream(buf.toString().getBytes()), 8192);
    }

    private static InputStream getJarScriptSource(String scriptFileName) {
        boolean looksLikeJarURL;
        boolean bl = looksLikeJarURL = scriptFileName.startsWith("file:") && scriptFileName.indexOf("!/") != -1;
        if (!looksLikeJarURL) {
            return null;
        }
        String before = scriptFileName.substring("file:".length(), scriptFileName.indexOf("!/"));
        String after = scriptFileName.substring(scriptFileName.indexOf("!/") + 2);
        try {
            JarFile jFile = new JarFile(before);
            JarEntry entry = jFile.getJarEntry(after);
            if (entry != null && !entry.isDirectory()) {
                return jFile.getInputStream(entry);
            }
        }
        catch (IOException ignored) {
            // empty catch block
        }
        return null;
    }

    public String displayedFileName() {
        if (this.hasInlineScript) {
            if (this.scriptFileName != null) {
                return this.scriptFileName;
            }
            return "-e";
        }
        if (this.isSourceFromStdin()) {
            return "-";
        }
        return this.getScriptFileName();
    }

    public ASTCompiler newCompiler() {
        if (this.getCompatVersion() == CompatVersion.RUBY1_8) {
            return new ASTCompiler();
        }
        return new ASTCompiler19();
    }

    public static boolean hasLoadedNativeExtensions() {
        return loadedNativeExtensions;
    }

    public static void setLoadedNativeExtensions(boolean loadedNativeExtensions) {
        RubyInstanceConfig.loadedNativeExtensions = loadedNativeExtensions;
    }

    public LoadServiceCreator getLoadServiceCreator() {
        return this.creator;
    }

    public void setLoadServiceCreator(LoadServiceCreator creator) {
        this.creator = creator;
    }

    public String getJRubyHome() {
        if (this.jrubyHome == null) {
            this.jrubyHome = this.calculateJRubyHome();
        }
        return this.jrubyHome;
    }

    public void setJRubyHome(String home2) {
        this.jrubyHome = RubyInstanceConfig.verifyHome(home2, this.error);
    }

    public CompileMode getCompileMode() {
        return this.compileMode;
    }

    public void setCompileMode(CompileMode compileMode) {
        this.compileMode = compileMode;
    }

    public boolean isJitLogging() {
        return this.jitLogging;
    }

    public boolean isJitDumping() {
        return this.jitDumping;
    }

    public boolean isJitLoggingVerbose() {
        return this.jitLoggingVerbose;
    }

    public int getJitLogEvery() {
        return this.jitLogEvery;
    }

    public void setJitLogEvery(int jitLogEvery) {
        this.jitLogEvery = jitLogEvery;
    }

    public int getJitThreshold() {
        return this.jitThreshold;
    }

    public void setJitThreshold(int jitThreshold) {
        this.jitThreshold = jitThreshold;
    }

    public int getJitMax() {
        return this.jitMax;
    }

    public void setJitMax(int jitMax) {
        this.jitMax = jitMax;
    }

    public int getJitMaxSize() {
        return this.jitMaxSize;
    }

    public void setJitMaxSize(int jitMaxSize) {
        this.jitMaxSize = jitMaxSize;
    }

    public boolean isRunRubyInProcess() {
        return this.runRubyInProcess;
    }

    public void setRunRubyInProcess(boolean flag) {
        this.runRubyInProcess = flag;
    }

    public void setInput(InputStream newInput) {
        this.input = newInput;
    }

    public InputStream getInput() {
        return this.input;
    }

    public CompatVersion getCompatVersion() {
        return this.compatVersion;
    }

    public void setCompatVersion(CompatVersion compatVersion) {
        if (compatVersion == null) {
            compatVersion = CompatVersion.RUBY1_8;
        }
        this.compatVersion = compatVersion;
    }

    public void setOutput(PrintStream newOutput) {
        this.output = newOutput;
    }

    public PrintStream getOutput() {
        return this.output;
    }

    public void setError(PrintStream newError) {
        this.error = newError;
    }

    public PrintStream getError() {
        return this.error;
    }

    public void setCurrentDirectory(String newCurrentDirectory) {
        this.currentDirectory = newCurrentDirectory;
    }

    public String getCurrentDirectory() {
        return this.currentDirectory;
    }

    public void setProfile(Profile newProfile) {
        this.profile = newProfile;
    }

    public Profile getProfile() {
        return this.profile;
    }

    public void setObjectSpaceEnabled(boolean newObjectSpaceEnabled) {
        this.objectSpaceEnabled = newObjectSpaceEnabled;
    }

    public boolean isObjectSpaceEnabled() {
        return this.objectSpaceEnabled;
    }

    public void setSiphashEnabled(boolean newSiphashEnabled) {
        this.siphashEnabled = newSiphashEnabled;
    }

    public boolean isSiphashEnabled() {
        return this.siphashEnabled;
    }

    public void setEnvironment(Map newEnvironment) {
        if (newEnvironment == null) {
            newEnvironment = new HashMap();
        }
        this.environment = newEnvironment;
    }

    public Map getEnvironment() {
        return this.environment;
    }

    public ClassLoader getLoader() {
        return this.loader;
    }

    public void setLoader(ClassLoader loader) {
        if (this.loader != loader) {
            this.classCache = new ClassCache(loader, this.classCache.getMax());
        }
        this.loader = loader;
    }

    public String[] getArgv() {
        return this.argv;
    }

    public void setArgv(String[] argv) {
        this.argv = argv;
    }

    public StringBuffer getInlineScript() {
        return this.inlineScript;
    }

    public void setHasInlineScript(boolean hasInlineScript) {
        this.hasScriptArgv = true;
        this.hasInlineScript = hasInlineScript;
    }

    public boolean hasInlineScript() {
        return this.hasInlineScript;
    }

    public Collection<String> getRequiredLibraries() {
        return this.requiredLibraries;
    }

    public List<String> getLoadPaths() {
        return this.loadPaths;
    }

    public void setLoadPaths(List<String> loadPaths) {
        this.loadPaths = loadPaths;
    }

    public void setShouldPrintUsage(boolean shouldPrintUsage) {
        this.shouldPrintUsage = shouldPrintUsage;
    }

    public boolean getShouldPrintUsage() {
        return this.shouldPrintUsage;
    }

    public void setShouldPrintProperties(boolean shouldPrintProperties) {
        this.shouldPrintProperties = shouldPrintProperties;
    }

    public boolean getShouldPrintProperties() {
        return this.shouldPrintProperties;
    }

    public boolean isInlineScript() {
        return this.hasInlineScript;
    }

    private boolean isSourceFromStdin() {
        return this.getScriptFileName() == null;
    }

    public void setScriptFileName(String scriptFileName) {
        this.hasScriptArgv = true;
        this.scriptFileName = scriptFileName;
    }

    public String getScriptFileName() {
        return this.scriptFileName;
    }

    public void setAssumeLoop(boolean assumeLoop) {
        this.assumeLoop = assumeLoop;
    }

    public boolean isAssumeLoop() {
        return this.assumeLoop;
    }

    public void setAssumePrinting(boolean assumePrinting) {
        this.assumePrinting = assumePrinting;
    }

    public boolean isAssumePrinting() {
        return this.assumePrinting;
    }

    public void setProcessLineEnds(boolean processLineEnds) {
        this.processLineEnds = processLineEnds;
    }

    public boolean isProcessLineEnds() {
        return this.processLineEnds;
    }

    public void setSplit(boolean split2) {
        this.split = split2;
    }

    public boolean isSplit() {
        return this.split;
    }

    public Verbosity getVerbosity() {
        return this.verbosity;
    }

    public void setVerbosity(Verbosity verbosity) {
        this.verbosity = verbosity;
    }

    public boolean isVerbose() {
        return this.verbosity == Verbosity.TRUE;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean isParserDebug() {
        return this.parserDebug;
    }

    public void setParserDebug(boolean parserDebug) {
        this.parserDebug = parserDebug;
    }

    public boolean getParserDebug() {
        return this.parserDebug;
    }

    public void setShowVersion(boolean showVersion) {
        this.showVersion = showVersion;
    }

    public boolean isShowVersion() {
        return this.showVersion;
    }

    public void setShowBytecode(boolean showBytecode) {
        this.showBytecode = showBytecode;
    }

    public boolean isShowBytecode() {
        return this.showBytecode;
    }

    public void setShowCopyright(boolean showCopyright) {
        this.showCopyright = showCopyright;
    }

    public boolean isShowCopyright() {
        return this.showCopyright;
    }

    public void setShouldRunInterpreter(boolean shouldRunInterpreter) {
        this.shouldRunInterpreter = shouldRunInterpreter;
    }

    public boolean getShouldRunInterpreter() {
        return this.shouldRunInterpreter && (this.hasScriptArgv || !this.showVersion);
    }

    public void setShouldCheckSyntax(boolean shouldSetSyntax) {
        this.shouldCheckSyntax = shouldSetSyntax;
    }

    public boolean getShouldCheckSyntax() {
        return this.shouldCheckSyntax;
    }

    public void setInputFieldSeparator(String inputFieldSeparator) {
        this.inputFieldSeparator = inputFieldSeparator;
    }

    public String getInputFieldSeparator() {
        return this.inputFieldSeparator;
    }

    public KCode getKCode() {
        return this.kcode;
    }

    public void setKCode(KCode kcode2) {
        this.kcode = kcode2;
    }

    public void setInternalEncoding(String internalEncoding) {
        this.internalEncoding = internalEncoding;
    }

    public String getInternalEncoding() {
        return this.internalEncoding;
    }

    public void setExternalEncoding(String externalEncoding) {
        this.externalEncoding = externalEncoding;
    }

    public String getExternalEncoding() {
        return this.externalEncoding;
    }

    public void setSourceEncoding(String sourceEncoding) {
        this.sourceEncoding = sourceEncoding;
    }

    public String getSourceEncoding() {
        return this.sourceEncoding;
    }

    public void setRecordSeparator(String recordSeparator) {
        this.recordSeparator = recordSeparator;
    }

    public String getRecordSeparator() {
        return this.recordSeparator;
    }

    public int getSafeLevel() {
        return 0;
    }

    public ClassCache getClassCache() {
        return this.classCache;
    }

    public void setInPlaceBackupExtension(String inPlaceBackupExtension) {
        this.inPlaceBackupExtension = inPlaceBackupExtension;
    }

    public String getInPlaceBackupExtension() {
        return this.inPlaceBackupExtension;
    }

    public void setClassCache(ClassCache classCache) {
        this.classCache = classCache;
    }

    public Map getOptionGlobals() {
        return this.optionGlobals;
    }

    public boolean isManagementEnabled() {
        return this.managementEnabled;
    }

    public Set getExcludedMethods() {
        return this.excludedMethods;
    }

    public boolean isArgvGlobalsOn() {
        return this.argvGlobalsOn;
    }

    public void setArgvGlobalsOn(boolean argvGlobalsOn) {
        this.argvGlobalsOn = argvGlobalsOn;
    }

    public String getThreadDumpSignal() {
        return this.threadDumpSignal;
    }

    public boolean isHardExit() {
        return this.hardExit;
    }

    public void setHardExit(boolean hardExit) {
        this.hardExit = hardExit;
    }

    public boolean isProfiling() {
        return this.profilingMode != ProfilingMode.OFF;
    }

    public boolean isProfilingEntireRun() {
        return this.profilingMode != ProfilingMode.OFF && this.profilingMode != ProfilingMode.API;
    }

    public void setProfilingMode(ProfilingMode profilingMode) {
        this.profilingMode = profilingMode;
    }

    public ProfilingMode getProfilingMode() {
        return this.profilingMode;
    }

    public void setProfileOutput(ProfileOutput output) {
        this.profileOutput = output;
    }

    public ProfileOutput getProfileOutput() {
        return this.profileOutput;
    }

    public boolean hasShebangLine() {
        return this.hasShebangLine;
    }

    public void setHasShebangLine(boolean hasShebangLine) {
        this.hasShebangLine = hasShebangLine;
    }

    public boolean isDisableGems() {
        return this.disableGems;
    }

    public void setDisableGems(boolean dg) {
        this.disableGems = dg;
    }

    public TraceType getTraceType() {
        return this.traceType;
    }

    public void setTraceType(TraceType traceType) {
        this.traceType = traceType;
    }

    public void setHasScriptArgv(boolean argvRemains) {
        this.hasScriptArgv = argvRemains;
    }

    public boolean getHasScriptArgv() {
        return this.hasScriptArgv;
    }

    public boolean getBacktraceMask() {
        return this.backtraceMask;
    }

    public void setBacktraceMask(boolean backtraceMask) {
        this.backtraceMask = backtraceMask;
    }

    public void setNativeEnabled(boolean b) {
        this._nativeEnabled = false;
    }

    public boolean isNativeEnabled() {
        return this._nativeEnabled;
    }

    public void setCextEnabled(boolean b) {
        this._cextEnabled = b;
    }

    public boolean isCextEnabled() {
        return this._cextEnabled;
    }

    public void setXFlag(boolean xFlag) {
        this.xFlag = xFlag;
    }

    public boolean isXFlag() {
        return this.xFlag;
    }

    public boolean getBacktraceColor() {
        return this.backtraceColor;
    }

    public void setBacktraceColor(boolean backtraceColor) {
        this.backtraceColor = backtraceColor;
    }

    public boolean isGlobalRequireLock() {
        return this.globalRequireLock;
    }

    public void setGlobalRequireLock(boolean globalRequireLock) {
        this.globalRequireLock = globalRequireLock;
    }

    public void setJitBackground(boolean jitBackground) {
        this.jitBackground = jitBackground;
    }

    public boolean getJitBackground() {
        return this.jitBackground;
    }

    public void setLoadGemfile(boolean loadGemfile) {
        this.loadGemfile = loadGemfile;
    }

    public boolean getLoadGemfile() {
        return this.loadGemfile;
    }

    public void setProfileMaxMethods(int profileMaxMethods) {
        this.profileMaxMethods = profileMaxMethods;
    }

    public int getProfileMaxMethods() {
        return this.profileMaxMethods;
    }

    public void setKernelGsubDefined(boolean setDefineKernelGsub) {
        this.kernelGsubDefined = setDefineKernelGsub;
    }

    public boolean getKernelGsubDefined() {
        return this.kernelGsubDefined;
    }

    public boolean getIPv4Preferred() {
        return this.preferIPv4;
    }

    public boolean getAllowUppercasePackageNames() {
        return this.allowUppercasePackageNames;
    }

    public void setAllowUppercasePackageNames(boolean allow) {
        this.allowUppercasePackageNames = allow;
    }

    private static int initGlobalJavaVersion() {
        String specVersion = Options.BYTECODE_VERSION.load();
        if (specVersion.equals("1.5")) {
            return 49;
        }
        if (specVersion.equals("1.6")) {
            return 50;
        }
        if (specVersion.equals("1.7") || specVersion.equals("1.8")) {
            return 51;
        }
        throw new RuntimeException("unsupported Java version: " + specVersion);
    }

    @Deprecated
    public void setSafeLevel(int safeLevel) {
    }

    @Deprecated
    public String getInPlaceBackupExtention() {
        return this.inPlaceBackupExtension;
    }

    @Deprecated
    public String getBasicUsageHelp() {
        return OutputStrings.getBasicUsageHelp();
    }

    @Deprecated
    public String getExtendedHelp() {
        return OutputStrings.getExtendedHelp();
    }

    @Deprecated
    public String getPropertyHelp() {
        return OutputStrings.getPropertyHelp();
    }

    @Deprecated
    public String getVersionString() {
        return OutputStrings.getVersionString(this.compatVersion);
    }

    @Deprecated
    public String getCopyrightString() {
        return OutputStrings.getCopyrightString();
    }

    @Deprecated
    public Collection<String> requiredLibraries() {
        return this.requiredLibraries;
    }

    @Deprecated
    public List<String> loadPaths() {
        return this.loadPaths;
    }

    @Deprecated
    public boolean shouldPrintUsage() {
        return this.shouldPrintUsage;
    }

    @Deprecated
    public boolean shouldPrintProperties() {
        return this.shouldPrintProperties;
    }

    @Deprecated
    public Boolean getVerbose() {
        return this.isVerbose();
    }

    @Deprecated
    public boolean shouldRunInterpreter() {
        return this.isShouldRunInterpreter();
    }

    @Deprecated
    public boolean isShouldRunInterpreter() {
        return this.shouldRunInterpreter;
    }

    @Deprecated
    public boolean isxFlag() {
        return this.xFlag;
    }

    @Deprecated
    public boolean isSamplingEnabled() {
        return false;
    }

    @Deprecated
    public void setBenchmarking(boolean benchmarking) {
    }

    @Deprecated
    public boolean isBenchmarking() {
        return false;
    }

    public static enum CompileMode {
        JIT,
        FORCE,
        FORCEIR,
        OFF,
        OFFIR;


        public boolean shouldPrecompileCLI() {
            switch (this) {
                case JIT: 
                case FORCE: 
                case FORCEIR: {
                    return true;
                }
            }
            return false;
        }

        public boolean shouldJIT() {
            switch (this) {
                case JIT: 
                case FORCE: 
                case FORCEIR: {
                    return true;
                }
            }
            return false;
        }

        public boolean shouldPrecompileAll() {
            return this == FORCE;
        }
    }

    public static enum ProfilingMode {
        OFF,
        API,
        FLAT,
        GRAPH,
        HTML,
        JSON;

    }

    public static interface LoadServiceCreator {
        public static final LoadServiceCreator DEFAULT = new LoadServiceCreator(){

            @Override
            public LoadService create(Ruby runtime) {
                if (runtime.is1_9()) {
                    return new LoadService19(runtime);
                }
                return new LoadService(runtime);
            }
        };

        public LoadService create(Ruby var1);
    }

    public static enum Verbosity {
        NIL,
        FALSE,
        TRUE;

    }
}

