/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.profile;

import java.util.ArrayList;
import org.jruby.runtime.profile.Invocation;
import org.jruby.runtime.profile.InvocationSet;

class MethodData
extends InvocationSet {
    final int serialNumber;

    MethodData(int serial) {
        super(new ArrayList<Invocation>());
        this.serialNumber = serial;
    }

    public int[] parents() {
        IntList p2 = new IntList();
        for (Invocation inv : this.invocations) {
            int serial;
            if (inv.getParent() == null || p2.contains(serial = inv.getParent().getMethodSerialNumber())) continue;
            p2.add(serial);
        }
        return p2.toIntArray();
    }

    public int[] children() {
        IntList p2 = new IntList();
        for (Invocation inv : this.invocations) {
            for (Integer childSerial : inv.getChildren().keySet()) {
                if (p2.contains(childSerial)) continue;
                p2.add(childSerial);
            }
        }
        return p2.toIntArray();
    }

    public InvocationSet invocationsForParent(int parentSerial) {
        ArrayList<Invocation> p2 = new ArrayList<Invocation>();
        for (Invocation inv : this.invocations) {
            int serial = inv.getParent().getMethodSerialNumber();
            if (serial != parentSerial) continue;
            p2.add(inv.getParent());
        }
        return new InvocationSet(p2);
    }

    public InvocationSet rootInvocationsFromParent(int parentSerial) {
        ArrayList<Invocation> p2 = new ArrayList<Invocation>();
        for (Invocation inv : this.invocations) {
            int serial = inv.getParent().getMethodSerialNumber();
            if (serial != parentSerial || inv.getRecursiveDepth() != 1) continue;
            p2.add(inv);
        }
        return new InvocationSet(p2);
    }

    public InvocationSet invocationsFromParent(int parentSerial) {
        ArrayList<Invocation> p2 = new ArrayList<Invocation>();
        for (Invocation inv : this.invocations) {
            int serial = inv.getParent().getMethodSerialNumber();
            if (serial != parentSerial) continue;
            p2.add(inv);
        }
        return new InvocationSet(p2);
    }

    public InvocationSet rootInvocationsOfChild(int childSerial) {
        ArrayList<Invocation> p2 = new ArrayList<Invocation>();
        for (Invocation inv : this.invocations) {
            Invocation childInv = inv.getChildren().get(childSerial);
            if (childInv == null || childInv.getRecursiveDepth() != 1) continue;
            p2.add(childInv);
        }
        return new InvocationSet(p2);
    }

    public InvocationSet invocationsOfChild(int childSerial) {
        ArrayList<Invocation> p2 = new ArrayList<Invocation>();
        for (Invocation inv : this.invocations) {
            Invocation childInv = inv.getChildren().get(childSerial);
            if (childInv == null) continue;
            p2.add(childInv);
        }
        return new InvocationSet(p2);
    }

    @Override
    public long totalTime() {
        long t = 0L;
        for (Invocation inv : this.invocations) {
            if (inv.getRecursiveDepth() != 1) continue;
            t += inv.getDuration();
        }
        return t;
    }

    @Override
    public long childTime() {
        long t = 0L;
        for (Invocation inv : this.invocations) {
            if (inv.getRecursiveDepth() != 1) continue;
            t += inv.childTime();
        }
        return t;
    }

    private static class IntList {
        private int[] ints = new int[10];
        private int size;

        private IntList() {
        }

        public void add(int i2) {
            if (this.size == this.ints.length) {
                int[] newInts = new int[(int)((double)this.ints.length * 1.5 + 1.0)];
                System.arraycopy(this.ints, 0, newInts, 0, this.ints.length);
                this.ints = newInts;
            }
            this.ints[this.size++] = i2;
        }

        public boolean contains(int i2) {
            for (int j = 0; j < this.size; ++j) {
                if (this.ints[j] != i2) continue;
                return true;
            }
            return false;
        }

        public int[] toIntArray() {
            int[] newInts = new int[this.size];
            System.arraycopy(this.ints, 0, newInts, 0, this.size);
            return newInts;
        }
    }
}

