/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.fiber;

import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.jruby.Ruby;
import org.jruby.RubyBasicObject;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.RubyThread;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.thread.SizedQueue;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Block;
import org.jruby.runtime.ExecutionContext;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class ThreadFiber
extends RubyObject
implements ExecutionContext {
    volatile FiberData data;
    volatile RubyThread thread;

    public ThreadFiber(Ruby runtime, RubyClass klass) {
        super(runtime, klass);
    }

    public static void initRootFiber(ThreadContext context) {
        Ruby runtime = context.runtime;
        ThreadFiber rootFiber = new ThreadFiber(runtime, runtime.getClass("Fiber"));
        assert (runtime.getClass("SizedQueue") != null) : "SizedQueue has not been loaded";
        rootFiber.data = new FiberData(new SizedQueue(runtime, runtime.getClass("SizedQueue")), null, rootFiber);
        rootFiber.thread = context.getThread();
        context.setRootFiber(rootFiber);
    }

    @JRubyMethod
    public IRubyObject initialize(ThreadContext context, Block block) {
        Ruby runtime = context.runtime;
        if (!block.isGiven()) {
            throw runtime.newArgumentError("tried to create Proc object without block");
        }
        this.data = new FiberData(new SizedQueue(runtime, runtime.getClass("SizedQueue")), context.getFiberCurrentThread(), this);
        FiberData currentFiberData = context.getFiber().data;
        this.thread = ThreadFiber.createThread(runtime, this.data, currentFiberData.queue, block);
        return context.nil;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(rest=true)
    public IRubyObject resume(ThreadContext context, IRubyObject[] values2) {
        IRubyObject val;
        Ruby runtime = context.runtime;
        if (this.data.prev != null || this.data.transferred) {
            throw runtime.newFiberError("double resume");
        }
        if (!this.alive()) {
            throw runtime.newFiberError("dead fiber called");
        }
        FiberData currentFiberData = context.getFiber().data;
        if (this.data == currentFiberData) {
            switch (values2.length) {
                case 0: {
                    return context.nil;
                }
                case 1: {
                    return values2[0];
                }
            }
            return runtime.newArrayNoCopyLight(values2);
        }
        switch (values2.length) {
            case 0: {
                val = NEVER;
                break;
            }
            case 1: {
                val = values2[0];
                break;
            }
            default: {
                val = runtime.newArrayNoCopyLight(values2);
            }
        }
        if (this.data.parent != context.getFiberCurrentThread()) {
            throw runtime.newFiberError("fiber called across threads");
        }
        this.data.prev = context.getFiber();
        try {
            this.data.queue.push(context, val);
            IRubyObject result2 = currentFiberData.queue.pop(context);
            if (result2 == NEVER) {
                result2 = context.nil;
            }
            IRubyObject iRubyObject = result2;
            return iRubyObject;
        }
        finally {
            this.data.prev = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(rest=true)
    public IRubyObject __transfer__(ThreadContext context, IRubyObject[] values2) {
        IRubyObject val;
        Ruby runtime = context.runtime;
        if (this.data.prev != null) {
            throw runtime.newFiberError("double resume");
        }
        if (!this.alive()) {
            throw runtime.newFiberError("dead fiber called");
        }
        FiberData currentFiberData = context.getFiber().data;
        if (this.data == currentFiberData) {
            switch (values2.length) {
                case 0: {
                    return context.nil;
                }
                case 1: {
                    return values2[0];
                }
            }
            return runtime.newArrayNoCopyLight(values2);
        }
        switch (values2.length) {
            case 0: {
                val = NEVER;
                break;
            }
            case 1: {
                val = values2[0];
                break;
            }
            default: {
                val = runtime.newArrayNoCopyLight(values2);
            }
        }
        if (this.data.parent != context.getFiberCurrentThread()) {
            throw runtime.newFiberError("fiber called across threads");
        }
        if (currentFiberData.prev != null) {
            this.data.prev = currentFiberData.prev;
            currentFiberData.prev = null;
            currentFiberData.transferred = true;
        } else {
            this.data.prev = context.getFiber();
        }
        try {
            this.data.queue.push(context, val);
            IRubyObject result2 = currentFiberData.queue.pop(context);
            if (result2 == NEVER) {
                result2 = context.nil;
            }
            IRubyObject iRubyObject = result2;
            return iRubyObject;
        }
        finally {
            this.data.prev = null;
            currentFiberData.transferred = false;
        }
    }

    @JRubyMethod(meta=true)
    public static IRubyObject yield(ThreadContext context, IRubyObject recv2) {
        return ThreadFiber.yield(context, recv2, context.nil);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject yield(ThreadContext context, IRubyObject recv2, IRubyObject value2) {
        Ruby runtime = context.runtime;
        FiberData currentFiberData = context.getFiber().data;
        if (currentFiberData.parent == null) {
            throw runtime.newFiberError("can't yield from root fiber");
        }
        FiberData prevFiberData = currentFiberData.prev.data;
        prevFiberData.queue.push(context, value2);
        IRubyObject result2 = currentFiberData.queue.pop(context);
        if (result2 == NEVER) {
            result2 = context.nil;
        }
        return result2;
    }

    @JRubyMethod
    public IRubyObject __alive__(ThreadContext context) {
        return context.runtime.newBoolean(this.thread != null && this.thread.isAlive());
    }

    @JRubyMethod(meta=true)
    public static IRubyObject __current__(ThreadContext context, IRubyObject recv2) {
        return context.getFiber();
    }

    @Override
    public Map<Object, IRubyObject> getContextVariables() {
        return this.thread.getContextVariables();
    }

    boolean alive() {
        return this.thread != null && this.thread.isAlive();
    }

    static RubyThread createThread(final Ruby runtime, final FiberData data2, SizedQueue queue, final Block block) {
        final AtomicReference fiberThread = new AtomicReference();
        Thread thread2 = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ThreadContext context = runtime.getCurrentContext();
                context.setFiber((ThreadFiber)data2.fiber.get());
                context.setRootThread(data2.parent);
                fiberThread.set(context.getThread());
                IRubyObject init = data2.queue.pop(context);
                try {
                    IRubyObject result2 = init == RubyBasicObject.NEVER ? block.yieldSpecific(context) : block.yieldArray(context, init, null, null);
                    data2.prev.data.queue.push(context, result2);
                }
                catch (JumpException.FlowControlException fce) {
                    if (data2.prev != null) {
                        data2.prev.thread.raise(fce.buildException(runtime).getException());
                    }
                }
                catch (RaiseException re) {
                    if (data2.prev != null) {
                        data2.prev.thread.raise(re.getException());
                    }
                }
                catch (Throwable t) {
                    if (data2.prev != null) {
                        data2.prev.thread.raise(JavaUtil.convertJavaToUsableRubyObject(runtime, t));
                    }
                }
                finally {
                    data2.queue.shutdown();
                }
            }
        };
        thread2.setDaemon(true);
        thread2.setName("FiberThread#" + ((ThreadFiber)data2.fiber.get()).id());
        thread2.start();
        while (fiberThread.get() == null) {
        }
        return (RubyThread)fiberThread.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            RubyThread thread2;
            FiberData data2 = this.data;
            if (data2 != null) {
                if (data2.parent == null) {
                    return;
                }
                data2.queue.shutdown();
            }
            if ((thread2 = this.thread) != null) {
                thread2.dieFromFinalizer();
                thread2.interrupt();
                data2 = null;
                Object var2_2 = null;
            }
        }
        finally {
            super.finalize();
        }
    }

    private static class FiberData {
        final SizedQueue queue;
        volatile ThreadFiber prev;
        final RubyThread parent;
        final WeakReference<ThreadFiber> fiber;
        volatile boolean transferred;

        FiberData(SizedQueue queue, RubyThread parent, ThreadFiber fiber2) {
            this.queue = queue;
            this.parent = parent;
            this.fiber = new WeakReference<ThreadFiber>(fiber2);
        }
    }
}

