/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channel;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF16BEEncoding;
import org.jcodings.specific.UTF16LEEncoding;
import org.jruby.Ruby;
import org.jruby.util.ByteList;
import org.jruby.util.io.BadDescriptorException;
import org.jruby.util.io.ChannelDescriptor;
import org.jruby.util.io.DirectoryAsFileException;
import org.jruby.util.io.InvalidValueException;
import org.jruby.util.io.ModeFlags;
import org.jruby.util.io.PipeException;
import org.jruby.util.io.Stream;

public class CRLFStreamWrapper
implements Stream {
    private final Stream stream;
    private boolean binmode = false;
    private static final int CR = 13;
    private static final int LF = 10;
    final byte[] CRBYTES = new byte[]{13};
    final byte[] CRLEBYTES = new byte[]{13, 0};
    final byte[] CRBEBYTES = new byte[]{0, 13};
    final byte[] LFBYTES = new byte[]{10};
    final byte[] LFLEBYTES = new byte[]{10, 0};
    final byte[] LFBEBYTES = new byte[]{0, 10};

    public CRLFStreamWrapper(Stream stream) {
        this.stream = stream;
    }

    public ChannelDescriptor getDescriptor() {
        return this.stream.getDescriptor();
    }

    public void clearerr() {
        this.stream.clearerr();
    }

    public ModeFlags getModes() {
        return this.stream.getModes();
    }

    public boolean isSync() {
        return this.stream.isSync();
    }

    public void setSync(boolean sync2) {
        this.stream.setSync(sync2);
    }

    public void setBinmode() {
        this.binmode = true;
        this.stream.setBinmode();
    }

    public boolean isBinmode() {
        return this.binmode;
    }

    public boolean isAutoclose() {
        return this.stream.isAutoclose();
    }

    public void setAutoclose(boolean autoclose2) {
        this.stream.setAutoclose(autoclose2);
    }

    public ByteList fgets(ByteList separatorString) throws IOException, BadDescriptorException, EOFException {
        return this.convertCRLFToLF(this.stream.fgets(separatorString));
    }

    public ByteList readall() throws IOException, BadDescriptorException, EOFException {
        return this.convertCRLFToLF(this.stream.readall());
    }

    public int getline(ByteList dst, byte terminator) throws IOException, BadDescriptorException {
        if (this.binmode) {
            return this.stream.getline(dst, terminator);
        }
        ByteList intermediate = new ByteList();
        int result2 = this.stream.getline(intermediate, terminator);
        this.convertCRLFToLF(intermediate, dst);
        return result2;
    }

    public int getline(ByteList dst, byte terminator, long limit2) throws IOException, BadDescriptorException {
        if (this.binmode) {
            return this.stream.getline(dst, terminator, limit2);
        }
        ByteList intermediate = new ByteList();
        int result2 = this.stream.getline(intermediate, terminator, limit2);
        this.convertCRLFToLF(intermediate, dst);
        return result2;
    }

    public ByteList fread(int number) throws IOException, BadDescriptorException, EOFException {
        if (number == 0) {
            if (this.stream.feof()) {
                return null;
            }
            return new ByteList(0);
        }
        boolean eof2 = false;
        ByteList bl = new ByteList(number > 4096 ? 4096 : number);
        for (int i2 = 0; i2 < number; ++i2) {
            int c = this.fgetc();
            if (c == -1) {
                eof2 = true;
                break;
            }
            bl.append(c);
        }
        if (eof2 && bl.length() == 0) {
            return null;
        }
        return bl;
    }

    public int fwrite(ByteList string2) throws IOException, BadDescriptorException {
        return this.stream.fwrite(this.convertLFToCRLF(string2));
    }

    public int fgetc() throws IOException, BadDescriptorException, EOFException {
        int c = this.stream.fgetc();
        if (!this.binmode && c == 13 && (c = this.stream.fgetc()) != 10) {
            this.stream.ungetc(c);
            return 13;
        }
        return c;
    }

    public int ungetc(int c) {
        return this.stream.ungetc(c);
    }

    public void fputc(int c) throws IOException, BadDescriptorException {
        if (!this.binmode && c == 10) {
            this.stream.fputc(13);
        }
        this.stream.fputc(c);
    }

    public ByteList read(int number) throws IOException, BadDescriptorException, EOFException {
        return this.convertCRLFToLF(this.stream.read(number));
    }

    public void fclose() throws IOException, BadDescriptorException {
        this.stream.fclose();
    }

    public int fflush() throws IOException, BadDescriptorException {
        return this.stream.fflush();
    }

    public void sync() throws IOException, BadDescriptorException {
        this.stream.sync();
    }

    public boolean feof() throws IOException, BadDescriptorException {
        return this.stream.feof();
    }

    public long fgetpos() throws IOException, PipeException, BadDescriptorException, InvalidValueException {
        return this.stream.fgetpos();
    }

    public void lseek(long offset2, int type2) throws IOException, InvalidValueException, PipeException, BadDescriptorException {
        this.stream.lseek(offset2, type2);
    }

    public void ftruncate(long newLength) throws IOException, PipeException, InvalidValueException, BadDescriptorException {
        this.stream.ftruncate(newLength);
    }

    public int ready() throws IOException {
        return this.stream.ready();
    }

    public void waitUntilReady() throws IOException, InterruptedException {
        this.stream.waitUntilReady();
    }

    public boolean readDataBuffered() {
        return this.stream.readDataBuffered();
    }

    public boolean writeDataBuffered() {
        return this.stream.writeDataBuffered();
    }

    public InputStream newInputStream() {
        return this.stream.newInputStream();
    }

    public OutputStream newOutputStream() {
        return this.stream.newOutputStream();
    }

    public boolean isBlocking() {
        return this.stream.isBlocking();
    }

    public void setBlocking(boolean blocking) throws IOException {
        this.stream.setBlocking(blocking);
    }

    public void freopen(Ruby runtime, String path2, ModeFlags modes) throws DirectoryAsFileException, IOException, InvalidValueException, PipeException, BadDescriptorException {
        this.stream.freopen(runtime, path2, modes);
    }

    private ByteList convertCRLFToLF(ByteList input) {
        if (input == null || this.binmode) {
            return input;
        }
        ByteList result2 = new ByteList();
        this.convertCRLFToLF(input, result2);
        return result2;
    }

    private void convertCRLFToLF(ByteList src, ByteList dst) {
        for (int i2 = 0; i2 < src.length(); ++i2) {
            int b = src.get(i2);
            if (b == 13 && i2 + 1 < src.length() && src.get(i2 + 1) == 10) continue;
            dst.append(b);
        }
    }

    private byte[] crBytes(Encoding encoding2) {
        if (encoding2 == UTF16BEEncoding.INSTANCE) {
            return this.CRBEBYTES;
        }
        if (encoding2 == UTF16LEEncoding.INSTANCE) {
            return this.CRLEBYTES;
        }
        return this.CRBYTES;
    }

    private byte[] lfBytes(Encoding encoding2) {
        if (encoding2 == UTF16BEEncoding.INSTANCE) {
            return this.LFBEBYTES;
        }
        if (encoding2 == UTF16LEEncoding.INSTANCE) {
            return this.LFLEBYTES;
        }
        return this.LFBYTES;
    }

    private ByteList convertLFToCRLF(ByteList input) {
        if (input == null || this.binmode) {
            return input;
        }
        byte[] crBytes = this.crBytes(input.getEncoding());
        byte[] lfBytes = this.lfBytes(input.getEncoding());
        ByteList result2 = new ByteList();
        int length2 = input.lengthEnc();
        for (int i2 = 0; i2 < length2; ++i2) {
            int b = input.getEnc(i2);
            if (b == 10) {
                result2.append(crBytes);
                result2.append(lfBytes);
                continue;
            }
            result2.append(b);
        }
        return result2;
    }

    public Channel getChannel() {
        return this.stream.getChannel();
    }
}

