/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.cli;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.jruby.runtime.Constants;
import org.jruby.util.SafePropertyAccessor;
import org.jruby.util.cli.BooleanOption;
import org.jruby.util.cli.Category;
import org.jruby.util.cli.IntegerOption;
import org.jruby.util.cli.Option;
import org.jruby.util.cli.StringOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Options {
    private static final List<Option> _loadedOptions;
    private static final boolean INVOKEDYNAMIC_DEFAULT;
    public static final Option<String> COMPILE_MODE;
    public static final Option<Boolean> COMPILE_DUMP;
    public static final Option<Boolean> COMPILE_THREADLESS;
    public static final Option<Boolean> COMPILE_FASTOPS;
    public static final Option<Integer> COMPILE_CHAINSIZE;
    public static final Option<Boolean> COMPILE_LAZYHANDLES;
    public static final Option<Boolean> COMPILE_PEEPHOLE;
    public static final Option<Boolean> COMPILE_NOGUARDS;
    public static final Option<Boolean> COMPILE_FASTEST;
    public static final Option<Boolean> COMPILE_FASTSEND;
    public static final Option<Boolean> COMPILE_FASTMASGN;
    public static final Option<Boolean> COMPILE_INVOKEDYNAMIC;
    public static final Option<Integer> INVOKEDYNAMIC_MAXFAIL;
    public static final Option<Integer> INVOKEDYNAMIC_MAXPOLY;
    public static final Option<Boolean> INVOKEDYNAMIC_LOG_BINDING;
    public static final Option<Boolean> INVOKEDYNAMIC_LOG_CONSTANTS;
    public static final Option<Boolean> INVOKEDYNAMIC_ALL;
    public static final Option<Boolean> INVOKEDYNAMIC_SAFE;
    public static final Option<Boolean> INVOKEDYNAMIC_INVOCATION;
    public static final Option<Boolean> INVOKEDYNAMIC_INVOCATION_SWITCHPOINT;
    public static final Option<Boolean> INVOKEDYNAMIC_INVOCATION_INDIRECT;
    public static final Option<Boolean> INVOKEDYNAMIC_INVOCATION_JAVA;
    public static final Option<Boolean> INVOKEDYNAMIC_INVOCATION_ATTR;
    public static final Option<Boolean> INVOKEDYNAMIC_INVOCATION_FASTOPS;
    public static final Option<Boolean> INVOKEDYNAMIC_CACHE;
    public static final Option<Boolean> INVOKEDYNAMIC_CACHE_CONSTANTS;
    public static final Option<Boolean> INVOKEDYNAMIC_CACHE_LITERALS;
    public static final Option<Boolean> INVOKEDYNAMIC_CACHE_IVARS;
    public static final Option<Boolean> INVOKEDYNAMIC_CLASS_VALUES;
    public static final Option<Integer> JIT_THRESHOLD;
    public static final Option<Integer> JIT_MAX;
    public static final Option<Integer> JIT_MAXSIZE;
    public static final Option<Boolean> JIT_LOGGING;
    public static final Option<Boolean> JIT_LOGGING_VERBOSE;
    public static final Option<Boolean> JIT_DUMPING;
    public static final Option<Integer> JIT_LOGEVERY;
    public static final Option<String> JIT_EXCLUDE;
    public static final Option<Boolean> JIT_CACHE;
    public static final Option<String> JIT_CODECACHE;
    public static final Option<Boolean> JIT_DEBUG;
    public static final Option<Boolean> JIT_BACKGROUND;
    public static final Option<Boolean> IR_DEBUG;
    public static final Option<Boolean> IR_PROFILE;
    public static final Option<Boolean> IR_COMPILER_DEBUG;
    public static final Option<String> IR_COMPILER_PASSES;
    public static final Option<String> IR_INLINE_COMPILER_PASSES;
    public static final Option<Boolean> NATIVE_ENABLED;
    public static final Option<Boolean> NATIVE_VERBOSE;
    public static final Option<Boolean> CEXT_ENABLED;
    public static final Option<Boolean> FFI_COMPILE_DUMP;
    public static final Option<Integer> FFI_COMPILE_THRESHOLD;
    public static final Option<Boolean> FFI_COMPILE_INVOKEDYNAMIC;
    public static final Option<Boolean> THREADPOOL_ENABLED;
    public static final Option<Integer> THREADPOOL_MIN;
    public static final Option<Integer> THREADPOOL_MAX;
    public static final Option<Integer> THREADPOOL_TTL;
    public static final Option<String> COMPAT_VERSION;
    public static final Option<Boolean> OBJECTSPACE_ENABLED;
    public static final Option<Boolean> SIPHASH_ENABLED;
    public static final Option<Boolean> LAUNCH_INPROC;
    public static final Option<String> BYTECODE_VERSION;
    public static final Option<Boolean> MANAGEMENT_ENABLED;
    public static final Option<Boolean> JUMP_BACKTRACE;
    public static final Option<Boolean> PROCESS_NOUNWRAP;
    public static final Option<Boolean> REIFY_CLASSES;
    public static final Option<Boolean> REIFY_LOGERRORS;
    public static final Option<Boolean> REFLECTED_HANDLES;
    public static final Option<Boolean> BACKTRACE_COLOR;
    public static final Option<String> BACKTRACE_STYLE;
    public static final Option<Boolean> BACKTRACE_MASK;
    public static final Option<String> THREAD_DUMP_SIGNAL;
    public static final Option<Boolean> NATIVE_NET_PROTOCOL;
    public static final Option<Boolean> FIBER_COROUTINES;
    public static final Option<Boolean> GLOBAL_REQUIRE_LOCK;
    public static final Option<Boolean> NATIVE_EXEC;
    public static final Option<Boolean> DEBUG_LOADSERVICE;
    public static final Option<Boolean> DEBUG_LOADSERVICE_TIMING;
    public static final Option<Boolean> DEBUG_LAUNCH;
    public static final Option<Boolean> DEBUG_FULLTRACE;
    public static final Option<Boolean> DEBUG_SCRIPTRESOLUTION;
    public static final Option<Boolean> DEBUG_PARSER;
    public static final Option<Boolean> ERRNO_BACKTRACE;
    public static final Option<Boolean> LOG_EXCEPTIONS;
    public static final Option<Boolean> LOG_BACKTRACES;
    public static final Option<Boolean> LOG_CALLERS;
    public static final Option<Boolean> LOG_WARNINGS;
    public static final Option<String> LOGGER_CLASS;
    public static final Option<Boolean> JI_SETACCESSIBLE;
    public static final Option<Boolean> JI_LOGCANSETACCESSIBLE;
    public static final Option<Boolean> JI_UPPER_CASE_PACKAGE_NAME_ALLOWED;
    public static final Option<Boolean> INTERFACES_USEPROXY;
    public static final Option<Boolean> JAVA_HANDLES;
    public static final Option<Boolean> JI_NEWSTYLEEXTENSION;
    public static final Option<Boolean> JI_OBJECTPROXYCACHE;
    public static final Option<String> JI_PROXYCLASSFACTORY;
    public static final Option<Integer> PROFILE_MAX_METHODS;
    public static final Option[] PROPERTIES;

    public static String dump() {
        StringBuilder sb = new StringBuilder("# JRuby configuration options with current values\n");
        Category category = null;
        for (Option option : _loadedOptions) {
            if (category != option.category) {
                category = option.category;
                sb.append('\n').append(category.desc()).append('\n');
            }
            sb.append(option.name).append('=').append(option.load()).append('\n');
        }
        return sb.toString();
    }

    private static Option<String> string(Category category, String name2, String[] options2, String defval, String description) {
        StringOption option = new StringOption(category, name2, options2, defval, description);
        _loadedOptions.add(option);
        return option;
    }

    private static Option<Boolean> bool(Category category, String name2, Boolean defval, String description) {
        BooleanOption option = new BooleanOption(category, name2, defval, description);
        _loadedOptions.add(option);
        return option;
    }

    private static Option<Integer> integer(Category category, String name2, Integer defval, String description) {
        IntegerOption option = new IntegerOption(category, name2, defval, description);
        _loadedOptions.add(option);
        return option;
    }

    static {
        int version2;
        _loadedOptions = new ArrayList<Option>();
        String vmName = SafePropertyAccessor.getProperty("java.vm.name", "").toLowerCase();
        boolean isHotspot = vmName.contains("hotspot") || vmName.toLowerCase().contains("openjdk");
        String vmVersionString = SafePropertyAccessor.getProperty("java.vm.version", "");
        String javaVersion = SafePropertyAccessor.getProperty("java.specification.version", "");
        try {
            version2 = Integer.parseInt(vmVersionString.substring(0, 2));
        }
        catch (NumberFormatException nfe) {
            version2 = -1;
        }
        INVOKEDYNAMIC_DEFAULT = isHotspot ? version2 >= 24 : new BigDecimal(javaVersion).compareTo(new BigDecimal("1.7")) >= 0;
        COMPILE_MODE = Options.string(Category.COMPILER, "compile.mode", new String[]{"JIT", "FORCE", "OFF", "OFFIR"}, "JIT", "Set compilation mode. JIT = at runtime; FORCE = before execution.");
        COMPILE_DUMP = Options.bool(Category.COMPILER, "compile.dump", false, "Dump to console all bytecode generated at runtime.");
        COMPILE_THREADLESS = Options.bool(Category.COMPILER, "compile.threadless", false, "(EXPERIMENTAL) Turn on compilation without polling for \"unsafe\" thread events.");
        COMPILE_FASTOPS = Options.bool(Category.COMPILER, "compile.fastops", true, "Turn on fast operators for Fixnum and Float.");
        COMPILE_CHAINSIZE = Options.integer(Category.COMPILER, "compile.chainsize", 500, "Set the number of lines at which compiled bodies are \"chained\".");
        COMPILE_LAZYHANDLES = Options.bool(Category.COMPILER, "compile.lazyHandles", false, "Generate method bindings (handles) for compiled methods lazily.");
        COMPILE_PEEPHOLE = Options.bool(Category.COMPILER, "compile.peephole", true, "Enable or disable peephole optimizations.");
        COMPILE_NOGUARDS = Options.bool(Category.COMPILER, "compile.noguards", false, "Compile calls without guards, for experimentation.");
        COMPILE_FASTEST = Options.bool(Category.COMPILER, "compile.fastest", false, "Compile with all \"mostly harmless\" compiler optimizations.");
        COMPILE_FASTSEND = Options.bool(Category.COMPILER, "compile.fastsend", false, "Compile obj.__send__(<literal>, ...) as obj.<literal>(...).");
        COMPILE_FASTMASGN = Options.bool(Category.COMPILER, "compile.fastMasgn", false, "Return true from multiple assignment instead of a new array.");
        COMPILE_INVOKEDYNAMIC = Options.bool(Category.COMPILER, "compile.invokedynamic", INVOKEDYNAMIC_DEFAULT, "Use invokedynamic for optimizing Ruby code");
        INVOKEDYNAMIC_MAXFAIL = Options.integer(Category.INVOKEDYNAMIC, "invokedynamic.maxfail", 1000, "Maximum call site failures after which to inline cache.");
        INVOKEDYNAMIC_MAXPOLY = Options.integer(Category.INVOKEDYNAMIC, "invokedynamic.maxpoly", 2, "Maximum polymorphism of PIC binding.");
        INVOKEDYNAMIC_LOG_BINDING = Options.bool(Category.INVOKEDYNAMIC, "invokedynamic.log.binding", false, "Log binding of invokedynamic call sites.");
        INVOKEDYNAMIC_LOG_CONSTANTS = Options.bool(Category.INVOKEDYNAMIC, "invokedynamic.log.constants", false, "Log invokedynamic-based constant lookups.");
        INVOKEDYNAMIC_ALL = Options.bool(Category.INVOKEDYNAMIC, "invokedynamic.all", false, "Enable all possible uses of invokedynamic.");
        INVOKEDYNAMIC_SAFE = Options.bool(Category.INVOKEDYNAMIC, "invokedynamic.safe", false, "Enable all safe (but maybe not fast) uses of invokedynamic.");
        INVOKEDYNAMIC_INVOCATION = Options.bool(Category.INVOKEDYNAMIC, "invokedynamic.invocation", true, "Enable invokedynamic for method invocations.");
        INVOKEDYNAMIC_INVOCATION_SWITCHPOINT = Options.bool(Category.INVOKEDYNAMIC, "invokedynamic.invocation.switchpoint", true, "Use SwitchPoint for class modification guards on invocations.");
        INVOKEDYNAMIC_INVOCATION_INDIRECT = Options.bool(Category.INVOKEDYNAMIC, "invokedynamic.invocation.indirect", true, "Also bind indirect method invokers to invokedynamic.");
        INVOKEDYNAMIC_INVOCATION_JAVA = Options.bool(Category.INVOKEDYNAMIC, "invokedynamic.invocation.java", true, "Bind Ruby to Java invocations with invokedynamic.");
        INVOKEDYNAMIC_INVOCATION_ATTR = Options.bool(Category.INVOKEDYNAMIC, "invokedynamic.invocation.attr", true, "Bind Ruby attribue invocations directly to invokedynamic.");
        INVOKEDYNAMIC_INVOCATION_FASTOPS = Options.bool(Category.INVOKEDYNAMIC, "invokedynamic.invocation.fastops", true, "Bind Fixnum and Float math using optimized logic.");
        INVOKEDYNAMIC_CACHE = Options.bool(Category.INVOKEDYNAMIC, "invokedynamic.cache", true, "Use invokedynamic to load cached values like literals and constants.");
        INVOKEDYNAMIC_CACHE_CONSTANTS = Options.bool(Category.INVOKEDYNAMIC, "invokedynamic.cache.constants", true, "Use invokedynamic to load constants.");
        INVOKEDYNAMIC_CACHE_LITERALS = Options.bool(Category.INVOKEDYNAMIC, "invokedynamic.cache.literals", true, "Use invokedynamic to load literals.");
        INVOKEDYNAMIC_CACHE_IVARS = Options.bool(Category.INVOKEDYNAMIC, "invokedynamic.cache.ivars", true, "Use invokedynamic to get/set instance variables.");
        INVOKEDYNAMIC_CLASS_VALUES = Options.bool(Category.INVOKEDYNAMIC, "invokedynamic.class.values", false, "Use ClassValue to store class-specific data.");
        JIT_THRESHOLD = Options.integer(Category.JIT, "jit.threshold", 50, "Set the JIT threshold to the specified method invocation count.");
        JIT_MAX = Options.integer(Category.JIT, "jit.max", 4096, "Set the max count of active methods eligible for JIT-compilation.");
        JIT_MAXSIZE = Options.integer(Category.JIT, "jit.maxsize", 30000, "Set the maximum full-class byte size allowed for jitted methods.");
        JIT_LOGGING = Options.bool(Category.JIT, "jit.logging", false, "Enable JIT logging (reports successful compilation).");
        JIT_LOGGING_VERBOSE = Options.bool(Category.JIT, "jit.logging.verbose", false, "Enable verbose JIT logging (reports failed compilation).");
        JIT_DUMPING = Options.bool(Category.JIT, "jit.dumping", false, "Enable stdout dumping of JITed bytecode.");
        JIT_LOGEVERY = Options.integer(Category.JIT, "jit.logEvery", 0, "Log a message every n methods JIT compiled.");
        JIT_EXCLUDE = Options.string(Category.JIT, "jit.exclude", new String[]{"ClsOrMod", "ClsOrMod::method_name", "-::method_name"}, "none", "Exclude methods from JIT. Comma delimited.");
        JIT_CACHE = Options.bool(Category.JIT, "jit.cache", true, "Cache jitted method in-memory bodies across runtimes and loads.");
        JIT_CODECACHE = Options.string(Category.JIT, "jit.codeCache", new String[]{"dir"}, null, "Save jitted methods to <dir> as they're compiled, for future runs.");
        JIT_DEBUG = Options.bool(Category.JIT, "jit.debug", false, "Log loading of JITed bytecode.");
        JIT_BACKGROUND = Options.bool(Category.JIT, "jit.background", true, "Run the JIT compiler in a background thread.");
        IR_DEBUG = Options.bool(Category.IR, "ir.debug", false, "Debug generation of JRuby IR.");
        IR_PROFILE = Options.bool(Category.IR, "ir.profile", false, "[EXPT]: Profile IR code during interpretation.");
        IR_COMPILER_DEBUG = Options.bool(Category.IR, "ir.compiler.debug", false, "Debug compilation of JRuby IR.");
        IR_COMPILER_PASSES = Options.string(Category.IR, "ir.passes", null, null, "Specify comma delimeted list of passes to run.");
        IR_INLINE_COMPILER_PASSES = Options.string(Category.IR, "ir.inline_passes", null, null, "Specify comma delimeted list of passes to run after inlining a method.");
        NATIVE_ENABLED = Options.bool(Category.NATIVE, "native.enabled", true, "Enable/disable native code, including POSIX features and C exts.");
        NATIVE_VERBOSE = Options.bool(Category.NATIVE, "native.verbose", false, "Enable verbose logging of native extension loading.");
        CEXT_ENABLED = Options.bool(Category.NATIVE, "cext.enabled", false, "Enable or disable C extension support.");
        FFI_COMPILE_DUMP = Options.bool(Category.NATIVE, "ffi.compile.dump", false, "Dump bytecode-generated FFI stubs to console.");
        FFI_COMPILE_THRESHOLD = Options.integer(Category.NATIVE, "ffi.compile.threshold", 100, "Number of FFI invocations before generating a bytecode stub.");
        FFI_COMPILE_INVOKEDYNAMIC = Options.bool(Category.NATIVE, "ffi.compile.invokedynamic", false, "Use invokedynamic to bind FFI invocations.");
        THREADPOOL_ENABLED = Options.bool(Category.THREADPOOL, "thread.pool.enabled", false, "Enable reuse of native threads via a thread pool.");
        THREADPOOL_MIN = Options.integer(Category.THREADPOOL, "thread.pool.min", 0, "The minimum number of threads to keep alive in the pool.");
        THREADPOOL_MAX = Options.integer(Category.THREADPOOL, "thread.pool.max", Integer.MAX_VALUE, "The maximum number of threads to allow in the pool.");
        THREADPOOL_TTL = Options.integer(Category.THREADPOOL, "thread.pool.ttl", 60, "The maximum number of seconds to keep alive an idle thread.");
        COMPAT_VERSION = Options.string(Category.MISCELLANEOUS, "compat.version", new String[]{"1.8", "1.9", "2.0"}, Constants.DEFAULT_RUBY_VERSION, "Specify the major Ruby version to be compatible with.");
        OBJECTSPACE_ENABLED = Options.bool(Category.MISCELLANEOUS, "objectspace.enabled", false, "Enable or disable ObjectSpace.each_object.");
        SIPHASH_ENABLED = Options.bool(Category.MISCELLANEOUS, "siphash.enabled", false, "Enable or disable SipHash for String hash function.");
        LAUNCH_INPROC = Options.bool(Category.MISCELLANEOUS, "launch.inproc", false, "Set in-process launching of e.g. system('ruby ...').");
        BYTECODE_VERSION = Options.string(Category.MISCELLANEOUS, "bytecode.version", new String[]{"1.5", "1.6", "1.7"}, SafePropertyAccessor.getProperty("java.specification.version", "1.5"), "Specify the major Java bytecode version.");
        MANAGEMENT_ENABLED = Options.bool(Category.MISCELLANEOUS, "management.enabled", false, "Set whether JMX management is enabled.");
        JUMP_BACKTRACE = Options.bool(Category.MISCELLANEOUS, "jump.backtrace", false, "Make non-local flow jumps generate backtraces.");
        PROCESS_NOUNWRAP = Options.bool(Category.MISCELLANEOUS, "process.noUnwrap", false, "Do not unwrap process streams (issue on some recent JVMs).");
        REIFY_CLASSES = Options.bool(Category.MISCELLANEOUS, "reify.classes", false, "Before instantiation, stand up a real Java class for ever Ruby class.");
        REIFY_LOGERRORS = Options.bool(Category.MISCELLANEOUS, "reify.logErrors", false, "Log errors during reification (reify.classes=true).");
        REFLECTED_HANDLES = Options.bool(Category.MISCELLANEOUS, "reflected.handles", false, "Use reflection for binding methods, not generated bytecode.");
        BACKTRACE_COLOR = Options.bool(Category.MISCELLANEOUS, "backtrace.color", false, "Enable colorized backtraces.");
        BACKTRACE_STYLE = Options.string(Category.MISCELLANEOUS, "backtrace.style", new String[]{"normal", "raw", "full", "mri"}, "normal", "Set the style of exception backtraces.");
        BACKTRACE_MASK = Options.bool(Category.MISCELLANEOUS, "backtrace.mask", false, "Mask .java lines in Ruby backtraces.");
        THREAD_DUMP_SIGNAL = Options.string(Category.MISCELLANEOUS, "thread.dump.signal", new String[]{"USR1", "USR2", "etc"}, "USR2", "Set the signal used for dumping thread stacks.");
        NATIVE_NET_PROTOCOL = Options.bool(Category.MISCELLANEOUS, "native.net.protocol", false, "Use native impls for parts of net/protocol.");
        FIBER_COROUTINES = Options.bool(Category.MISCELLANEOUS, "fiber.coroutines", false, "Use JVM coroutines for Fiber.");
        GLOBAL_REQUIRE_LOCK = Options.bool(Category.MISCELLANEOUS, "global.require.lock", false, "Use a single global lock for requires.");
        NATIVE_EXEC = Options.bool(Category.MISCELLANEOUS, "native.exec", true, "Do a true process-obliterating native exec for Kernel#exec.");
        DEBUG_LOADSERVICE = Options.bool(Category.DEBUG, "debug.loadService", false, "Log require/load file searches.");
        DEBUG_LOADSERVICE_TIMING = Options.bool(Category.DEBUG, "debug.loadService.timing", false, "Log require/load parse+evaluate times.");
        DEBUG_LAUNCH = Options.bool(Category.DEBUG, "debug.launch", false, "Log externally-launched processes.");
        DEBUG_FULLTRACE = Options.bool(Category.DEBUG, "debug.fullTrace", false, "Set whether full traces are enabled (c-call/c-return).");
        DEBUG_SCRIPTRESOLUTION = Options.bool(Category.DEBUG, "debug.scriptResolution", false, "Print which script is executed by '-S' flag.");
        DEBUG_PARSER = Options.bool(Category.DEBUG, "debug.parser", false, "disables JRuby impl script loads and prints parse exceptions");
        ERRNO_BACKTRACE = Options.bool(Category.DEBUG, "errno.backtrace", false, "Generate backtraces for heavily-used Errno exceptions (EAGAIN).");
        LOG_EXCEPTIONS = Options.bool(Category.DEBUG, "log.exceptions", false, "Log every time an exception is constructed.");
        LOG_BACKTRACES = Options.bool(Category.DEBUG, "log.backtraces", false, "Log every time an exception backtrace is generated.");
        LOG_CALLERS = Options.bool(Category.DEBUG, "log.callers", false, "Log every time a Kernel#caller backtrace is generated.");
        LOG_WARNINGS = Options.bool(Category.DEBUG, "log.warnings", false, "Log every time a built-in warning backtrace is generated.");
        LOGGER_CLASS = Options.string(Category.DEBUG, "logger.class", new String[]{"class name"}, "org.jruby.util.log.JavaUtilLoggingLogger", "Use specified class for logging.");
        JI_SETACCESSIBLE = Options.bool(Category.JAVA_INTEGRATION, "ji.setAccessible", true, "Try to set inaccessible Java methods to be accessible.");
        JI_LOGCANSETACCESSIBLE = Options.bool(Category.JAVA_INTEGRATION, "ji.logCanSetAccessible", false, "Log whether setAccessible is working.");
        JI_UPPER_CASE_PACKAGE_NAME_ALLOWED = Options.bool(Category.JAVA_INTEGRATION, "ji.upper.case.package.name.allowed", false, "Allow Capitalized Java pacakge names.");
        INTERFACES_USEPROXY = Options.bool(Category.JAVA_INTEGRATION, "interfaces.useProxy", false, "Use java.lang.reflect.Proxy for interface impl.");
        JAVA_HANDLES = Options.bool(Category.JAVA_INTEGRATION, "java.handles", false, "Use generated handles instead of reflection for calling Java.");
        JI_NEWSTYLEEXTENSION = Options.bool(Category.JAVA_INTEGRATION, "ji.newStyleExtension", false, "Extend Java classes without using a proxy object.");
        JI_OBJECTPROXYCACHE = Options.bool(Category.JAVA_INTEGRATION, "ji.objectProxyCache", true, "Cache Java object wrappers between calls.");
        JI_PROXYCLASSFACTORY = Options.string(Category.JAVA_INTEGRATION, "ji.proxyClassFactory", null, null, "Allow external envs to replace JI proxy class factory");
        PROFILE_MAX_METHODS = Options.integer(Category.PROFILING, "profile.max.methods", 100000, "Maximum number of methods to consider for profiling.");
        PROPERTIES = _loadedOptions.toArray(new Option[0]);
    }
}

