/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.profile;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.Comparator;
import org.jruby.runtime.profile.Invocation;
import org.jruby.runtime.profile.MethodData;
import org.jruby.runtime.profile.ProfileData;
import org.jruby.runtime.profile.ProfilePrinter;
import org.jruby.util.collections.IntHashMap;

public class FlatProfilePrinter
extends ProfilePrinter {
    private static final int SERIAL_OFFSET = 0;
    private static final int SELFTIME_OFFSET = 1;
    private static final int COUNT_OFFSET = 2;
    private static final int AGGREGATETIME_OFFSET = 3;

    public FlatProfilePrinter(ProfileData profileData) {
        super(profileData);
    }

    FlatProfilePrinter(ProfileData profileData, Invocation topInvocation) {
        super(profileData, topInvocation);
    }

    public void printHeader(PrintStream out) {
        out.printf("\n%s profile results:\n", this.getThreadName());
    }

    public void printProfile(PrintStream out, boolean first2) {
        Invocation topInvocation = this.getTopInvocation();
        out.printf("Total time: %s\n\n", FlatProfilePrinter.nanoString(topInvocation.getDuration()));
        IntHashMap<MethodData> methods2 = FlatProfilePrinter.methodData(topInvocation);
        long[][] tuples = new long[methods2.size()][];
        int j = 0;
        for (IntHashMap.Entry<MethodData> entry : methods2.entrySet()) {
            MethodData method2 = entry.getValue();
            tuples[j++] = new long[]{entry.getKey(), method2.selfTime(), method2.totalCalls(), method2.totalTime()};
        }
        Arrays.sort(tuples, new Comparator<long[]>(){

            @Override
            public int compare(long[] o1, long[] o2) {
                long o2Val = o2[3];
                long o1Val = o1[3];
                return o2Val > o1Val ? 1 : (o2Val < o1Val ? -1 : 0);
            }
        });
        out.println("     total        self    children       calls  method");
        out.println("----------------------------------------------------------------");
        int lines2 = 0;
        for (long[] tuple : tuples) {
            if (tuple[3] == 0L) break;
            int index2 = (int)tuple[0];
            if (index2 != 0) {
                ++lines2;
                String name2 = this.methodName(index2);
                FlatProfilePrinter.pad(out, 10, FlatProfilePrinter.nanoString(tuple[3]));
                out.print("  ");
                FlatProfilePrinter.pad(out, 10, FlatProfilePrinter.nanoString(tuple[1]));
                out.print("  ");
                FlatProfilePrinter.pad(out, 10, FlatProfilePrinter.nanoString(tuple[3] - tuple[1]));
                out.print("  ");
                FlatProfilePrinter.pad(out, 10, Long.toString(tuple[2]));
                out.print("  ");
                out.println(name2);
            }
            if (lines2 == 50) break;
        }
    }
}

