/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.parser;

import java.util.ArrayList;
import java.util.List;
import org.jcodings.Encoding;
import org.jcodings.specific.EUCJPEncoding;
import org.jcodings.specific.SJISEncoding;
import org.jruby.RubyRegexp;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.AssignableNode;
import org.jruby.ast.BlockPassNode;
import org.jruby.ast.ClassVarAsgnNode;
import org.jruby.ast.ConstDeclNode;
import org.jruby.ast.DRegexpNode;
import org.jruby.ast.DStrNode;
import org.jruby.ast.GlobalAsgnNode;
import org.jruby.ast.InstAsgnNode;
import org.jruby.ast.Match2CaptureNode;
import org.jruby.ast.Match2Node;
import org.jruby.ast.Match3Node;
import org.jruby.ast.Node;
import org.jruby.ast.RegexpNode;
import org.jruby.ast.SValue19Node;
import org.jruby.ast.SValueNode;
import org.jruby.ast.Splat19Node;
import org.jruby.ast.SplatNode;
import org.jruby.ast.Yield19Node;
import org.jruby.ast.YieldOneNode;
import org.jruby.ast.YieldThreeNode;
import org.jruby.ast.YieldTwoNode;
import org.jruby.ast.ZYieldNode;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.lexer.yacc.RubyYaccLexer;
import org.jruby.lexer.yacc.SyntaxException;
import org.jruby.lexer.yacc.Token;
import org.jruby.parser.ParserSupport;
import org.jruby.parser.StaticScope;
import org.jruby.util.ByteList;
import org.jruby.util.RegexpOptions;
import org.jruby.util.StringSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParserSupport19
extends ParserSupport {
    @Override
    public AssignableNode assignable(Token lhs, Node value2) {
        this.checkExpression(value2);
        switch (lhs.getType()) {
            case 286: {
                throw new SyntaxException(SyntaxException.PID.CANNOT_CHANGE_SELF, lhs.getPosition(), this.lexer.getCurrentLine(), "Can't change the value of self", new Object[0]);
            }
            case 287: {
                throw new SyntaxException(SyntaxException.PID.INVALID_ASSIGNMENT, lhs.getPosition(), this.lexer.getCurrentLine(), "Can't assign to nil", "nil");
            }
            case 288: {
                throw new SyntaxException(SyntaxException.PID.INVALID_ASSIGNMENT, lhs.getPosition(), this.lexer.getCurrentLine(), "Can't assign to true", "true");
            }
            case 289: {
                throw new SyntaxException(SyntaxException.PID.INVALID_ASSIGNMENT, lhs.getPosition(), this.lexer.getCurrentLine(), "Can't assign to false", "false");
            }
            case 303: {
                throw new SyntaxException(SyntaxException.PID.INVALID_ASSIGNMENT, lhs.getPosition(), this.lexer.getCurrentLine(), "Can't assign to __FILE__", "__FILE__");
            }
            case 302: {
                throw new SyntaxException(SyntaxException.PID.INVALID_ASSIGNMENT, lhs.getPosition(), this.lexer.getCurrentLine(), "Can't assign to __LINE__", "__LINE__");
            }
            case 304: {
                throw new SyntaxException(SyntaxException.PID.INVALID_ASSIGNMENT, lhs.getPosition(), this.lexer.getCurrentLine(), "Can't assign to __ENCODING__", "__ENCODING__");
            }
            case 306: 
            case 312: {
                return this.currentScope.assign(lhs.getPosition(), (String)lhs.getValue(), this.makeNullNil(value2));
            }
            case 310: {
                if (this.isInDef() || this.isInSingle()) {
                    throw new SyntaxException(SyntaxException.PID.DYNAMIC_CONSTANT_ASSIGNMENT, lhs.getPosition(), this.lexer.getCurrentLine(), "dynamic constant assignment", new Object[0]);
                }
                return new ConstDeclNode(lhs.getPosition(), (String)lhs.getValue(), null, value2);
            }
            case 309: {
                return new InstAsgnNode(lhs.getPosition(), (String)lhs.getValue(), value2);
            }
            case 311: {
                return new ClassVarAsgnNode(lhs.getPosition(), (String)lhs.getValue(), value2);
            }
            case 308: {
                return new GlobalAsgnNode(lhs.getPosition(), (String)lhs.getValue(), value2);
            }
        }
        throw new SyntaxException(SyntaxException.PID.BAD_IDENTIFIER, lhs.getPosition(), this.lexer.getCurrentLine(), "identifier " + (String)lhs.getValue() + " is not valid to set", lhs.getValue());
    }

    @Override
    public DStrNode createDStrNode(ISourcePosition position) {
        return new DStrNode(position, this.lexer.getEncoding());
    }

    @Override
    protected void getterIdentifierError(ISourcePosition position, String identifier) {
        throw new SyntaxException(SyntaxException.PID.BAD_IDENTIFIER, position, "identifier " + identifier + " is not valid to get", identifier, new Object[0]);
    }

    @Override
    public SplatNode newSplatNode(ISourcePosition position, Node node) {
        return new Splat19Node(position, this.makeNullNil(node));
    }

    @Override
    public SValueNode newSValueNode(ISourcePosition position, Node node) {
        return new SValue19Node(position, node);
    }

    private List<Integer> allocateNamedLocals(RegexpNode regexpNode) {
        String[] names2 = regexpNode.loadPattern(this.configuration.getRuntime()).getNames();
        int length2 = names2.length;
        ArrayList<Integer> locals = new ArrayList<Integer>();
        StaticScope scope = this.getCurrentScope();
        for (int i2 = 0; i2 < length2; ++i2) {
            if (RubyYaccLexer.getKeyword(names2[i2]) != null) continue;
            int slot = scope.isDefined(names2[i2]);
            if (slot >= 0) {
                locals.add(slot);
                continue;
            }
            locals.add(this.getCurrentScope().addVariableThisScope(names2[i2]));
        }
        return locals;
    }

    private boolean is7BitASCII(ByteList value2) {
        return StringSupport.codeRangeScan(value2.getEncoding(), value2) == 32;
    }

    public void setRegexpEncoding(RegexpNode end2, ByteList value2) {
        RegexpOptions options2 = end2.getOptions();
        Encoding optionsEncoding = options2.setup19(this.configuration.getRuntime());
        if (optionsEncoding != null) {
            if (optionsEncoding != value2.getEncoding() && !this.is7BitASCII(value2)) {
                this.compileError(optionsEncoding, value2.getEncoding());
            }
            value2.setEncoding(optionsEncoding);
        } else if (options2.isEncodingNone()) {
            if (value2.getEncoding() == RubyYaccLexer.ASCII8BIT_ENCODING && !this.is7BitASCII(value2)) {
                this.compileError(optionsEncoding, value2.getEncoding());
            }
            value2.setEncoding(RubyYaccLexer.ASCII8BIT_ENCODING);
        } else if (this.lexer.getEncoding() == RubyYaccLexer.USASCII_ENCODING) {
            if (!this.is7BitASCII(value2)) {
                value2.setEncoding(RubyYaccLexer.USASCII_ENCODING);
            } else {
                value2.setEncoding(RubyYaccLexer.ASCII8BIT_ENCODING);
            }
        }
    }

    private char optionsEncodingChar(Encoding optionEncoding) {
        if (optionEncoding == RubyYaccLexer.USASCII_ENCODING) {
            return 'n';
        }
        if (optionEncoding == EUCJPEncoding.INSTANCE) {
            return 'e';
        }
        if (optionEncoding == SJISEncoding.INSTANCE) {
            return 's';
        }
        if (optionEncoding == RubyYaccLexer.UTF8_ENCODING) {
            return 'u';
        }
        return ' ';
    }

    protected void compileError(Encoding optionEncoding, Encoding encoding2) {
        throw new SyntaxException(SyntaxException.PID.REGEXP_ENCODING_MISMATCH, this.lexer.getPosition(), this.lexer.getCurrentLine(), "regexp encoding option '" + this.optionsEncodingChar(optionEncoding) + "' differs from source encoding '" + encoding2 + "'", new Object[0]);
    }

    @Override
    public void regexpFragmentCheck(RegexpNode end2, ByteList value2) {
        this.setRegexpEncoding(end2, value2);
        RubyRegexp.preprocessCheck(this.configuration.getRuntime(), value2);
    }

    @Override
    public Node getMatchNode(Node firstNode, Node secondNode) {
        if (firstNode instanceof DRegexpNode) {
            return new Match2Node(firstNode.getPosition(), firstNode, secondNode);
        }
        if (firstNode instanceof RegexpNode) {
            List<Integer> locals = this.allocateNamedLocals((RegexpNode)firstNode);
            if (locals.size() > 0) {
                int[] primitiveLocals = new int[locals.size()];
                for (int i2 = 0; i2 < primitiveLocals.length; ++i2) {
                    primitiveLocals[i2] = locals.get(i2);
                }
                return new Match2CaptureNode(firstNode.getPosition(), firstNode, secondNode, primitiveLocals);
            }
            return new Match2Node(firstNode.getPosition(), firstNode, secondNode);
        }
        if (secondNode instanceof DRegexpNode || secondNode instanceof RegexpNode) {
            return new Match3Node(firstNode.getPosition(), secondNode, firstNode);
        }
        return this.getOperatorCallNode(firstNode, "=~", secondNode);
    }

    @Override
    public Node new_yield(ISourcePosition position, Node node) {
        if (node != null && node instanceof BlockPassNode) {
            throw new SyntaxException(SyntaxException.PID.BLOCK_ARG_UNEXPECTED, node.getPosition(), this.lexer.getCurrentLine(), "Block argument should not be given.", new Object[0]);
        }
        if (node instanceof ArrayNode) {
            ArrayNode args2 = (ArrayNode)node;
            switch (args2.size()) {
                case 0: {
                    return new ZYieldNode(position);
                }
                case 1: {
                    return new YieldOneNode(position, args2);
                }
                case 2: {
                    return new YieldTwoNode(position, args2);
                }
                case 3: {
                    return new YieldThreeNode(position, args2);
                }
            }
        }
        return new Yield19Node(position, node);
    }
}

