/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.bouncycastle.x509;

import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.util.Date;
import java.util.Iterator;
import org.jruby.org.bouncycastle.asn1.ASN1Encodable;
import org.jruby.org.bouncycastle.asn1.ASN1EncodableVector;
import org.jruby.org.bouncycastle.asn1.DERBitString;
import org.jruby.org.bouncycastle.asn1.DERGeneralizedTime;
import org.jruby.org.bouncycastle.asn1.DERInteger;
import org.jruby.org.bouncycastle.asn1.DERObjectIdentifier;
import org.jruby.org.bouncycastle.asn1.DERSequence;
import org.jruby.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.jruby.org.bouncycastle.asn1.x509.AttCertIssuer;
import org.jruby.org.bouncycastle.asn1.x509.Attribute;
import org.jruby.org.bouncycastle.asn1.x509.AttributeCertificate;
import org.jruby.org.bouncycastle.asn1.x509.AttributeCertificateInfo;
import org.jruby.org.bouncycastle.asn1.x509.V2AttributeCertificateInfoGenerator;
import org.jruby.org.bouncycastle.asn1.x509.X509ExtensionsGenerator;
import org.jruby.org.bouncycastle.x509.AttributeCertificateHolder;
import org.jruby.org.bouncycastle.x509.AttributeCertificateIssuer;
import org.jruby.org.bouncycastle.x509.ExtCertificateEncodingException;
import org.jruby.org.bouncycastle.x509.X509Attribute;
import org.jruby.org.bouncycastle.x509.X509AttributeCertificate;
import org.jruby.org.bouncycastle.x509.X509Util;
import org.jruby.org.bouncycastle.x509.X509V2AttributeCertificate;

public class X509V2AttributeCertificateGenerator {
    private V2AttributeCertificateInfoGenerator acInfoGen = new V2AttributeCertificateInfoGenerator();
    private DERObjectIdentifier sigOID;
    private AlgorithmIdentifier sigAlgId;
    private String signatureAlgorithm;
    private X509ExtensionsGenerator extGenerator = new X509ExtensionsGenerator();

    public void reset() {
        this.acInfoGen = new V2AttributeCertificateInfoGenerator();
        this.extGenerator.reset();
    }

    public void setHolder(AttributeCertificateHolder attributeCertificateHolder) {
        this.acInfoGen.setHolder(attributeCertificateHolder.holder);
    }

    public void setIssuer(AttributeCertificateIssuer attributeCertificateIssuer) {
        this.acInfoGen.setIssuer(AttCertIssuer.getInstance(attributeCertificateIssuer.form));
    }

    public void setSerialNumber(BigInteger bigInteger) {
        this.acInfoGen.setSerialNumber(new DERInteger(bigInteger));
    }

    public void setNotBefore(Date date) {
        this.acInfoGen.setStartDate(new DERGeneralizedTime(date));
    }

    public void setNotAfter(Date date) {
        this.acInfoGen.setEndDate(new DERGeneralizedTime(date));
    }

    public void setSignatureAlgorithm(String string2) {
        this.signatureAlgorithm = string2;
        try {
            this.sigOID = X509Util.getAlgorithmOID(string2);
        }
        catch (Exception exception2) {
            throw new IllegalArgumentException("Unknown signature type requested");
        }
        this.sigAlgId = X509Util.getSigAlgID(this.sigOID, string2);
        this.acInfoGen.setSignature(this.sigAlgId);
    }

    public void addAttribute(X509Attribute x509Attribute) {
        this.acInfoGen.addAttribute(Attribute.getInstance(x509Attribute.toASN1Object()));
    }

    public void setIssuerUniqueId(boolean[] blArray) {
        throw new RuntimeException("not implemented (yet)");
    }

    public void addExtension(String string2, boolean bl, ASN1Encodable aSN1Encodable) throws IOException {
        this.extGenerator.addExtension(new DERObjectIdentifier(string2), bl, aSN1Encodable);
    }

    public void addExtension(String string2, boolean bl, byte[] byArray) {
        this.extGenerator.addExtension(new DERObjectIdentifier(string2), bl, byArray);
    }

    public X509AttributeCertificate generateCertificate(PrivateKey privateKey, String string2) throws NoSuchProviderException, SecurityException, SignatureException, InvalidKeyException {
        return this.generateCertificate(privateKey, string2, null);
    }

    public X509AttributeCertificate generateCertificate(PrivateKey privateKey, String string2, SecureRandom secureRandom) throws NoSuchProviderException, SecurityException, SignatureException, InvalidKeyException {
        try {
            return this.generate(privateKey, string2, secureRandom);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw noSuchProviderException;
        }
        catch (SignatureException signatureException) {
            throw signatureException;
        }
        catch (InvalidKeyException invalidKeyException) {
            throw invalidKeyException;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new SecurityException("exception creating certificate: " + generalSecurityException);
        }
    }

    public X509AttributeCertificate generate(PrivateKey privateKey, String string2) throws CertificateEncodingException, IllegalStateException, NoSuchProviderException, SignatureException, InvalidKeyException, NoSuchAlgorithmException {
        return this.generate(privateKey, string2, null);
    }

    public X509AttributeCertificate generate(PrivateKey privateKey, String string2, SecureRandom secureRandom) throws CertificateEncodingException, IllegalStateException, NoSuchProviderException, NoSuchAlgorithmException, SignatureException, InvalidKeyException {
        if (!this.extGenerator.isEmpty()) {
            this.acInfoGen.setExtensions(this.extGenerator.generate());
        }
        AttributeCertificateInfo attributeCertificateInfo = this.acInfoGen.generateAttributeCertificateInfo();
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(attributeCertificateInfo);
        aSN1EncodableVector.add(this.sigAlgId);
        try {
            aSN1EncodableVector.add(new DERBitString(X509Util.calculateSignature(this.sigOID, this.signatureAlgorithm, string2, privateKey, secureRandom, attributeCertificateInfo)));
            return new X509V2AttributeCertificate(new AttributeCertificate(new DERSequence(aSN1EncodableVector)));
        }
        catch (IOException iOException) {
            throw new ExtCertificateEncodingException("constructed invalid certificate", iOException);
        }
    }

    public Iterator getSignatureAlgNames() {
        return X509Util.getAlgNames();
    }
}

