/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.bouncycastle.util;

public final class Arrays {
    private Arrays() {
    }

    public static boolean areEqual(boolean[] blArray, boolean[] blArray2) {
        if (blArray == blArray2) {
            return true;
        }
        if (blArray == null || blArray2 == null) {
            return false;
        }
        if (blArray.length != blArray2.length) {
            return false;
        }
        for (int j = 0; j != blArray.length; ++j) {
            if (blArray[j] == blArray2[j]) continue;
            return false;
        }
        return true;
    }

    public static boolean areEqual(char[] cArray, char[] cArray2) {
        if (cArray == cArray2) {
            return true;
        }
        if (cArray == null || cArray2 == null) {
            return false;
        }
        if (cArray.length != cArray2.length) {
            return false;
        }
        for (int j = 0; j != cArray.length; ++j) {
            if (cArray[j] == cArray2[j]) continue;
            return false;
        }
        return true;
    }

    public static boolean areEqual(byte[] byArray, byte[] byArray2) {
        if (byArray == byArray2) {
            return true;
        }
        if (byArray == null || byArray2 == null) {
            return false;
        }
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int j = 0; j != byArray.length; ++j) {
            if (byArray[j] == byArray2[j]) continue;
            return false;
        }
        return true;
    }

    public static boolean constantTimeAreEqual(byte[] byArray, byte[] byArray2) {
        if (byArray == byArray2) {
            return true;
        }
        if (byArray == null || byArray2 == null) {
            return false;
        }
        if (byArray.length != byArray2.length) {
            return false;
        }
        int n = 0;
        for (int j = 0; j != byArray.length; ++j) {
            n |= byArray[j] ^ byArray2[j];
        }
        return n == 0;
    }

    public static boolean areEqual(int[] nArray, int[] nArray2) {
        if (nArray == nArray2) {
            return true;
        }
        if (nArray == null || nArray2 == null) {
            return false;
        }
        if (nArray.length != nArray2.length) {
            return false;
        }
        for (int j = 0; j != nArray.length; ++j) {
            if (nArray[j] == nArray2[j]) continue;
            return false;
        }
        return true;
    }

    public static void fill(byte[] byArray, byte by) {
        for (int j = 0; j < byArray.length; ++j) {
            byArray[j] = by;
        }
    }

    public static void fill(long[] lArray, long l) {
        for (int j = 0; j < lArray.length; ++j) {
            lArray[j] = l;
        }
    }

    public static void fill(short[] sArray, short s2) {
        for (int j = 0; j < sArray.length; ++j) {
            sArray[j] = s2;
        }
    }

    public static int hashCode(byte[] byArray) {
        if (byArray == null) {
            return 0;
        }
        int n = byArray.length;
        int n2 = n + 1;
        while (--n >= 0) {
            n2 *= 257;
            n2 ^= byArray[n];
        }
        return n2;
    }

    public static byte[] clone(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        return byArray2;
    }

    public static int[] clone(int[] nArray) {
        if (nArray == null) {
            return null;
        }
        int[] nArray2 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        return nArray2;
    }
}

