/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.bouncycastle.pkcs;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.jruby.org.bouncycastle.asn1.pkcs.EncryptedPrivateKeyInfo;
import org.jruby.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.jruby.org.bouncycastle.operator.OutputEncryptor;
import org.jruby.org.bouncycastle.pkcs.EncryptedPrivateKeyInfoHolder;

public class EncryptedPrivateKeyInfoBuilder {
    private PrivateKeyInfo privateKeyInfo;

    public EncryptedPrivateKeyInfoBuilder(PrivateKeyInfo privateKeyInfo) {
        this.privateKeyInfo = privateKeyInfo;
    }

    public EncryptedPrivateKeyInfoHolder build(OutputEncryptor outputEncryptor) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            OutputStream outputStream = outputEncryptor.getOutputStream(byteArrayOutputStream);
            outputStream.write(this.privateKeyInfo.getEncoded());
            outputStream.close();
            return new EncryptedPrivateKeyInfoHolder(new EncryptedPrivateKeyInfo(outputEncryptor.getAlgorithmIdentifier(), byteArrayOutputStream.toByteArray()));
        }
        catch (IOException iOException) {
            throw new IllegalStateException("cannot encode privateKeyInfo");
        }
    }
}

