/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.bouncycastle.operator.jcajce;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Signature;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import org.jruby.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.jruby.org.bouncycastle.asn1.DEREncodable;
import org.jruby.org.bouncycastle.asn1.DERNull;
import org.jruby.org.bouncycastle.asn1.DERObjectIdentifier;
import org.jruby.org.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import org.jruby.org.bouncycastle.asn1.kisa.KISAObjectIdentifiers;
import org.jruby.org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.jruby.org.bouncycastle.asn1.ntt.NTTObjectIdentifiers;
import org.jruby.org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.jruby.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.jruby.org.bouncycastle.asn1.pkcs.RSASSAPSSparams;
import org.jruby.org.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import org.jruby.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.jruby.org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.jruby.org.bouncycastle.cert.X509CertificateHolder;
import org.jruby.org.bouncycastle.jcajce.JcaJceHelper;
import org.jruby.org.bouncycastle.operator.OperatorCreationException;

class OperatorHelper {
    private static final Map oids = new HashMap();
    private static final Map asymmetricWrapperAlgNames = new HashMap();
    private static final Map symmetricWrapperAlgNames = new HashMap();
    private JcaJceHelper helper;

    OperatorHelper(JcaJceHelper jcaJceHelper) {
        this.helper = jcaJceHelper;
    }

    Cipher createAsymmetricWrapper(ASN1ObjectIdentifier aSN1ObjectIdentifier) throws OperatorCreationException {
        try {
            String string2 = (String)asymmetricWrapperAlgNames.get(aSN1ObjectIdentifier);
            if (string2 != null) {
                try {
                    return this.helper.createCipher(string2);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    // empty catch block
                }
            }
            return this.helper.createCipher(aSN1ObjectIdentifier.getId());
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new OperatorCreationException("cannot create cipher: " + generalSecurityException.getMessage(), generalSecurityException);
        }
    }

    Cipher createSymmetricWrapper(ASN1ObjectIdentifier aSN1ObjectIdentifier) throws OperatorCreationException {
        try {
            String string2 = (String)symmetricWrapperAlgNames.get(aSN1ObjectIdentifier);
            if (string2 != null) {
                try {
                    return this.helper.createCipher(string2);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    // empty catch block
                }
            }
            return this.helper.createCipher(aSN1ObjectIdentifier.getId());
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new OperatorCreationException("cannot create cipher: " + generalSecurityException.getMessage(), generalSecurityException);
        }
    }

    MessageDigest createDigest(AlgorithmIdentifier algorithmIdentifier) throws GeneralSecurityException {
        MessageDigest messageDigest;
        try {
            messageDigest = this.helper.createDigest(OperatorHelper.getSignatureName(algorithmIdentifier));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            if (oids.get(algorithmIdentifier.getAlgorithm()) != null) {
                String string2 = (String)oids.get(algorithmIdentifier.getAlgorithm());
                messageDigest = this.helper.createDigest(string2);
            }
            throw noSuchAlgorithmException;
        }
        return messageDigest;
    }

    Signature createSignature(AlgorithmIdentifier algorithmIdentifier) throws GeneralSecurityException {
        Signature signature;
        try {
            signature = this.helper.createSignature(OperatorHelper.getSignatureName(algorithmIdentifier));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            if (oids.get(algorithmIdentifier.getAlgorithm()) != null) {
                String string2 = (String)oids.get(algorithmIdentifier.getAlgorithm());
                signature = this.helper.createSignature(string2);
            }
            throw noSuchAlgorithmException;
        }
        return signature;
    }

    public Signature createRawSignature(AlgorithmIdentifier algorithmIdentifier) {
        Signature signature;
        try {
            String string2 = OperatorHelper.getSignatureName(algorithmIdentifier);
            string2 = "NONE" + string2.substring(string2.indexOf("WITH"));
            signature = this.helper.createSignature(string2);
        }
        catch (Exception exception2) {
            return null;
        }
        return signature;
    }

    private static String getSignatureName(AlgorithmIdentifier algorithmIdentifier) {
        DEREncodable dEREncodable = algorithmIdentifier.getParameters();
        if (dEREncodable != null && !DERNull.INSTANCE.equals(dEREncodable) && algorithmIdentifier.getAlgorithm().equals(PKCSObjectIdentifiers.id_RSASSA_PSS)) {
            RSASSAPSSparams rSASSAPSSparams = RSASSAPSSparams.getInstance(dEREncodable);
            return OperatorHelper.getDigestAlgName(rSASSAPSSparams.getHashAlgorithm().getAlgorithm()) + "withRSAandMGF1";
        }
        if (oids.containsKey(algorithmIdentifier.getAlgorithm())) {
            return (String)oids.get(algorithmIdentifier.getAlgorithm());
        }
        return algorithmIdentifier.getAlgorithm().getId();
    }

    private static String getDigestAlgName(DERObjectIdentifier dERObjectIdentifier) {
        if (PKCSObjectIdentifiers.md5.equals(dERObjectIdentifier)) {
            return "MD5";
        }
        if (OIWObjectIdentifiers.idSHA1.equals(dERObjectIdentifier)) {
            return "SHA1";
        }
        if (NISTObjectIdentifiers.id_sha224.equals(dERObjectIdentifier)) {
            return "SHA224";
        }
        if (NISTObjectIdentifiers.id_sha256.equals(dERObjectIdentifier)) {
            return "SHA256";
        }
        if (NISTObjectIdentifiers.id_sha384.equals(dERObjectIdentifier)) {
            return "SHA384";
        }
        if (NISTObjectIdentifiers.id_sha512.equals(dERObjectIdentifier)) {
            return "SHA512";
        }
        if (TeleTrusTObjectIdentifiers.ripemd128.equals(dERObjectIdentifier)) {
            return "RIPEMD128";
        }
        if (TeleTrusTObjectIdentifiers.ripemd160.equals(dERObjectIdentifier)) {
            return "RIPEMD160";
        }
        if (TeleTrusTObjectIdentifiers.ripemd256.equals(dERObjectIdentifier)) {
            return "RIPEMD256";
        }
        if (CryptoProObjectIdentifiers.gostR3411.equals(dERObjectIdentifier)) {
            return "GOST3411";
        }
        return dERObjectIdentifier.getId();
    }

    public X509Certificate convertCertificate(X509CertificateHolder x509CertificateHolder) throws CertificateException {
        try {
            CertificateFactory certificateFactory = this.helper.createCertificateFactory("X.509");
            return (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(x509CertificateHolder.getEncoded()));
        }
        catch (IOException iOException) {
            throw new OpCertificateException("cannot get encoded form of certificate: " + iOException.getMessage(), iOException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new OpCertificateException("cannot create certificate factory: " + noSuchAlgorithmException.getMessage(), noSuchAlgorithmException);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new OpCertificateException("cannot find factory provider: " + noSuchProviderException.getMessage(), noSuchProviderException);
        }
    }

    static {
        oids.put(new DERObjectIdentifier("1.2.840.113549.1.1.5"), "SHA1WITHRSA");
        oids.put(PKCSObjectIdentifiers.sha224WithRSAEncryption, "SHA224WITHRSA");
        oids.put(PKCSObjectIdentifiers.sha256WithRSAEncryption, "SHA256WITHRSA");
        oids.put(PKCSObjectIdentifiers.sha384WithRSAEncryption, "SHA384WITHRSA");
        oids.put(PKCSObjectIdentifiers.sha512WithRSAEncryption, "SHA512WITHRSA");
        oids.put(CryptoProObjectIdentifiers.gostR3411_94_with_gostR3410_94, "GOST3411WITHGOST3410");
        oids.put(CryptoProObjectIdentifiers.gostR3411_94_with_gostR3410_2001, "GOST3411WITHECGOST3410");
        oids.put(new DERObjectIdentifier("1.2.840.113549.1.1.4"), "MD5WITHRSA");
        oids.put(new DERObjectIdentifier("1.2.840.113549.1.1.2"), "MD2WITHRSA");
        oids.put(new DERObjectIdentifier("1.2.840.10040.4.3"), "SHA1WITHDSA");
        oids.put(X9ObjectIdentifiers.ecdsa_with_SHA1, "SHA1WITHECDSA");
        oids.put(X9ObjectIdentifiers.ecdsa_with_SHA224, "SHA224WITHECDSA");
        oids.put(X9ObjectIdentifiers.ecdsa_with_SHA256, "SHA256WITHECDSA");
        oids.put(X9ObjectIdentifiers.ecdsa_with_SHA384, "SHA384WITHECDSA");
        oids.put(X9ObjectIdentifiers.ecdsa_with_SHA512, "SHA512WITHECDSA");
        oids.put(OIWObjectIdentifiers.sha1WithRSA, "SHA1WITHRSA");
        oids.put(OIWObjectIdentifiers.dsaWithSHA1, "SHA1WITHDSA");
        oids.put(NISTObjectIdentifiers.dsa_with_sha224, "SHA224WITHDSA");
        oids.put(NISTObjectIdentifiers.dsa_with_sha256, "SHA256WITHDSA");
        asymmetricWrapperAlgNames.put(new ASN1ObjectIdentifier(PKCSObjectIdentifiers.rsaEncryption.getId()), "RSA/ECB/PKCS1Padding");
        symmetricWrapperAlgNames.put(PKCSObjectIdentifiers.id_alg_CMS3DESwrap, "DESEDEWrap");
        symmetricWrapperAlgNames.put(NISTObjectIdentifiers.id_aes128_wrap, "AESWrap");
        symmetricWrapperAlgNames.put(NISTObjectIdentifiers.id_aes192_wrap, "AESWrap");
        symmetricWrapperAlgNames.put(NISTObjectIdentifiers.id_aes256_wrap, "AESWrap");
        symmetricWrapperAlgNames.put(NTTObjectIdentifiers.id_camellia128_wrap, "CamilliaWrap");
        symmetricWrapperAlgNames.put(NTTObjectIdentifiers.id_camellia192_wrap, "CamilliaWrap");
        symmetricWrapperAlgNames.put(NTTObjectIdentifiers.id_camellia256_wrap, "CamilliaWrap");
        symmetricWrapperAlgNames.put(KISAObjectIdentifiers.id_npki_app_cmsSeed_wrap, "SEEDWrap");
    }

    private static class OpCertificateException
    extends CertificateException {
        private Throwable cause;

        public OpCertificateException(String string2, Throwable throwable) {
            super(string2);
            this.cause = throwable;
        }

        public Throwable getCause() {
            return this.cause;
        }
    }
}

