/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.bouncycastle.operator.bc;

import java.io.IOException;
import org.jruby.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.jruby.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.jruby.org.bouncycastle.crypto.Digest;
import org.jruby.org.bouncycastle.crypto.Signer;
import org.jruby.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.jruby.org.bouncycastle.crypto.signers.RSADigestSigner;
import org.jruby.org.bouncycastle.crypto.util.PublicKeyFactory;
import org.jruby.org.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import org.jruby.org.bouncycastle.operator.OperatorCreationException;
import org.jruby.org.bouncycastle.operator.bc.BcContentVerifierProviderBuilder;
import org.jruby.org.bouncycastle.operator.bc.BcUtil;

public class BcRSAContentVerifierProviderBuilder
extends BcContentVerifierProviderBuilder {
    private DigestAlgorithmIdentifierFinder digestAlgorithmFinder;

    public BcRSAContentVerifierProviderBuilder(DigestAlgorithmIdentifierFinder digestAlgorithmIdentifierFinder) {
        this.digestAlgorithmFinder = digestAlgorithmIdentifierFinder;
    }

    protected Signer createSigner(AlgorithmIdentifier algorithmIdentifier) throws OperatorCreationException {
        AlgorithmIdentifier algorithmIdentifier2 = this.digestAlgorithmFinder.find(algorithmIdentifier);
        Digest digest2 = BcUtil.createDigest(algorithmIdentifier2);
        return new RSADigestSigner(digest2);
    }

    protected AsymmetricKeyParameter extractKeyParameters(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        return PublicKeyFactory.createKey(subjectPublicKeyInfo);
    }
}

