/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.bouncycastle.jce.provider;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.jruby.org.bouncycastle.asn1.ASN1Encodable;
import org.jruby.org.bouncycastle.asn1.ASN1InputStream;
import org.jruby.org.bouncycastle.asn1.ASN1Object;
import org.jruby.org.bouncycastle.asn1.ASN1OutputStream;
import org.jruby.org.bouncycastle.asn1.ASN1Sequence;
import org.jruby.org.bouncycastle.asn1.DERInteger;
import org.jruby.org.bouncycastle.asn1.DERObjectIdentifier;
import org.jruby.org.bouncycastle.asn1.util.ASN1Dump;
import org.jruby.org.bouncycastle.asn1.x509.CRLDistPoint;
import org.jruby.org.bouncycastle.asn1.x509.CRLNumber;
import org.jruby.org.bouncycastle.asn1.x509.CertificateList;
import org.jruby.org.bouncycastle.asn1.x509.IssuingDistributionPoint;
import org.jruby.org.bouncycastle.asn1.x509.TBSCertList;
import org.jruby.org.bouncycastle.asn1.x509.X509Extension;
import org.jruby.org.bouncycastle.asn1.x509.X509Extensions;
import org.jruby.org.bouncycastle.jce.X509Principal;
import org.jruby.org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.jruby.org.bouncycastle.jce.provider.ExtCRLException;
import org.jruby.org.bouncycastle.jce.provider.RFC3280CertPathUtilities;
import org.jruby.org.bouncycastle.jce.provider.X509CRLEntryObject;
import org.jruby.org.bouncycastle.jce.provider.X509SignatureUtil;
import org.jruby.org.bouncycastle.util.encoders.Hex;
import org.jruby.org.bouncycastle.x509.extension.X509ExtensionUtil;

public class X509CRLObject
extends X509CRL {
    private CertificateList c;
    private String sigAlgName;
    private byte[] sigAlgParams;
    private boolean isIndirect;

    public X509CRLObject(CertificateList certificateList) throws CRLException {
        this.c = certificateList;
        try {
            this.sigAlgName = X509SignatureUtil.getSignatureName(certificateList.getSignatureAlgorithm());
            this.sigAlgParams = (byte[])(certificateList.getSignatureAlgorithm().getParameters() != null ? ((ASN1Encodable)certificateList.getSignatureAlgorithm().getParameters()).getDEREncoded() : null);
            this.isIndirect = this.isIndirectCRL();
        }
        catch (Exception exception2) {
            throw new CRLException("CRL contents invalid: " + exception2);
        }
    }

    public boolean hasUnsupportedCriticalExtension() {
        Set set = this.getCriticalExtensionOIDs();
        if (set == null) {
            return false;
        }
        set.remove(RFC3280CertPathUtilities.ISSUING_DISTRIBUTION_POINT);
        set.remove(RFC3280CertPathUtilities.DELTA_CRL_INDICATOR);
        return !set.isEmpty();
    }

    private Set getExtensionOIDs(boolean bl) {
        X509Extensions x509Extensions;
        if (this.getVersion() == 2 && (x509Extensions = this.c.getTBSCertList().getExtensions()) != null) {
            HashSet<String> hashSet = new HashSet<String>();
            Enumeration enumeration = x509Extensions.oids();
            while (enumeration.hasMoreElements()) {
                DERObjectIdentifier dERObjectIdentifier = (DERObjectIdentifier)enumeration.nextElement();
                X509Extension x509Extension = x509Extensions.getExtension(dERObjectIdentifier);
                if (bl != x509Extension.isCritical()) continue;
                hashSet.add(dERObjectIdentifier.getId());
            }
            return hashSet;
        }
        return null;
    }

    public Set getCriticalExtensionOIDs() {
        return this.getExtensionOIDs(true);
    }

    public Set getNonCriticalExtensionOIDs() {
        return this.getExtensionOIDs(false);
    }

    public byte[] getExtensionValue(String string2) {
        X509Extension x509Extension;
        X509Extensions x509Extensions = this.c.getTBSCertList().getExtensions();
        if (x509Extensions != null && (x509Extension = x509Extensions.getExtension(new DERObjectIdentifier(string2))) != null) {
            try {
                return x509Extension.getValue().getEncoded();
            }
            catch (Exception exception2) {
                throw new IllegalStateException("error parsing " + exception2.toString());
            }
        }
        return null;
    }

    public byte[] getEncoded() throws CRLException {
        try {
            return this.c.getEncoded("DER");
        }
        catch (IOException iOException) {
            throw new CRLException(iOException.toString());
        }
    }

    public void verify(PublicKey publicKey) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.verify(publicKey, BouncyCastleProvider.PROVIDER_NAME);
    }

    public void verify(PublicKey publicKey, String string2) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        if (!this.c.getSignatureAlgorithm().equals(this.c.getTBSCertList().getSignature())) {
            throw new CRLException("Signature algorithm on CertificateList does not match TBSCertList.");
        }
        Signature signature = Signature.getInstance(this.getSigAlgName(), string2);
        signature.initVerify(publicKey);
        signature.update(this.getTBSCertList());
        if (!signature.verify(this.getSignature())) {
            throw new SignatureException("CRL does not verify with supplied public key.");
        }
    }

    public int getVersion() {
        return this.c.getVersion();
    }

    public Principal getIssuerDN() {
        return new X509Principal(this.c.getIssuer());
    }

    public X500Principal getIssuerX500Principal() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ASN1OutputStream aSN1OutputStream = new ASN1OutputStream(byteArrayOutputStream);
            aSN1OutputStream.writeObject(this.c.getIssuer());
            return new X500Principal(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            throw new IllegalStateException("can't encode issuer DN");
        }
    }

    public Date getThisUpdate() {
        return this.c.getThisUpdate().getDate();
    }

    public Date getNextUpdate() {
        if (this.c.getNextUpdate() != null) {
            return this.c.getNextUpdate().getDate();
        }
        return null;
    }

    private Set loadCRLEntries() {
        HashSet<X509CRLEntryObject> hashSet = new HashSet<X509CRLEntryObject>();
        Enumeration enumeration = this.c.getRevokedCertificateEnumeration();
        X500Principal x500Principal = this.getIssuerX500Principal();
        while (enumeration.hasMoreElements()) {
            TBSCertList.CRLEntry cRLEntry = (TBSCertList.CRLEntry)enumeration.nextElement();
            X509CRLEntryObject x509CRLEntryObject = new X509CRLEntryObject(cRLEntry, this.isIndirect, x500Principal);
            hashSet.add(x509CRLEntryObject);
            x500Principal = x509CRLEntryObject.getCertificateIssuer();
        }
        return hashSet;
    }

    public X509CRLEntry getRevokedCertificate(BigInteger bigInteger) {
        Enumeration enumeration = this.c.getRevokedCertificateEnumeration();
        X500Principal x500Principal = this.getIssuerX500Principal();
        while (enumeration.hasMoreElements()) {
            TBSCertList.CRLEntry cRLEntry = (TBSCertList.CRLEntry)enumeration.nextElement();
            X509CRLEntryObject x509CRLEntryObject = new X509CRLEntryObject(cRLEntry, this.isIndirect, x500Principal);
            if (bigInteger.equals(cRLEntry.getUserCertificate().getValue())) {
                return x509CRLEntryObject;
            }
            x500Principal = x509CRLEntryObject.getCertificateIssuer();
        }
        return null;
    }

    public Set getRevokedCertificates() {
        Set set = this.loadCRLEntries();
        if (!set.isEmpty()) {
            return Collections.unmodifiableSet(set);
        }
        return null;
    }

    public byte[] getTBSCertList() throws CRLException {
        try {
            return this.c.getTBSCertList().getEncoded("DER");
        }
        catch (IOException iOException) {
            throw new CRLException(iOException.toString());
        }
    }

    public byte[] getSignature() {
        return this.c.getSignature().getBytes();
    }

    public String getSigAlgName() {
        return this.sigAlgName;
    }

    public String getSigAlgOID() {
        return this.c.getSignatureAlgorithm().getObjectId().getId();
    }

    public byte[] getSigAlgParams() {
        if (this.sigAlgParams != null) {
            byte[] byArray = new byte[this.sigAlgParams.length];
            System.arraycopy(this.sigAlgParams, 0, byArray, 0, byArray.length);
            return byArray;
        }
        return null;
    }

    public String toString() {
        Object object;
        Object object2;
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = System.getProperty("line.separator");
        stringBuffer.append("              Version: ").append(this.getVersion()).append(string2);
        stringBuffer.append("             IssuerDN: ").append(this.getIssuerDN()).append(string2);
        stringBuffer.append("          This update: ").append(this.getThisUpdate()).append(string2);
        stringBuffer.append("          Next update: ").append(this.getNextUpdate()).append(string2);
        stringBuffer.append("  Signature Algorithm: ").append(this.getSigAlgName()).append(string2);
        byte[] byArray = this.getSignature();
        stringBuffer.append("            Signature: ").append(new String(Hex.encode(byArray, 0, 20))).append(string2);
        for (int j = 20; j < byArray.length; j += 20) {
            if (j < byArray.length - 20) {
                stringBuffer.append("                       ").append(new String(Hex.encode(byArray, j, 20))).append(string2);
                continue;
            }
            stringBuffer.append("                       ").append(new String(Hex.encode(byArray, j, byArray.length - j))).append(string2);
        }
        X509Extensions x509Extensions = this.c.getTBSCertList().getExtensions();
        if (x509Extensions != null) {
            object2 = x509Extensions.oids();
            if (object2.hasMoreElements()) {
                stringBuffer.append("           Extensions: ").append(string2);
            }
            while (object2.hasMoreElements()) {
                object = (DERObjectIdentifier)object2.nextElement();
                X509Extension x509Extension = x509Extensions.getExtension((DERObjectIdentifier)object);
                if (x509Extension.getValue() != null) {
                    byte[] byArray2 = x509Extension.getValue().getOctets();
                    ASN1InputStream aSN1InputStream = new ASN1InputStream(byArray2);
                    stringBuffer.append("                       critical(").append(x509Extension.isCritical()).append(") ");
                    try {
                        if (((ASN1Object)object).equals(X509Extensions.CRLNumber)) {
                            stringBuffer.append(new CRLNumber(DERInteger.getInstance(aSN1InputStream.readObject()).getPositiveValue())).append(string2);
                            continue;
                        }
                        if (((ASN1Object)object).equals(X509Extensions.DeltaCRLIndicator)) {
                            stringBuffer.append("Base CRL: " + new CRLNumber(DERInteger.getInstance(aSN1InputStream.readObject()).getPositiveValue())).append(string2);
                            continue;
                        }
                        if (((ASN1Object)object).equals(X509Extensions.IssuingDistributionPoint)) {
                            stringBuffer.append(new IssuingDistributionPoint((ASN1Sequence)aSN1InputStream.readObject())).append(string2);
                            continue;
                        }
                        if (((ASN1Object)object).equals(X509Extensions.CRLDistributionPoints)) {
                            stringBuffer.append(new CRLDistPoint((ASN1Sequence)aSN1InputStream.readObject())).append(string2);
                            continue;
                        }
                        if (((ASN1Object)object).equals(X509Extensions.FreshestCRL)) {
                            stringBuffer.append(new CRLDistPoint((ASN1Sequence)aSN1InputStream.readObject())).append(string2);
                            continue;
                        }
                        stringBuffer.append(((DERObjectIdentifier)object).getId());
                        stringBuffer.append(" value = ").append(ASN1Dump.dumpAsString(aSN1InputStream.readObject())).append(string2);
                    }
                    catch (Exception exception2) {
                        stringBuffer.append(((DERObjectIdentifier)object).getId());
                        stringBuffer.append(" value = ").append("*****").append(string2);
                    }
                    continue;
                }
                stringBuffer.append(string2);
            }
        }
        if ((object2 = this.getRevokedCertificates()) != null) {
            object = object2.iterator();
            while (object.hasNext()) {
                stringBuffer.append(object.next());
                stringBuffer.append(string2);
            }
        }
        return stringBuffer.toString();
    }

    public boolean isRevoked(Certificate certificate) {
        if (!certificate.getType().equals("X.509")) {
            throw new RuntimeException("X.509 CRL used with non X.509 Cert");
        }
        TBSCertList.CRLEntry[] cRLEntryArray = this.c.getRevokedCertificates();
        if (cRLEntryArray != null) {
            BigInteger bigInteger = ((X509Certificate)certificate).getSerialNumber();
            for (int j = 0; j < cRLEntryArray.length; ++j) {
                if (!cRLEntryArray[j].getUserCertificate().getValue().equals(bigInteger)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isIndirectCRL() throws CRLException {
        byte[] byArray = this.getExtensionValue(X509Extensions.IssuingDistributionPoint.getId());
        boolean bl = false;
        try {
            if (byArray != null) {
                bl = IssuingDistributionPoint.getInstance(X509ExtensionUtil.fromExtensionValue(byArray)).isIndirectCRL();
            }
        }
        catch (Exception exception2) {
            throw new ExtCRLException("Exception reading IssuingDistributionPoint", exception2);
        }
        return bl;
    }
}

