/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.bouncycastle.jce.provider;

import org.jruby.org.bouncycastle.crypto.DataLengthException;
import org.jruby.org.bouncycastle.crypto.DerivationFunction;
import org.jruby.org.bouncycastle.crypto.DerivationParameters;
import org.jruby.org.bouncycastle.crypto.Digest;
import org.jruby.org.bouncycastle.crypto.params.KDFParameters;

public class BrokenKDF2BytesGenerator
implements DerivationFunction {
    private Digest digest;
    private byte[] shared;
    private byte[] iv;

    public BrokenKDF2BytesGenerator(Digest digest2) {
        this.digest = digest2;
    }

    public void init(DerivationParameters derivationParameters) {
        if (!(derivationParameters instanceof KDFParameters)) {
            throw new IllegalArgumentException("KDF parameters required for KDF2Generator");
        }
        KDFParameters kDFParameters = (KDFParameters)derivationParameters;
        this.shared = kDFParameters.getSharedSecret();
        this.iv = kDFParameters.getIV();
    }

    public Digest getDigest() {
        return this.digest;
    }

    public int generateBytes(byte[] byArray, int n, int n2) throws DataLengthException, IllegalArgumentException {
        if (byArray.length - n2 < n) {
            throw new DataLengthException("output buffer too small");
        }
        long l = n2 * 8;
        if (l > (long)(this.digest.getDigestSize() * 8) * 29L) {
            new IllegalArgumentException("Output length to large");
        }
        int n3 = (int)(l / (long)this.digest.getDigestSize());
        byte[] byArray2 = null;
        byArray2 = new byte[this.digest.getDigestSize()];
        for (int j = 1; j <= n3; ++j) {
            this.digest.update(this.shared, 0, this.shared.length);
            this.digest.update((byte)(j & 0xFF));
            this.digest.update((byte)(j >> 8 & 0xFF));
            this.digest.update((byte)(j >> 16 & 0xFF));
            this.digest.update((byte)(j >> 24 & 0xFF));
            this.digest.update(this.iv, 0, this.iv.length);
            this.digest.doFinal(byArray2, 0);
            if (n2 - n > byArray2.length) {
                System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
                n += byArray2.length;
                continue;
            }
            System.arraycopy(byArray2, 0, byArray, n, n2 - n);
        }
        this.digest.reset();
        return n2;
    }
}

