/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.bouncycastle.crypto.tls;

import java.math.BigInteger;
import org.jruby.org.bouncycastle.crypto.BasicAgreement;
import org.jruby.org.bouncycastle.crypto.agreement.DHBasicAgreement;
import org.jruby.org.bouncycastle.crypto.agreement.ECDHBasicAgreement;
import org.jruby.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.jruby.org.bouncycastle.crypto.params.DHPrivateKeyParameters;
import org.jruby.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.jruby.org.bouncycastle.crypto.tls.Certificate;
import org.jruby.org.bouncycastle.crypto.tls.TlsAgreementCredentials;
import org.jruby.org.bouncycastle.util.BigIntegers;

public class DefaultTlsAgreementCredentials
implements TlsAgreementCredentials {
    protected Certificate clientCert;
    protected AsymmetricKeyParameter clientPrivateKey;
    protected BasicAgreement basicAgreement;

    public DefaultTlsAgreementCredentials(Certificate certificate, AsymmetricKeyParameter asymmetricKeyParameter) {
        if (certificate == null) {
            throw new IllegalArgumentException("'clientCertificate' cannot be null");
        }
        if (certificate.certs.length == 0) {
            throw new IllegalArgumentException("'clientCertificate' cannot be empty");
        }
        if (asymmetricKeyParameter == null) {
            throw new IllegalArgumentException("'clientPrivateKey' cannot be null");
        }
        if (!asymmetricKeyParameter.isPrivate()) {
            throw new IllegalArgumentException("'clientPrivateKey' must be private");
        }
        if (asymmetricKeyParameter instanceof DHPrivateKeyParameters) {
            this.basicAgreement = new DHBasicAgreement();
        } else if (asymmetricKeyParameter instanceof ECPrivateKeyParameters) {
            this.basicAgreement = new ECDHBasicAgreement();
        } else {
            throw new IllegalArgumentException("'clientPrivateKey' type not supported: " + asymmetricKeyParameter.getClass().getName());
        }
        this.clientCert = certificate;
        this.clientPrivateKey = asymmetricKeyParameter;
    }

    public Certificate getCertificate() {
        return this.clientCert;
    }

    public byte[] generateAgreement(AsymmetricKeyParameter asymmetricKeyParameter) {
        this.basicAgreement.init(this.clientPrivateKey);
        BigInteger bigInteger = this.basicAgreement.calculateAgreement(asymmetricKeyParameter);
        return BigIntegers.asUnsignedByteArray(bigInteger);
    }
}

