/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.bouncycastle.cms.jcajce;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.Provider;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.jruby.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.jruby.org.bouncycastle.asn1.ASN1OctetString;
import org.jruby.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.jruby.org.bouncycastle.cms.CMSException;
import org.jruby.org.bouncycastle.cms.PasswordRecipientInfoGenerator;
import org.jruby.org.bouncycastle.cms.jcajce.CMSUtils;
import org.jruby.org.bouncycastle.cms.jcajce.EnvelopedDataHelper;
import org.jruby.org.bouncycastle.jcajce.DefaultJcaJceHelper;
import org.jruby.org.bouncycastle.jcajce.NamedJcaJceHelper;
import org.jruby.org.bouncycastle.jcajce.ProviderJcaJceHelper;
import org.jruby.org.bouncycastle.operator.GenericKey;

public class JcePasswordRecipientInfoGenerator
extends PasswordRecipientInfoGenerator {
    private EnvelopedDataHelper helper = new EnvelopedDataHelper(new DefaultJcaJceHelper());

    public JcePasswordRecipientInfoGenerator(ASN1ObjectIdentifier aSN1ObjectIdentifier, char[] cArray) {
        super(aSN1ObjectIdentifier, cArray);
    }

    public JcePasswordRecipientInfoGenerator setProvider(Provider provider) {
        this.helper = new EnvelopedDataHelper(new ProviderJcaJceHelper(provider));
        return this;
    }

    public JcePasswordRecipientInfoGenerator setProvider(String string2) {
        this.helper = new EnvelopedDataHelper(new NamedJcaJceHelper(string2));
        return this;
    }

    public byte[] generateEncryptedBytes(AlgorithmIdentifier algorithmIdentifier, byte[] byArray, GenericKey genericKey) throws CMSException {
        Key key2 = CMSUtils.getJceKey(genericKey);
        Cipher cipher2 = this.helper.createRFC3211Wrapper(algorithmIdentifier.getAlgorithm());
        try {
            IvParameterSpec ivParameterSpec = new IvParameterSpec(ASN1OctetString.getInstance(algorithmIdentifier.getParameters()).getOctets());
            cipher2.init(3, (Key)new SecretKeySpec(byArray, cipher2.getAlgorithm()), ivParameterSpec);
            return cipher2.wrap(key2);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new CMSException("cannot process content encryption key: " + generalSecurityException.getMessage(), generalSecurityException);
        }
    }
}

