/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.bouncycastle.cms;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import org.jruby.org.bouncycastle.asn1.ASN1EncodableVector;
import org.jruby.org.bouncycastle.asn1.DERObjectIdentifier;
import org.jruby.org.bouncycastle.asn1.DEROctetString;
import org.jruby.org.bouncycastle.asn1.DERSequence;
import org.jruby.org.bouncycastle.asn1.cms.PasswordRecipientInfo;
import org.jruby.org.bouncycastle.asn1.cms.RecipientInfo;
import org.jruby.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.jruby.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.jruby.org.bouncycastle.cms.CMSEnvelopedHelper;
import org.jruby.org.bouncycastle.cms.IntRecipientInfoGenerator;

class PasswordIntRecipientInfoGenerator
implements IntRecipientInfoGenerator {
    private AlgorithmIdentifier keyDerivationAlgorithm;
    private SecretKey keyEncryptionKey;

    PasswordIntRecipientInfoGenerator() {
    }

    void setKeyDerivationAlgorithm(AlgorithmIdentifier algorithmIdentifier) {
        this.keyDerivationAlgorithm = algorithmIdentifier;
    }

    void setKeyEncryptionKey(SecretKey secretKey) {
        this.keyEncryptionKey = secretKey;
    }

    public RecipientInfo generate(SecretKey secretKey, SecureRandom secureRandom, Provider provider) throws GeneralSecurityException {
        CMSEnvelopedHelper cMSEnvelopedHelper = CMSEnvelopedHelper.INSTANCE;
        String string2 = cMSEnvelopedHelper.getRFC3211WrapperName(this.keyEncryptionKey.getAlgorithm());
        Cipher cipher2 = cMSEnvelopedHelper.createSymmetricCipher(string2, provider);
        cipher2.init(3, (Key)this.keyEncryptionKey, secureRandom);
        byte[] byArray = cipher2.wrap(secretKey);
        DEROctetString dEROctetString = new DEROctetString(byArray);
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new DERObjectIdentifier(this.keyEncryptionKey.getAlgorithm()));
        aSN1EncodableVector.add(new DEROctetString(cipher2.getIV()));
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_alg_PWRI_KEK, new DERSequence(aSN1EncodableVector));
        return new RecipientInfo(new PasswordRecipientInfo(this.keyDerivationAlgorithm, algorithmIdentifier, dEROctetString));
    }
}

