/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.bouncycastle.cms;

import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.ProviderException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.jruby.org.bouncycastle.asn1.ASN1OctetString;
import org.jruby.org.bouncycastle.asn1.DERObjectIdentifier;
import org.jruby.org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.jruby.org.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import org.jruby.org.bouncycastle.asn1.cms.RecipientIdentifier;
import org.jruby.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.jruby.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.jruby.org.bouncycastle.cms.AuthAttributesProvider;
import org.jruby.org.bouncycastle.cms.CMSEnvelopedHelper;
import org.jruby.org.bouncycastle.cms.CMSException;
import org.jruby.org.bouncycastle.cms.CMSSecureReadable;
import org.jruby.org.bouncycastle.cms.CMSTypedStream;
import org.jruby.org.bouncycastle.cms.CMSUtils;
import org.jruby.org.bouncycastle.cms.KeyTransRecipient;
import org.jruby.org.bouncycastle.cms.KeyTransRecipientId;
import org.jruby.org.bouncycastle.cms.Recipient;
import org.jruby.org.bouncycastle.cms.RecipientInformation;
import org.jruby.org.bouncycastle.cms.RecipientOperator;

public class KeyTransRecipientInformation
extends RecipientInformation {
    private KeyTransRecipientInfo info;

    KeyTransRecipientInformation(KeyTransRecipientInfo keyTransRecipientInfo, AlgorithmIdentifier algorithmIdentifier, CMSSecureReadable cMSSecureReadable, AuthAttributesProvider authAttributesProvider) {
        super(keyTransRecipientInfo.getKeyEncryptionAlgorithm(), algorithmIdentifier, cMSSecureReadable, authAttributesProvider);
        this.info = keyTransRecipientInfo;
        RecipientIdentifier recipientIdentifier = keyTransRecipientInfo.getRecipientIdentifier();
        if (recipientIdentifier.isTagged()) {
            ASN1OctetString aSN1OctetString = ASN1OctetString.getInstance(recipientIdentifier.getId());
            this.rid = new KeyTransRecipientId(aSN1OctetString.getOctets());
        } else {
            IssuerAndSerialNumber issuerAndSerialNumber = IssuerAndSerialNumber.getInstance(recipientIdentifier.getId());
            this.rid = new KeyTransRecipientId(issuerAndSerialNumber.getName(), issuerAndSerialNumber.getSerialNumber().getValue());
        }
    }

    private String getExchangeEncryptionAlgorithmName(DERObjectIdentifier dERObjectIdentifier) {
        if (PKCSObjectIdentifiers.rsaEncryption.equals(dERObjectIdentifier)) {
            return "RSA/ECB/PKCS1Padding";
        }
        return dERObjectIdentifier.getId();
    }

    protected Key getSessionKey(Key key2, Provider provider) throws CMSException {
        CMSEnvelopedHelper cMSEnvelopedHelper = CMSEnvelopedHelper.INSTANCE;
        String string2 = this.getExchangeEncryptionAlgorithmName(this.keyEncAlg.getObjectId());
        try {
            Key key3 = null;
            Cipher cipher2 = cMSEnvelopedHelper.createAsymmetricCipher(string2, provider);
            byte[] byArray = this.info.getEncryptedKey().getOctets();
            String string3 = this.getContentAlgorithmName();
            try {
                cipher2.init(4, key2);
                key3 = cipher2.unwrap(byArray, string3, 3);
            }
            catch (GeneralSecurityException generalSecurityException) {
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
            }
            catch (ProviderException providerException) {
                // empty catch block
            }
            if (key3 == null) {
                cipher2.init(2, key2);
                key3 = new SecretKeySpec(cipher2.doFinal(byArray), string3);
            }
            return key3;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("can't find algorithm.", noSuchAlgorithmException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CMSException("key invalid in message.", invalidKeyException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new CMSException("required padding not supported.", noSuchPaddingException);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new CMSException("illegal blocksize in message.", illegalBlockSizeException);
        }
        catch (BadPaddingException badPaddingException) {
            throw new CMSException("bad padding in message.", badPaddingException);
        }
    }

    public CMSTypedStream getContentStream(Key key2, String string2) throws CMSException, NoSuchProviderException {
        return this.getContentStream(key2, CMSUtils.getProvider(string2));
    }

    public CMSTypedStream getContentStream(Key key2, Provider provider) throws CMSException {
        Key key3 = this.getSessionKey(key2, provider);
        return this.getContentFromSessionKey(key3, provider);
    }

    protected RecipientOperator getRecipientOperator(Recipient recipient) throws CMSException {
        return ((KeyTransRecipient)recipient).getRecipientOperator(this.keyEncAlg, this.messageAlgorithm, this.info.getEncryptedKey().getOctets());
    }
}

