/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.bouncycastle.cms;

import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jruby.org.bouncycastle.asn1.ASN1Object;
import org.jruby.org.bouncycastle.asn1.ASN1Set;
import org.jruby.org.bouncycastle.asn1.DERNull;
import org.jruby.org.bouncycastle.asn1.DERObjectIdentifier;
import org.jruby.org.bouncycastle.asn1.DEROctetString;
import org.jruby.org.bouncycastle.asn1.DERSet;
import org.jruby.org.bouncycastle.asn1.DERTaggedObject;
import org.jruby.org.bouncycastle.asn1.cms.AttributeTable;
import org.jruby.org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.jruby.org.bouncycastle.asn1.cms.SignerIdentifier;
import org.jruby.org.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import org.jruby.org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.jruby.org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.jruby.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.jruby.org.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import org.jruby.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.jruby.org.bouncycastle.asn1.x509.AttributeCertificate;
import org.jruby.org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.jruby.org.bouncycastle.cms.CMSException;
import org.jruby.org.bouncycastle.cms.CMSUtils;
import org.jruby.org.bouncycastle.cms.SignerInfoGenerator;
import org.jruby.org.bouncycastle.cms.SignerInformationStore;
import org.jruby.org.bouncycastle.jce.interfaces.GOST3410PrivateKey;
import org.jruby.org.bouncycastle.util.Store;
import org.jruby.org.bouncycastle.x509.X509AttributeCertificate;
import org.jruby.org.bouncycastle.x509.X509Store;

public class CMSSignedGenerator {
    public static final String DATA = CMSObjectIdentifiers.data.getId();
    public static final String DIGEST_SHA1 = OIWObjectIdentifiers.idSHA1.getId();
    public static final String DIGEST_SHA224 = NISTObjectIdentifiers.id_sha224.getId();
    public static final String DIGEST_SHA256 = NISTObjectIdentifiers.id_sha256.getId();
    public static final String DIGEST_SHA384 = NISTObjectIdentifiers.id_sha384.getId();
    public static final String DIGEST_SHA512 = NISTObjectIdentifiers.id_sha512.getId();
    public static final String DIGEST_MD5 = PKCSObjectIdentifiers.md5.getId();
    public static final String DIGEST_GOST3411 = CryptoProObjectIdentifiers.gostR3411.getId();
    public static final String DIGEST_RIPEMD128 = TeleTrusTObjectIdentifiers.ripemd128.getId();
    public static final String DIGEST_RIPEMD160 = TeleTrusTObjectIdentifiers.ripemd160.getId();
    public static final String DIGEST_RIPEMD256 = TeleTrusTObjectIdentifiers.ripemd256.getId();
    public static final String ENCRYPTION_RSA = PKCSObjectIdentifiers.rsaEncryption.getId();
    public static final String ENCRYPTION_DSA = X9ObjectIdentifiers.id_dsa_with_sha1.getId();
    public static final String ENCRYPTION_ECDSA = X9ObjectIdentifiers.ecdsa_with_SHA1.getId();
    public static final String ENCRYPTION_RSA_PSS = PKCSObjectIdentifiers.id_RSASSA_PSS.getId();
    public static final String ENCRYPTION_GOST3410 = CryptoProObjectIdentifiers.gostR3410_94.getId();
    public static final String ENCRYPTION_ECGOST3410 = CryptoProObjectIdentifiers.gostR3410_2001.getId();
    private static final String ENCRYPTION_ECDSA_WITH_SHA1 = X9ObjectIdentifiers.ecdsa_with_SHA1.getId();
    private static final String ENCRYPTION_ECDSA_WITH_SHA224 = X9ObjectIdentifiers.ecdsa_with_SHA224.getId();
    private static final String ENCRYPTION_ECDSA_WITH_SHA256 = X9ObjectIdentifiers.ecdsa_with_SHA256.getId();
    private static final String ENCRYPTION_ECDSA_WITH_SHA384 = X9ObjectIdentifiers.ecdsa_with_SHA384.getId();
    private static final String ENCRYPTION_ECDSA_WITH_SHA512 = X9ObjectIdentifiers.ecdsa_with_SHA512.getId();
    private static final Set NO_PARAMS = new HashSet();
    private static final Map EC_ALGORITHMS = new HashMap();
    protected List certs = new ArrayList();
    protected List crls = new ArrayList();
    protected List _signers = new ArrayList();
    protected List signerGens = new ArrayList();
    protected Map digests = new HashMap();
    protected final SecureRandom rand;

    protected CMSSignedGenerator() {
        this(new SecureRandom());
    }

    protected CMSSignedGenerator(SecureRandom secureRandom) {
        this.rand = secureRandom;
    }

    protected String getEncOID(PrivateKey privateKey, String string2) {
        String string3 = null;
        if (privateKey instanceof RSAPrivateKey || "RSA".equalsIgnoreCase(privateKey.getAlgorithm())) {
            string3 = ENCRYPTION_RSA;
        } else if (privateKey instanceof DSAPrivateKey || "DSA".equalsIgnoreCase(privateKey.getAlgorithm())) {
            string3 = ENCRYPTION_DSA;
            if (!string2.equals(DIGEST_SHA1)) {
                throw new IllegalArgumentException("can't mix DSA with anything but SHA1");
            }
        } else if ("ECDSA".equalsIgnoreCase(privateKey.getAlgorithm()) || "EC".equalsIgnoreCase(privateKey.getAlgorithm())) {
            string3 = (String)EC_ALGORITHMS.get(string2);
            if (string3 == null) {
                throw new IllegalArgumentException("can't mix ECDSA with anything but SHA family digests");
            }
        } else if (privateKey instanceof GOST3410PrivateKey || "GOST3410".equalsIgnoreCase(privateKey.getAlgorithm())) {
            string3 = ENCRYPTION_GOST3410;
        } else if ("ECGOST3410".equalsIgnoreCase(privateKey.getAlgorithm())) {
            string3 = ENCRYPTION_ECGOST3410;
        }
        return string3;
    }

    protected AlgorithmIdentifier getEncAlgorithmIdentifier(String string2, Signature signature) throws IOException {
        if (NO_PARAMS.contains(string2)) {
            return new AlgorithmIdentifier(new DERObjectIdentifier(string2));
        }
        if (string2.equals(ENCRYPTION_RSA_PSS)) {
            AlgorithmParameters algorithmParameters = signature.getParameters();
            return new AlgorithmIdentifier(new DERObjectIdentifier(string2), ASN1Object.fromByteArray(algorithmParameters.getEncoded()));
        }
        return new AlgorithmIdentifier(new DERObjectIdentifier(string2), new DERNull());
    }

    protected Map getBaseParameters(DERObjectIdentifier dERObjectIdentifier, AlgorithmIdentifier algorithmIdentifier, byte[] byArray) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("contentType", dERObjectIdentifier);
        hashMap.put("digestAlgID", algorithmIdentifier);
        hashMap.put("digest", byArray.clone());
        return hashMap;
    }

    protected ASN1Set getAttributeSet(AttributeTable attributeTable) {
        if (attributeTable != null) {
            return new DERSet(attributeTable.toASN1EncodableVector());
        }
        return null;
    }

    public void addCertificatesAndCRLs(CertStore certStore) throws CertStoreException, CMSException {
        this.certs.addAll(CMSUtils.getCertificatesFromStore(certStore));
        this.crls.addAll(CMSUtils.getCRLsFromStore(certStore));
    }

    public void addCertificates(Store store) throws CMSException {
        this.certs.addAll(CMSUtils.getCertificatesFromStore(store));
    }

    public void addCRLs(Store store) throws CMSException {
        this.crls.addAll(CMSUtils.getCRLsFromStore(store));
    }

    public void addAttributeCertificates(Store store) throws CMSException {
        this.certs.addAll(CMSUtils.getAttributeCertificatesFromStore(store));
    }

    public void addAttributeCertificates(X509Store x509Store) throws CMSException {
        try {
            for (X509AttributeCertificate x509AttributeCertificate : x509Store.getMatches(null)) {
                this.certs.add(new DERTaggedObject(false, 2, AttributeCertificate.getInstance(ASN1Object.fromByteArray(x509AttributeCertificate.getEncoded()))));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CMSException("error processing attribute certs", illegalArgumentException);
        }
        catch (IOException iOException) {
            throw new CMSException("error processing attribute certs", iOException);
        }
    }

    public void addSigners(SignerInformationStore signerInformationStore) {
        Iterator iterator = signerInformationStore.getSigners().iterator();
        while (iterator.hasNext()) {
            this._signers.add(iterator.next());
        }
    }

    public void addSignerInfoGenerator(SignerInfoGenerator signerInfoGenerator) {
        this.signerGens.add(signerInfoGenerator);
    }

    public Map getGeneratedDigests() {
        return new HashMap(this.digests);
    }

    static SignerIdentifier getSignerIdentifier(X509Certificate x509Certificate) {
        return new SignerIdentifier(CMSUtils.getIssuerAndSerialNumber(x509Certificate));
    }

    static SignerIdentifier getSignerIdentifier(byte[] byArray) {
        return new SignerIdentifier(new DEROctetString(byArray));
    }

    static {
        NO_PARAMS.add(ENCRYPTION_DSA);
        NO_PARAMS.add(ENCRYPTION_ECDSA);
        NO_PARAMS.add(ENCRYPTION_ECDSA_WITH_SHA1);
        NO_PARAMS.add(ENCRYPTION_ECDSA_WITH_SHA224);
        NO_PARAMS.add(ENCRYPTION_ECDSA_WITH_SHA256);
        NO_PARAMS.add(ENCRYPTION_ECDSA_WITH_SHA384);
        NO_PARAMS.add(ENCRYPTION_ECDSA_WITH_SHA512);
        EC_ALGORITHMS.put(DIGEST_SHA1, ENCRYPTION_ECDSA_WITH_SHA1);
        EC_ALGORITHMS.put(DIGEST_SHA224, ENCRYPTION_ECDSA_WITH_SHA224);
        EC_ALGORITHMS.put(DIGEST_SHA256, ENCRYPTION_ECDSA_WITH_SHA256);
        EC_ALGORITHMS.put(DIGEST_SHA384, ENCRYPTION_ECDSA_WITH_SHA384);
        EC_ALGORITHMS.put(DIGEST_SHA512, ENCRYPTION_ECDSA_WITH_SHA512);
    }
}

