/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.bouncycastle.cms;

import java.io.IOException;
import java.security.AlgorithmParameterGenerator;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.crypto.SecretKey;
import javax.crypto.spec.RC2ParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.jruby.org.bouncycastle.asn1.ASN1Object;
import org.jruby.org.bouncycastle.asn1.DERNull;
import org.jruby.org.bouncycastle.asn1.DERObjectIdentifier;
import org.jruby.org.bouncycastle.asn1.DEROctetString;
import org.jruby.org.bouncycastle.asn1.cms.KEKIdentifier;
import org.jruby.org.bouncycastle.asn1.kisa.KISAObjectIdentifiers;
import org.jruby.org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.jruby.org.bouncycastle.asn1.ntt.NTTObjectIdentifiers;
import org.jruby.org.bouncycastle.asn1.pkcs.PBKDF2Params;
import org.jruby.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.jruby.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.jruby.org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.jruby.org.bouncycastle.cms.CMSAttributeTableGenerator;
import org.jruby.org.bouncycastle.cms.CMSException;
import org.jruby.org.bouncycastle.cms.CMSPBEKey;
import org.jruby.org.bouncycastle.cms.CMSUtils;
import org.jruby.org.bouncycastle.cms.KEKIntRecipientInfoGenerator;
import org.jruby.org.bouncycastle.cms.KeyAgreeIntRecipientInfoGenerator;
import org.jruby.org.bouncycastle.cms.KeyTransIntRecipientInfoGenerator;
import org.jruby.org.bouncycastle.cms.PasswordIntRecipientInfoGenerator;
import org.jruby.org.bouncycastle.cms.RecipientInfoGenerator;

public class CMSEnvelopedGenerator {
    public static final String DES_EDE3_CBC = PKCSObjectIdentifiers.des_EDE3_CBC.getId();
    public static final String RC2_CBC = PKCSObjectIdentifiers.RC2_CBC.getId();
    public static final String IDEA_CBC = "1.3.6.1.4.1.188.7.1.1.2";
    public static final String CAST5_CBC = "1.2.840.113533.7.66.10";
    public static final String AES128_CBC = NISTObjectIdentifiers.id_aes128_CBC.getId();
    public static final String AES192_CBC = NISTObjectIdentifiers.id_aes192_CBC.getId();
    public static final String AES256_CBC = NISTObjectIdentifiers.id_aes256_CBC.getId();
    public static final String CAMELLIA128_CBC = NTTObjectIdentifiers.id_camellia128_cbc.getId();
    public static final String CAMELLIA192_CBC = NTTObjectIdentifiers.id_camellia192_cbc.getId();
    public static final String CAMELLIA256_CBC = NTTObjectIdentifiers.id_camellia256_cbc.getId();
    public static final String SEED_CBC = KISAObjectIdentifiers.id_seedCBC.getId();
    public static final String DES_EDE3_WRAP = PKCSObjectIdentifiers.id_alg_CMS3DESwrap.getId();
    public static final String AES128_WRAP = NISTObjectIdentifiers.id_aes128_wrap.getId();
    public static final String AES192_WRAP = NISTObjectIdentifiers.id_aes192_wrap.getId();
    public static final String AES256_WRAP = NISTObjectIdentifiers.id_aes256_wrap.getId();
    public static final String CAMELLIA128_WRAP = NTTObjectIdentifiers.id_camellia128_wrap.getId();
    public static final String CAMELLIA192_WRAP = NTTObjectIdentifiers.id_camellia192_wrap.getId();
    public static final String CAMELLIA256_WRAP = NTTObjectIdentifiers.id_camellia256_wrap.getId();
    public static final String SEED_WRAP = KISAObjectIdentifiers.id_npki_app_cmsSeed_wrap.getId();
    public static final String ECDH_SHA1KDF = X9ObjectIdentifiers.dhSinglePass_stdDH_sha1kdf_scheme.getId();
    public static final String ECMQV_SHA1KDF = X9ObjectIdentifiers.mqvSinglePass_sha1kdf_scheme.getId();
    final List oldRecipientInfoGenerators = new ArrayList();
    final List recipientInfoGenerators = new ArrayList();
    protected CMSAttributeTableGenerator unprotectedAttributeGenerator = null;
    final SecureRandom rand;

    public CMSEnvelopedGenerator() {
        this(new SecureRandom());
    }

    public CMSEnvelopedGenerator(SecureRandom secureRandom) {
        this.rand = secureRandom;
    }

    public void setUnprotectedAttributeGenerator(CMSAttributeTableGenerator cMSAttributeTableGenerator) {
        this.unprotectedAttributeGenerator = cMSAttributeTableGenerator;
    }

    public void addKeyTransRecipient(X509Certificate x509Certificate) throws IllegalArgumentException {
        KeyTransIntRecipientInfoGenerator keyTransIntRecipientInfoGenerator = new KeyTransIntRecipientInfoGenerator();
        keyTransIntRecipientInfoGenerator.setRecipientCert(x509Certificate);
        this.oldRecipientInfoGenerators.add(keyTransIntRecipientInfoGenerator);
    }

    public void addKeyTransRecipient(PublicKey publicKey, byte[] byArray) throws IllegalArgumentException {
        KeyTransIntRecipientInfoGenerator keyTransIntRecipientInfoGenerator = new KeyTransIntRecipientInfoGenerator();
        keyTransIntRecipientInfoGenerator.setRecipientPublicKey(publicKey);
        keyTransIntRecipientInfoGenerator.setSubjectKeyIdentifier(new DEROctetString(byArray));
        this.oldRecipientInfoGenerators.add(keyTransIntRecipientInfoGenerator);
    }

    public void addKEKRecipient(SecretKey secretKey, byte[] byArray) {
        this.addKEKRecipient(secretKey, new KEKIdentifier(byArray, null, null));
    }

    public void addKEKRecipient(SecretKey secretKey, KEKIdentifier kEKIdentifier) {
        KEKIntRecipientInfoGenerator kEKIntRecipientInfoGenerator = new KEKIntRecipientInfoGenerator();
        kEKIntRecipientInfoGenerator.setKEKIdentifier(kEKIdentifier);
        kEKIntRecipientInfoGenerator.setKeyEncryptionKey(secretKey);
        this.oldRecipientInfoGenerators.add(kEKIntRecipientInfoGenerator);
    }

    public void addPasswordRecipient(CMSPBEKey cMSPBEKey, String string2) {
        PBKDF2Params pBKDF2Params = new PBKDF2Params(cMSPBEKey.getSalt(), cMSPBEKey.getIterationCount());
        PasswordIntRecipientInfoGenerator passwordIntRecipientInfoGenerator = new PasswordIntRecipientInfoGenerator();
        passwordIntRecipientInfoGenerator.setKeyDerivationAlgorithm(new AlgorithmIdentifier(PKCSObjectIdentifiers.id_PBKDF2, pBKDF2Params));
        passwordIntRecipientInfoGenerator.setKeyEncryptionKey(new SecretKeySpec(cMSPBEKey.getEncoded(string2), string2));
        this.oldRecipientInfoGenerators.add(passwordIntRecipientInfoGenerator);
    }

    public void addKeyAgreementRecipient(String string2, PrivateKey privateKey, PublicKey publicKey, X509Certificate x509Certificate, String string3, String string4) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidKeyException {
        this.addKeyAgreementRecipient(string2, privateKey, publicKey, x509Certificate, string3, CMSUtils.getProvider(string4));
    }

    public void addKeyAgreementRecipient(String string2, PrivateKey privateKey, PublicKey publicKey, X509Certificate x509Certificate, String string3, Provider provider) throws NoSuchAlgorithmException, InvalidKeyException {
        this.addKeyAgreementRecipients(string2, privateKey, publicKey, Collections.singletonList(x509Certificate), string3, provider);
    }

    public void addKeyAgreementRecipients(String string2, PrivateKey privateKey, PublicKey publicKey, Collection collection, String string3, String string4) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidKeyException {
        this.addKeyAgreementRecipients(string2, privateKey, publicKey, collection, string3, CMSUtils.getProvider(string4));
    }

    public void addKeyAgreementRecipients(String string2, PrivateKey privateKey, PublicKey publicKey, Collection collection, String string3, Provider provider) throws NoSuchAlgorithmException, InvalidKeyException {
        KeyAgreeIntRecipientInfoGenerator keyAgreeIntRecipientInfoGenerator = new KeyAgreeIntRecipientInfoGenerator();
        keyAgreeIntRecipientInfoGenerator.setKeyAgreementOID(new DERObjectIdentifier(string2));
        keyAgreeIntRecipientInfoGenerator.setKeyEncryptionOID(new DERObjectIdentifier(string3));
        keyAgreeIntRecipientInfoGenerator.setRecipientCerts(collection);
        keyAgreeIntRecipientInfoGenerator.setSenderKeyPair(new KeyPair(publicKey, privateKey));
        this.oldRecipientInfoGenerators.add(keyAgreeIntRecipientInfoGenerator);
    }

    public void addRecipientInfoGenerator(RecipientInfoGenerator recipientInfoGenerator) {
        this.recipientInfoGenerators.add(recipientInfoGenerator);
    }

    protected AlgorithmIdentifier getAlgorithmIdentifier(String string2, AlgorithmParameters algorithmParameters) throws IOException {
        ASN1Object aSN1Object = algorithmParameters != null ? ASN1Object.fromByteArray(algorithmParameters.getEncoded("ASN.1")) : DERNull.INSTANCE;
        return new AlgorithmIdentifier(new DERObjectIdentifier(string2), aSN1Object);
    }

    protected AlgorithmParameters generateParameters(String string2, SecretKey secretKey, Provider provider) throws CMSException {
        try {
            AlgorithmParameterGenerator algorithmParameterGenerator = AlgorithmParameterGenerator.getInstance(string2, provider);
            if (string2.equals(RC2_CBC)) {
                byte[] byArray = new byte[8];
                this.rand.nextBytes(byArray);
                try {
                    algorithmParameterGenerator.init(new RC2ParameterSpec(secretKey.getEncoded().length * 8, byArray), this.rand);
                }
                catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                    throw new CMSException("parameters generation error: " + invalidAlgorithmParameterException, invalidAlgorithmParameterException);
                }
            }
            return algorithmParameterGenerator.generateParameters();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }
}

