/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.bouncycastle.cert.crmf.jcajce;

import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.ProviderException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.SecretKeySpec;
import org.jruby.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.jruby.org.bouncycastle.cert.crmf.CRMFException;
import org.jruby.org.bouncycastle.cert.crmf.ValueDecryptorGenerator;
import org.jruby.org.bouncycastle.cert.crmf.jcajce.CRMFHelper;
import org.jruby.org.bouncycastle.jcajce.DefaultJcaJceHelper;
import org.jruby.org.bouncycastle.jcajce.NamedJcaJceHelper;
import org.jruby.org.bouncycastle.jcajce.ProviderJcaJceHelper;
import org.jruby.org.bouncycastle.operator.InputDecryptor;

public class JceAsymmetricValueDecryptorGenerator
implements ValueDecryptorGenerator {
    private PrivateKey recipientKey;
    private CRMFHelper helper = new CRMFHelper(new DefaultJcaJceHelper());

    public JceAsymmetricValueDecryptorGenerator(PrivateKey privateKey) {
        this.recipientKey = privateKey;
    }

    public JceAsymmetricValueDecryptorGenerator setProvider(Provider provider) {
        this.helper = new CRMFHelper(new ProviderJcaJceHelper(provider));
        return this;
    }

    public JceAsymmetricValueDecryptorGenerator setProvider(String string2) {
        this.helper = new CRMFHelper(new NamedJcaJceHelper(string2));
        return this;
    }

    private Key extractSecretKey(AlgorithmIdentifier algorithmIdentifier, AlgorithmIdentifier algorithmIdentifier2, byte[] byArray) throws CRMFException {
        try {
            Key key2 = null;
            Cipher cipher2 = this.helper.createCipher(algorithmIdentifier.getAlgorithm());
            try {
                cipher2.init(4, this.recipientKey);
                key2 = cipher2.unwrap(byArray, algorithmIdentifier2.getAlgorithm().getId(), 3);
            }
            catch (GeneralSecurityException generalSecurityException) {
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
            }
            catch (ProviderException providerException) {
                // empty catch block
            }
            if (key2 == null) {
                cipher2.init(2, this.recipientKey);
                key2 = new SecretKeySpec(cipher2.doFinal(byArray), algorithmIdentifier2.getAlgorithm().getId());
            }
            return key2;
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CRMFException("key invalid in message.", invalidKeyException);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new CRMFException("illegal blocksize in message.", illegalBlockSizeException);
        }
        catch (BadPaddingException badPaddingException) {
            throw new CRMFException("bad padding in message.", badPaddingException);
        }
    }

    public InputDecryptor getValueDecryptor(AlgorithmIdentifier algorithmIdentifier, final AlgorithmIdentifier algorithmIdentifier2, byte[] byArray) throws CRMFException {
        Key key2 = this.extractSecretKey(algorithmIdentifier, algorithmIdentifier2, byArray);
        final Cipher cipher2 = this.helper.createContentCipher(key2, algorithmIdentifier2);
        return new InputDecryptor(){

            public AlgorithmIdentifier getAlgorithmIdentifier() {
                return algorithmIdentifier2;
            }

            public InputStream getInputStream(InputStream inputStream) {
                return new CipherInputStream(inputStream, cipher2);
            }
        };
    }
}

