/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.bouncycastle.cert.crmf.jcajce;

import java.security.Provider;
import java.security.PublicKey;
import javax.security.auth.x500.X500Principal;
import org.jruby.org.bouncycastle.asn1.crmf.CertReqMsg;
import org.jruby.org.bouncycastle.asn1.x500.X500Name;
import org.jruby.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.jruby.org.bouncycastle.cert.crmf.CRMFException;
import org.jruby.org.bouncycastle.cert.crmf.CertificateRequestMessage;
import org.jruby.org.bouncycastle.cert.crmf.jcajce.CRMFHelper;
import org.jruby.org.bouncycastle.jcajce.DefaultJcaJceHelper;
import org.jruby.org.bouncycastle.jcajce.NamedJcaJceHelper;
import org.jruby.org.bouncycastle.jcajce.ProviderJcaJceHelper;

public class JcaCertificateRequestMessage
extends CertificateRequestMessage {
    private CRMFHelper helper = new CRMFHelper(new DefaultJcaJceHelper());

    public JcaCertificateRequestMessage(CertificateRequestMessage certificateRequestMessage) {
        this(certificateRequestMessage.toASN1Structure());
    }

    public JcaCertificateRequestMessage(CertReqMsg certReqMsg) {
        super(certReqMsg);
    }

    public JcaCertificateRequestMessage setProvider(String string2) {
        this.helper = new CRMFHelper(new NamedJcaJceHelper(string2));
        return this;
    }

    public JcaCertificateRequestMessage setProvider(Provider provider) {
        this.helper = new CRMFHelper(new ProviderJcaJceHelper(provider));
        return this;
    }

    public X500Principal getSubjectX500Principal() {
        X500Name x500Name = this.getCertTemplate().getSubject();
        if (x500Name != null) {
            return new X500Principal(x500Name.getDEREncoded());
        }
        return null;
    }

    public PublicKey getPublicKey() throws CRMFException {
        SubjectPublicKeyInfo subjectPublicKeyInfo = this.getCertTemplate().getPublicKey();
        if (subjectPublicKeyInfo != null) {
            return this.helper.toPublicKey(subjectPublicKeyInfo);
        }
        return null;
    }
}

