/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.bouncycastle.cert.crmf;

import org.jruby.org.bouncycastle.asn1.DERBitString;
import org.jruby.org.bouncycastle.asn1.crmf.PKMACValue;
import org.jruby.org.bouncycastle.asn1.crmf.POPOSigningKey;
import org.jruby.org.bouncycastle.asn1.crmf.POPOSigningKeyInput;
import org.jruby.org.bouncycastle.asn1.x509.GeneralName;
import org.jruby.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.jruby.org.bouncycastle.cert.crmf.CRMFException;
import org.jruby.org.bouncycastle.cert.crmf.CRMFUtil;
import org.jruby.org.bouncycastle.cert.crmf.PKMACValueGenerator;
import org.jruby.org.bouncycastle.operator.ContentSigner;

public class ProofOfPossessionSigningKeyBuilder {
    private SubjectPublicKeyInfo pubKeyInfo;
    private GeneralName name;
    private PKMACValue publicKeyMAC;

    public ProofOfPossessionSigningKeyBuilder(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        this.pubKeyInfo = subjectPublicKeyInfo;
    }

    public ProofOfPossessionSigningKeyBuilder setSender(GeneralName generalName) {
        this.name = generalName;
        return this;
    }

    public ProofOfPossessionSigningKeyBuilder setPublicKeyMac(PKMACValueGenerator pKMACValueGenerator, char[] cArray) throws CRMFException {
        this.publicKeyMAC = pKMACValueGenerator.generate(cArray, this.pubKeyInfo);
        return this;
    }

    public POPOSigningKey build(ContentSigner contentSigner) {
        if (this.name != null && this.publicKeyMAC != null) {
            throw new IllegalStateException("name and publicKeyMAC cannot both be set.");
        }
        POPOSigningKeyInput pOPOSigningKeyInput = this.name != null ? new POPOSigningKeyInput(this.name, this.pubKeyInfo) : new POPOSigningKeyInput(this.publicKeyMAC, this.pubKeyInfo);
        CRMFUtil.derEncodeToStream(pOPOSigningKeyInput, contentSigner.getOutputStream());
        return new POPOSigningKey(pOPOSigningKeyInput, contentSigner.getAlgorithmIdentifier(), new DERBitString(contentSigner.getSignature()));
    }
}

