/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.bouncycastle.asn1.x509;

import org.jruby.org.bouncycastle.asn1.ASN1Choice;
import org.jruby.org.bouncycastle.asn1.ASN1Encodable;
import org.jruby.org.bouncycastle.asn1.ASN1Set;
import org.jruby.org.bouncycastle.asn1.ASN1TaggedObject;
import org.jruby.org.bouncycastle.asn1.DEREncodable;
import org.jruby.org.bouncycastle.asn1.DERObject;
import org.jruby.org.bouncycastle.asn1.DERTaggedObject;
import org.jruby.org.bouncycastle.asn1.x509.GeneralNames;

public class DistributionPointName
extends ASN1Encodable
implements ASN1Choice {
    DEREncodable name;
    int type;
    public static final int FULL_NAME = 0;
    public static final int NAME_RELATIVE_TO_CRL_ISSUER = 1;

    public static DistributionPointName getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return DistributionPointName.getInstance(ASN1TaggedObject.getInstance(aSN1TaggedObject, true));
    }

    public static DistributionPointName getInstance(Object object) {
        if (object == null || object instanceof DistributionPointName) {
            return (DistributionPointName)object;
        }
        if (object instanceof ASN1TaggedObject) {
            return new DistributionPointName((ASN1TaggedObject)object);
        }
        throw new IllegalArgumentException("unknown object in factory: " + object.getClass().getName());
    }

    public DistributionPointName(int n, DEREncodable dEREncodable) {
        this.type = n;
        this.name = dEREncodable;
    }

    public DistributionPointName(int n, ASN1Encodable aSN1Encodable) {
        this.type = n;
        this.name = aSN1Encodable;
    }

    public DistributionPointName(GeneralNames generalNames) {
        this(0, generalNames);
    }

    public int getType() {
        return this.type;
    }

    public ASN1Encodable getName() {
        return (ASN1Encodable)this.name;
    }

    public DistributionPointName(ASN1TaggedObject aSN1TaggedObject) {
        this.type = aSN1TaggedObject.getTagNo();
        this.name = this.type == 0 ? GeneralNames.getInstance(aSN1TaggedObject, false) : ASN1Set.getInstance(aSN1TaggedObject, false);
    }

    public DERObject toASN1Object() {
        return new DERTaggedObject(false, this.type, this.name);
    }

    public String toString() {
        String string2 = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DistributionPointName: [");
        stringBuffer.append(string2);
        if (this.type == 0) {
            this.appendObject(stringBuffer, string2, "fullName", this.name.toString());
        } else {
            this.appendObject(stringBuffer, string2, "nameRelativeToCRLIssuer", this.name.toString());
        }
        stringBuffer.append("]");
        stringBuffer.append(string2);
        return stringBuffer.toString();
    }

    private void appendObject(StringBuffer stringBuffer, String string2, String string3, String string4) {
        String string5 = "    ";
        stringBuffer.append(string5);
        stringBuffer.append(string3);
        stringBuffer.append(":");
        stringBuffer.append(string2);
        stringBuffer.append(string5);
        stringBuffer.append(string5);
        stringBuffer.append(string4);
        stringBuffer.append(string2);
    }
}

