/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.bouncycastle.asn1.ess;

import org.jruby.org.bouncycastle.asn1.ASN1Encodable;
import org.jruby.org.bouncycastle.asn1.ASN1EncodableVector;
import org.jruby.org.bouncycastle.asn1.ASN1Sequence;
import org.jruby.org.bouncycastle.asn1.DERObject;
import org.jruby.org.bouncycastle.asn1.DERSequence;
import org.jruby.org.bouncycastle.asn1.ess.OtherCertID;
import org.jruby.org.bouncycastle.asn1.x509.PolicyInformation;

public class OtherSigningCertificate
extends ASN1Encodable {
    ASN1Sequence certs;
    ASN1Sequence policies;

    public static OtherSigningCertificate getInstance(Object object) {
        if (object == null || object instanceof OtherSigningCertificate) {
            return (OtherSigningCertificate)object;
        }
        if (object instanceof ASN1Sequence) {
            return new OtherSigningCertificate((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("unknown object in 'OtherSigningCertificate' factory : " + object.getClass().getName() + ".");
    }

    public OtherSigningCertificate(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() < 1 || aSN1Sequence.size() > 2) {
            throw new IllegalArgumentException("Bad sequence size: " + aSN1Sequence.size());
        }
        this.certs = ASN1Sequence.getInstance(aSN1Sequence.getObjectAt(0));
        if (aSN1Sequence.size() > 1) {
            this.policies = ASN1Sequence.getInstance(aSN1Sequence.getObjectAt(1));
        }
    }

    public OtherSigningCertificate(OtherCertID otherCertID) {
        this.certs = new DERSequence(otherCertID);
    }

    public OtherCertID[] getCerts() {
        OtherCertID[] otherCertIDArray = new OtherCertID[this.certs.size()];
        for (int j = 0; j != this.certs.size(); ++j) {
            otherCertIDArray[j] = OtherCertID.getInstance(this.certs.getObjectAt(j));
        }
        return otherCertIDArray;
    }

    public PolicyInformation[] getPolicies() {
        if (this.policies == null) {
            return null;
        }
        PolicyInformation[] policyInformationArray = new PolicyInformation[this.policies.size()];
        for (int j = 0; j != this.policies.size(); ++j) {
            policyInformationArray[j] = PolicyInformation.getInstance(this.policies.getObjectAt(j));
        }
        return policyInformationArray;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.certs);
        if (this.policies != null) {
            aSN1EncodableVector.add(this.policies);
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

