/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.dataflow.analyses;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jruby.ir.dataflow.DataFlowProblem;
import org.jruby.ir.dataflow.FlowGraphNode;
import org.jruby.ir.dataflow.analyses.LoadLocalVarPlacementNode;
import org.jruby.ir.operands.LocalVariable;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.representations.BasicBlock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadLocalVarPlacementProblem
extends DataFlowProblem {
    private Set<LocalVariable> initLoadsOnExit = new HashSet<LocalVariable>();
    private boolean bindingHasEscaped = false;

    public LoadLocalVarPlacementProblem() {
        super(DataFlowProblem.DF_Direction.BACKWARD);
    }

    @Override
    public String getName() {
        return "Binding Loads Placement Analysis";
    }

    @Override
    public FlowGraphNode buildFlowGraphNode(BasicBlock bb) {
        return new LoadLocalVarPlacementNode(this, bb);
    }

    @Override
    public String getDataFlowVarsForOutput() {
        return "";
    }

    public void initLoadsOnScopeExit(Set<LocalVariable> loads) {
        this.initLoadsOnExit = loads;
    }

    public Set<LocalVariable> getLoadsOnScopeExit() {
        return this.initLoadsOnExit;
    }

    public boolean bindingHasEscaped() {
        return this.bindingHasEscaped;
    }

    public void setBindingHasEscaped(boolean flag) {
        this.bindingHasEscaped = flag;
    }

    public void addLoads(Map<Operand, Operand> varRenameMap) {
        for (FlowGraphNode n : this.flowGraphNodes) {
            LoadLocalVarPlacementNode blpn = (LoadLocalVarPlacementNode)n;
            blpn.addLoads(varRenameMap);
        }
    }
}

