/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.dataflow;

import java.util.BitSet;
import java.util.List;
import org.jruby.ir.dataflow.DataFlowProblem;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.representations.BasicBlock;
import org.jruby.ir.util.Edge;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FlowGraphNode {
    protected DataFlowProblem problem;
    protected BasicBlock basicBlock;
    private BasicBlock rescuer;

    public FlowGraphNode(DataFlowProblem p2, BasicBlock n) {
        this.problem = p2;
        this.basicBlock = n;
        this.rescuer = this.problem.getScope().cfg().getRescuerBBFor(this.basicBlock);
    }

    public abstract void initSolnForNode();

    public abstract void compute_MEET(Edge var1, BasicBlock var2, FlowGraphNode var3);

    public abstract boolean applyTransferFunction();

    public abstract void buildDataFlowVars(Instr var1);

    public void init() {
    }

    public void finalizeSolnForNode() {
    }

    public BasicBlock getBB() {
        return this.basicBlock;
    }

    public void buildDataFlowVars() {
        for (Instr i2 : this.basicBlock.getInstrs()) {
            this.buildDataFlowVars(i2);
        }
    }

    private void processDestBB(List<FlowGraphNode> workList, BitSet bbSet, BasicBlock d) {
        int id2 = d.getID();
        if (!bbSet.get(id2)) {
            bbSet.set(id2);
            workList.add(this.problem.getFlowGraphNode(d));
        }
    }

    public void computeDataFlowInfo(List<FlowGraphNode> workList, BitSet bbSet) {
        block8: {
            block9: {
                BasicBlock b2;
                bbSet.clear(this.basicBlock.getID());
                this.initSolnForNode();
                if (this.problem.getFlowDirection() == DataFlowProblem.DF_Direction.FORWARD) {
                    for (Edge<BasicBlock> e : this.problem.getScope().cfg().getIncomingEdges(this.basicBlock)) {
                        b2 = e.getSource().getData();
                        this.compute_MEET(e, b2, this.problem.getFlowGraphNode(b2));
                    }
                } else if (this.problem.getFlowDirection() == DataFlowProblem.DF_Direction.BACKWARD) {
                    for (Edge<BasicBlock> e : this.problem.getScope().cfg().getOutgoingEdges(this.basicBlock)) {
                        b2 = e.getDestination().getData();
                        this.compute_MEET(e, b2, this.problem.getFlowGraphNode(b2));
                    }
                } else {
                    throw new RuntimeException("Bidirectional data flow computation not implemented yet!");
                }
                this.finalizeSolnForNode();
                boolean changed = this.applyTransferFunction();
                if (!changed) break block8;
                if (this.problem.getFlowDirection() != DataFlowProblem.DF_Direction.FORWARD) break block9;
                for (BasicBlock b2 : this.problem.getScope().cfg().getOutgoingDestinations(this.basicBlock)) {
                    this.processDestBB(workList, bbSet, b2);
                }
                break block8;
            }
            if (this.problem.getFlowDirection() != DataFlowProblem.DF_Direction.BACKWARD) break block8;
            for (BasicBlock b2 : this.problem.getScope().cfg().getIncomingSources(this.basicBlock)) {
                this.processDestBB(workList, bbSet, b2);
            }
        }
    }

    public boolean hasExceptionsRescued() {
        return this.rescuer != null;
    }

    public FlowGraphNode getExceptionTargetNode() {
        return this.problem.getFlowGraphNode(this.rescuer == null ? this.problem.getScope().cfg().getExitBB() : this.rescuer);
    }

    public FlowGraphNode getNonExitBBExceptionTargetNode() {
        return this.rescuer == null ? null : this.problem.getFlowGraphNode(this.rescuer);
    }
}

